﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:nslove="#nslove-functions" exclude-result-prefixes="msxsl nslove">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:include href="userselect.xslt"/>
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<li><span>性　　别：</span><em><xsl:value-of select="nslove:usersex(string(//data/@usersex))"/></em></li>
<li><span>年　　龄：</span><em><xsl:value-of select="//data/@userage"/> 岁</em></li>
<li><span>星　　座：</span><em><xsl:value-of select="nslove:userstar(string(//data/@userstar))"/></em></li>
<li><span>生　　肖：</span><em><xsl:value-of select="nslove:userborn(string(//data/@userborn))"/></em></li>
<li><span>血　　型：</span><em><xsl:value-of select="nslove:blood(string(//data/@blood))"/></em></li>
<li><span>婚姻状况：</span><em><xsl:value-of select="nslove:marriage(string(//data/@marriage))"/></em></li>
<li><span>个　　性：</span><em><xsl:value-of select="nslove:character(string(//data/@character))"/></em></li>
<li><span>子女情况：</span><em><xsl:value-of select="nslove:children(string(//data/@children))"/></em></li>
<li><span>身　　高：</span><em><xsl:value-of select="//data/@height"/> 厘米</em></li>
<li><span>学　　历：</span><em><xsl:value-of select="nslove:education(string(//data/@education))"/></em></li>
<li><span>民　　族：</span><em><xsl:value-of select="nslove:nation(string(//data/@nation))"/></em></li>
<li><span>职　　业：</span><em><xsl:value-of select="nslove:industry(string(//data/@industry))"/></em></li>
<li><span>宗教信仰：</span><em><xsl:value-of select="nslove:belief(string(//data/@belief))"/></em></li>
<li><span>月　　薪：</span><em><xsl:value-of select="nslove:income(string(//data/@income))"/> <xsl:value-of select="nslove:nsplit(string(//data/@workbase),3)"/></em></li>
<li><span>居住情况：</span><em><xsl:value-of select="nslove:houses(string(//data/@houses))"/></em></li>
<li><span>购车情况：</span><em><xsl:value-of select="nslove:autocar(string(//data/@autocar))"/></em></li>
<li><span>所在地区：</span><em><xsl:value-of select="//data/@address"/></em></li>
<li><span>征友地区：</span><em><xsl:value-of select="//data/@findzone"/></em></li>
</xsl:template>
<xsl:template name="match_2">
<li><span>公司行业：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@workbase),0)"/></em></li>
<li><span>公司类型：</span><em><xsl:value-of select="nslove:company(string(//data/@company))"/></em></li>
<li><span>公司名称：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@workbase),4)"/></em></li>
<li><span>工作状态：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@workbase),2)"/></em></li>
<li><span>国　　籍：</span><em><xsl:value-of select="//data/@statetxt"/></em></li>
<li><span>工作地区：</span><em><xsl:value-of select="//data/@waddress"/></em></li>
<li><span>毕业院校：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@university),5)"/></em></li>
<li><span>最大消费：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),0)"/></em></li>
<li><span>家中排行：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),1)"/></em></li>
<li><span>吸　　烟：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),2)"/></em></li>
<li><span>饮　　酒：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),3)"/></em></li>
<li><span>语言能力：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@university),4)"/></em></li>
<li><span>锻炼习惯：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),5)"/></em></li>
<li><span>作息习惯：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),6)"/></em></li>
<li><span>擅长技能：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),8)"/></em></li>
<li><span>父母同住：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),9)"/></em></li>
<li><span>是要孩子：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),10)"/></em></li>
<li><span>影响最大：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),4)"/></em></li>
</xsl:template>
<xsl:template name="match_3">
<li><span>喜欢制造浪漫：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),13)"/></em></li>
<li><span>宠　　物：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@existence),11)"/>，<xsl:value-of select="nslove:nsplit(string(//data/@existence),12)"/></em></li>
<li><span>娱乐休闲：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),7)"/></em></li>
<li><span>兴趣爱好：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),0)"/></em></li>
<li><span>最近关注：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),1)"/></em></li>
<li><span>喜欢的食物：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),2)"/></em></li>
<li><span>喜欢的运动：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),3)"/></em></li>
<li><span>喜欢的电影：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),4)"/></em></li>
<li><span>喜欢旅游去处：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),5)"/></em></li>
<li><span>最近看的书：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@interest),6)"/></em></li>
</xsl:template>
<xsl:template name="match_4">
<li><span>体　　重：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),0)"/> Kg</em></li>
<li><span>相貌自评：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),1)"/></em></li>
<li><span>魅力部位：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),2)"/></em></li>
<li><span>发　　色：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),3)"/></em></li>
<li><span>发　　型：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),4)"/></em></li>
<li><span>脸　　型：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),5)"/></em></li>
<li><span>体　　型：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),6)"/></em></li>
<li><span>眼睛颜色：</span><em><xsl:value-of select="nslove:nsplit(string(//data/@visualize),7)"/></em></li>
</xsl:template>
<xsl:template name="match_5">
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<li><span>年　　龄：</span><xsl:choose><xsl:when test="@minage='0' and @maxage='0'">不限</xsl:when><xsl:otherwise><xsl:value-of select="@minage"/>-<xsl:value-of select="@maxage"/>岁之间</xsl:otherwise></xsl:choose>
</li>
<li><span>身　　高：</span><xsl:choose><xsl:when test="@minheight='0' and @maxheight='0'">不限</xsl:when><xsl:otherwise><xsl:value-of select="@minheight"/>-<xsl:value-of select="@maxheight"/>厘米</xsl:otherwise></xsl:choose></li>
<li><span>婚姻状况：</span><xsl:value-of select="nslove:marriage(string(@marriage))"/></li>
<li><span>月　　薪：</span><xsl:value-of select="nslove:income(string(@income))"/> <xsl:if test="@incmore!='0'">以上</xsl:if></li>
<li><span>学　　历：</span><xsl:value-of select="nslove:education(string(@education))"/> <xsl:if test="@edumore!='0'">以上</xsl:if></li>
<li><span>职　　业：</span><xsl:value-of select="nslove:industry(string(@industry))"/></li>
<li><span>诚信星级：</span><xsl:choose><xsl:when test="@isfaith='0'">不限</xsl:when><xsl:otherwise>认证会员</xsl:otherwise></xsl:choose></li>
<li><span>有无照片：</span><xsl:choose><xsl:when test="@avatar='0'">不限</xsl:when><xsl:otherwise>有照片</xsl:otherwise></xsl:choose></li>
<li id="p100"><span>所在地区：</span><xsl:choose><xsl:when test="@address=''">不限</xsl:when><xsl:otherwise><xsl:value-of select="@address"/></xsl:otherwise></xsl:choose></li>
<li id="tit"><xsl:choose><xsl:when test="@ismust='1'">我要设定必须符合的择友条件</xsl:when><xsl:otherwise>以上择友要求仅供参与，欢迎中意我的异性给我写信</xsl:otherwise></xsl:choose></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>