﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="info"><input type="checkbox" name="id" value="{@id}"/> <b id="fontls"><xsl:value-of select="@username"/></b>,<xsl:value-of select="@userinfo"/></li>
<li id="img"><img src="{@userface}"/></li>
<li id="tt"><b>报名状态：</b><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:when test="@issign='1'">已签到</xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li>
<li id="tt"><font id="fontld"><b>报名时间：</b><xsl:value-of select="@addtime"/></font></li>
<li id="tt"><font id="fontbl"><b>联系方式：</b><xsl:value-of select="@contact"/></font></li>
<li id="note"><b>报名留言：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<li id="info"><input type="checkbox" name="id" value="{@id}"/> <b id="fontls"><xsl:value-of select="@username"/></b>,<xsl:value-of select="@userinfo"/></li>
<li id="img1"><img src="{@userface}"/></li>
<li id="zone"><b>群组头衔：</b><xsl:choose><xsl:when test="@metier='1'"><font id="fontor">版主</font></xsl:when><xsl:when test="@metier='2'"><font id="fontls">管理员</font></xsl:when><xsl:otherwise><font id="fontbl">成员</font></xsl:otherwise></xsl:choose></li>
<li id="zone"><b>当前状态：</b><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li>
<li id="zone"><font id="fontld"><b>入群时间：</b><xsl:value-of select="@addtime"/></font></li>
<li id="note1"><b>入群留言：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li id="dot1"><font id="fontrd">恭喜</font> <a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a> <font id="fontrd">申领成功</font></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="name"><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a></li><li id="info"><xsl:value-of select="@userinfo"/></li><li id="time"><xsl:value-of select="@addtime"/></li><li id="chk"><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li><li id="con"><xsl:value-of select="@contact"/></li><li id="tool"><a onclick="ctrlfile('1','{@id}','{@userid}','报名审核');">审核</a> | <a onclick="ctrlfile('2','{@id}','{@userid}','活动签到');">签到</a> | <a onclick="ctrlfile('5','{@id}','{@userid}','通知会员');">通知</a> | <a onclick="ctrlfile('8','{@id}','{@userid}','删除报名');">删除</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="name"><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a></li><li id="info"><xsl:value-of select="@userinfo"/></li><li id="time"><xsl:value-of select="@addtime"/></li><li id="chk"><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li><li id="con"><xsl:value-of select="@contact"/></li><li id="tool"><a onclick="ctrlfile('1','{@id}','{@userid}','报名审核');">审核</a> | <a onclick="ctrlfile('5','{@id}','{@userid}','通知会员');">通知</a> | <a onclick="ctrlfile('0','{@id}','{@userid}','删除报名');">删除</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul><li id="img"><img src="{@userface}"/></li><li id="info"><em><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a>,<xsl:value-of select="@userinfo"/></em><a onclick="ctrlfile('6','{@id}','{@userid}','预约审核');">审核</a> | <a onclick="ctrlfile('7','{@id}','{@userid}','通知会员');">通知</a> | <a onclick="ctrlfile('8','{@id}','{@userid}','删除预约');">删除</a> | <xsl:value-of select="@addtime"/></li><li id="note"><em><xsl:value-of select="@content"/></em><span>联系方式：(<xsl:choose><xsl:when test="@checked='1'"><font id="fontbl">已审核</font></xsl:when><xsl:otherwise><font id="fontrd">未审核</font></xsl:otherwise></xsl:choose>)<br /><font id="fontld"><xsl:value-of select="@contact"/></font></span></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul>
<li id="info"><input type="checkbox" name="id" value="{@id}"/> <b id="fontls"><xsl:value-of select="@username"/></b>,<xsl:value-of select="@userinfo"/></li>
<li id="img"><img src="{@userface}"/></li>
<li id="tt"><b>报名状态：</b><xsl:choose><xsl:when test="@issign='1'">已成功</xsl:when><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li>
<li id="tt"><font id="fontld"><b>报名时间：</b><xsl:value-of select="@addtime"/></font></li>
<li id="tt"><font id="fontbl"><b>联系方式：</b><xsl:value-of select="@contact"/></font></li>
<li id="note"><b>报名留言：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="name"><em><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a></em><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontor">未审核</font></xsl:otherwise></xsl:choose></li>
<li id="info"><xsl:value-of select="@userinfo"/></li>
<li>报名时间：<xsl:value-of select="@addtime"/></li>
<li>联系方式：<xsl:value-of select="@contact"/></li>
<li id="tool">快捷方式：<a onclick="ctrlfile('1','{@id}','{@userid}','报名审核');">报名审核</a> | <a onclick="ctrlfile('2','{@id}','{@userid}','活动签到');">活动签到</a> | <a onclick="ctrlfile('5','{@id}','{@userid}','通知会员');">再次通知</a> | <a onclick="ctrlfile('8','{@id}','{@userid}','删除报名');">删除报名</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>