﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:nslove="#nslove-functions" exclude-result-prefixes="msxsl nslove">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:include href="userselect.xslt"/>
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul><li id="img"><span><img src="{@filesview}"/></span></li>
<li id="name"><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a></li>
<li>年龄:<xsl:value-of select="@userage"/></li>
<li>学历:<xsl:value-of select="nslove:education(string(@education))"/></li>
<li>职业:<xsl:value-of select="nslove:industry(string(@industry))"/></li>
<li id="note"><xsl:value-of select="@wirenote"/></li>
<li id="btn"><a href="{@link1}" target="{@target}"><img src="/images/vip/btn2.jpg"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data"><ul>
<li id="img1"><span><img src="{@filesview}"/></span></li>
<li id="name"><a href="{@link1}" target="{@target}"><xsl:value-of select="@username"/></a></li>
<li>年龄:<xsl:value-of select="@userage"/></li>
<li>身高:<xsl:value-of select="@height"/> 厘米</li>
<li>体重:<xsl:value-of select="@weight"/> Kg</li>
<li id="note"><xsl:value-of select="@wirenote"/></li>
<li id="btn"><a href="{@link1}" target="{@target}"><img src="/images/vip/btn4.jpg"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></li><li><b>推荐编号：</b><xsl:value-of select="@id"/></li><li><b>基本信息：</b><xsl:value-of select="@userage"/> 岁,<xsl:value-of select="@address"/>，学历:<xsl:value-of select="nslove:education(string(@education))"/>，婚姻:<xsl:value-of select="nslove:marriage(string(@marriage))"/>，职业:<xsl:value-of select="nslove:industry(string(@industry))"/></li><li><b>兴趣爱好：</b><xsl:value-of select="@interest"/></li><li><span><b>红娘介绍：</b></span><em><xsl:value-of select="@wirenote"/></em></li><li id="btn"><a href="{@link1}" target="{@target}"><img src="/images/vip/btn2_3.jpg"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<dd class="nobg"><span>年龄：<xsl:value-of select="@userage"/></span>生肖：<xsl:value-of select="nslove:userborn(string(@userborn))"/></dd>
<dd class="nobg"><span>身高：<xsl:value-of select="@height"/></span>体重：<xsl:value-of select="@weight"/> Kg</dd>
<dd><span>星座：<xsl:value-of select="nslove:userstar(string(@userstar))"/></span>常驻地：<xsl:value-of select="@userzone"/></dd>
<dd><span>户口地区：<xsl:value-of select="@address"/></span>学历：<xsl:value-of select="nslove:education(string(@education))"/></dd>
<dd><span>婚姻状况：<xsl:value-of select="nslove:marriage(string(@marriage))"/></span>职业：<xsl:value-of select="nslove:industry(string(@industry))"/></dd>
<dd><span>资产状况：<xsl:value-of select="nslove:asset(string(@asset))"/></span></dd>
<dd id="tit">兴趣爱好：</dd>
<dd><xsl:value-of select="@interest"/></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<xsl:choose><xsl:when test="@minage='0' and @maxage='0'">年龄：不限</xsl:when><xsl:otherwise><xsl:value-of select="@minage"/>-<xsl:value-of select="@maxage"/>岁</xsl:otherwise></xsl:choose>，<xsl:choose><xsl:when test="@minheight='0' and @maxheight='0'">身高：不限</xsl:when><xsl:otherwise><xsl:value-of select="@minheight"/>-<xsl:value-of select="@maxheight"/> cm</xsl:otherwise></xsl:choose>，学历：<xsl:value-of select="nslove:education(string(@education))"/> <xsl:if test="@edumore!='0'"> 以上</xsl:if>，婚姻状态：<xsl:value-of select="nslove:marriage(string(@marriage))"/>，月薪：<xsl:value-of select="nslove:income(string(@income))"/> <xsl:if test="@incmore!='0'">以上</xsl:if><xsl:choose><xsl:when test="@ismust='1'"><br />我要设定必须符合的择友条件</xsl:when><xsl:otherwise><br />以上择友要求仅供参与，欢迎中意我的异性给我写信</xsl:otherwise></xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>