﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul id="Layer{@id}" class="{@topskin}" style="top:{@topdiv}px;left:{@leftdiv}px;z-index:{@zindex}" onmousedown="Move(this,event)" ondblclick="Show('{@id}')"><li id="tt"><span>编号[<xsl:choose><xsl:when test="@serialid!=''"><xsl:value-of select="@serialid"/></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>]</span><em id="pre" onclick="Show_{@showtype}('{@id}');" title="最大化字条">&#160;</em><em onclick="Close('{@id}');" title="关闭字条">&#160;</em></li><li id="img"><img src="{@userface}"/></li><li id="to"><xsl:value-of select="@username"/></li><li id="note"><xsl:value-of select="@content"/></li><li id="fr"><xsl:value-of select="@fusername"/></li><li id="tb"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<li id="dot1"><a id="{@id}_title" title="{@content}" href="javascript:setStr('{@id}');" ><xsl:value-of select="@content"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul><li id="img"><img src="{@filesview}" title="使用期限：{@deadline}天&#13;&#10;使用次数：{@degrees}" onclick="selSkinID('{@id}','/upload/{@filesname}','{@fileshape}','{@positions}','{@fontcolor}');"/></li><li id="tt"><xsl:value-of select="@sortname"/></li><li id="pr">价格：<xsl:choose><xsl:when test="@prices='0'">免费</xsl:when><xsl:otherwise><xsl:value-of select="@prices"/> 金币</xsl:otherwise></xsl:choose>
</li><li id="tol"><img src="/images/wall/sy.jpg" onclick="selSkinID('{@id}','/upload/wall/{@filesname}','{@fileshape}','{@positions}','{@fontcolor}');"/> <img src="/images/wall/by.jpg" onclick="buySkin('{@id}');"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="tl1"><xsl:choose><xsl:when test="@serialid!=''"><xsl:value-of select="@serialid"/></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose></li><li id="tl2"><a href="javascript:Show_{@showtype}('{@id}')"><xsl:value-of select="@content"/></a></li><li id="tl3"><xsl:value-of select="@username"/></li><li id="tl3"><xsl:value-of select="@fusername"/></li><li id="tl4"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<dd id="dot1"><a href="/wall/index.asp?action=my" target="_blank"><xsl:value-of select="@content"/></a></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>