<?php

namespace Timo\cli;

define('DR', DIRECTORY_SEPARATOR);
define('ROOT_PATH', dirname(dirname(__DIR__)) . DR);
define('FRAME_PATH', dirname(__DIR__) . DR);

date_default_timezone_set('Asia/Chongqing');

class Tool
{
    protected $command = null;

    protected $params = array();

    public function __construct()
    {
        $this->parseParams();
    }

    public function run()
    {
        if (!method_exists($this, $this->command)) {
            die("There is an error in the input command\n");
        }

        call_user_func_array(array($this, $this->command), $this->params);
    }

    /**
     * 创建一个项目
     *
     * @param string $project_name
     */
    public function create($project_name = '')
    {
        if (empty($project_name)) {
            die("please input project name\n");
        }

        $project_dir = ROOT_PATH . $project_name;

        if (is_dir($project_dir)) {
            die("project " . $project_name . " is exists.");
        }

        mkdir($project_dir, 0755);

        $dirs = array(
            'app/web/controller',
            'app/web/model',
            'app/web/template/default/Index',
            'app/web/view',
            'cache',
            'config',
            'lib',
            'logs',
            'model',
            'public/web/static/css',
            'public/web/static/images',
            'public/web/static/js',
        );

        $project_path = $project_dir . DR;

        foreach($dirs as $dir) {
            mkdir($project_path . $dir, 0755, true);
        }

        copy(FRAME_PATH . 'bin/copy/app.config.default.php', $project_path . 'app/web/config.php');
        copy(FRAME_PATH . 'bin/copy/db.config.default.php', $project_path . 'config/db.config.php');
        $puts = array(
            0 => array(
                'file' => $project_path . 'app/web/controller/Index.php',
                'cont' => $this->getController()
            ),
            1 => array(
                'file' => $project_path . 'app/web/template/default/Index/index.tpl.php',
                'cont' => "<h1>TimoPHP is a Fast Sample Smart MVC+ Framework.</h1>"
            ),
            2 => array(
                'file' => $project_path . 'public/web/index.php',
                'cont' => $this->getIndex()
            ),
            3 => array(
                'file' => $project_path . 'bootstrap.php',
                'cont' => $this->getBootstrap()
            ),
            4 => array(
                'file' => $project_path . 'config/common.config.php',
                'cont' => "<?php\r\nreturn [];"
            ),
        );
        foreach ($puts as $put)
        {
            file_put_contents($put['file'], $put['cont']);
        }

        echo 'create success ' . $project_name;
    }

    private function getController()
    {
$str = <<<EOD
<?php

namespace app\web\controller;

use Timo\Core\Controller;

class Index extends Controller
{
	public function index()
	{
		return \$this->render();
	}
}

EOD;
        return $str;
    }

    function getIndex()
    {
$str = <<<EOD
<?php

define('APP_NAME', 'web');
define('APP_DEBUG', true);

require '../../bootstrap.php';

\$engine = new \Timo\Core\Engine();
\$engine->start();

EOD;
        return $str;
    }

    private function getBootstrap()
    {
$str = <<<EOD
<?php

session_name('TM');

define('DR', DIRECTORY_SEPARATOR);
define('ROOT_PATH', __DIR__ . DR);
define('APP_DIR_PATH', ROOT_PATH . 'app' . DR);

date_default_timezone_set('Asia/Chongqing');

require ROOT_PATH . '../TimoPHP/boot.php';

EOD;
        return $str;
    }

    private function parseParams()
    {
        global $argv;
        global $argc;
        if ($argc < 2) {
            die("Lack of command parameters\n create project_name\n");
        }

        $this->command = $argv[1];

        $this->params = array_slice($argv, 2);
    }
}

$tool = new Tool();
$tool->run();
