<?php

/*
  XPHP V0.1.100 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

class Controller extends BaseApp {

    protected $tpl;

    //父类资源
    public function __construct() {
        parent::__construct();
        $this->LoadUserClass(); //框架全局载入
    }

    //载入用户定义的常用类
    public function LoadUserClass() {
        //载入模版
        $template = $this->_XPHP['config']['base']['tpl'];
        //控制器载入模版
        if ($template) {
            $this->getTplClass();
        }
        $helps = $this->_XPHP['config']['base']['helps'];
        $load = $this->_XPHP['config']['base']['libs']['load'];
        $import = $this->_XPHP['config']['base']['libs']['import'];
        //控制器载入数据层
        $this->getModuleClass(); //不需要数据层被动调用,这里选择使用主动调用
        //载入全局函数
        if (is_array($helps) && !empty($helps)) {
            foreach ($helps as $key => $val) {
                $this->LoadSysHelps($val);
            }
        }
        //载入全局类载入类并且实例化
        if (is_array($load) && !empty($load)) {
            foreach ($load as $key => $val) {
                $this->$val = $this->LoadSysLibs($val);
            }
        }
        //载入全局类只是载入类库,不实例化
        if (is_array($import) && !empty($import)) {
            foreach ($import as $key => $val) {
                $this->$val = $this->LoadSysLibs($val, false);
            }
        }
    }
       
    //载入模版层
    public function getTplClass() {
        Loader::loadLib('libs/smarty', 'Smarty.class');
        $this->tpl = new Smarty();
        $this->tpl->template_dir = AppViews;
        $this->tpl->compile_dir = AppViews_c;
        $this->tpl->left_delimiter = '{{';
        $this->tpl->right_delimiter = '}}';
        return $this->tpl;
    }

    //载入数据层
    public function getModuleClass() {
        $model = glob(AppModel . '*.php');
        if (!empty($model)) {
            foreach ($model as $f) {
                $basename = pathinfo($f);
                $var = $basename['filename'];
                Loader::loadModel($var);
                return $this->$var = new $var();
            }
        }
    }
      
    //载入用户自定义函数类库
    public function LoadSysHelps($var) {
        return Loader::loadLib('helps', $var);
    }

    //载入系统类库
    public function LoadSysLibs($filename, $instantiation = true) {
        Loader::loadLib('libs', $filename);
        if ($instantiation) {
            return new $filename;
        }
    }

}