<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

//模型基类
abstract class BaseModel extends Object {
    
}

//基本数据库类
class BaseLayer extends BaseModel {

    protected static $user;
    protected static $_db;

    //构造函数
    public function __construct() {
        parent::__construct();
        try {
            self::$user = $this->_XPHP['db']; //用户的配置文件
            self::cutDB();
        } catch (PDOException $e) {
            throw new Exception('XPHP:DB配置为空');
        }
    }

    //链接DB
    public static function pdoConnect($db) {
        try {
            $dbconn = array(
                'dns' => "{$db['dbtype']}:host={$db['hostname']};dbname={$db['database']}",
                'dbuser' => $db['username'],
                'dbpwd' => $db['password'],
                'charset' => $db['charset'],
            );
            if ($db['isconn']) { //如果为true链接
                self::$_db = new PDO($dbconn['dns'], $dbconn['dbuser'], $dbconn['dbpwd'], array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES '{$dbconn['charset']}'"));
            }
        } catch (PDOException $e) {
            throw new Exception('XPHP:PDO链接失败,主机不存在或者链接用户名错误');
        }
    }

    //数据库链接
    public static function cutDB($var = 'master') {
        if (!empty($var) && !empty(self::$user[$var])) {
            BaseLayer::pdoConnect(self::$user[$var]);
        }
    }

    //析构函数
    public function __destruct() {
        self::$_db = null;
    }

}

//PDO 数据库操作封装
class Model extends BaseLayer {

    //构造函数
    public function __construct() {
        parent::__construct();
    }

    //PDO转意
    public function quote($str) {
        return self::$_db->quote($str);
    }

    //PDO 插入方法封装
    public function insert($table, $val) {
        $sql = "INSERT INTO $table (`" . implode('`,`', array_keys($val)) . "`) VALUES('" . implode("','", $val) . "')";
        return self::$_db->query($sql);
    }

    //PDO 更新方法封装
    public function update($table, $val, $where = '') {
        if ($where) {
            $sql = '';
            foreach ($val as $key => $val) {
                $sql .= ", `$k`='" . $v . "'";
            }
            $sql = rtrim($sql, ',');
            $sql = "UPDATE `$tablename` SET $sql WHERE $where";
        }
        return self::$_db->query($sql);
    }

    //PDO 查看数据的数据元素方式
    private function fetchType($type) {
        switch ($type) {
            case "assoc":
                $fetch = PDO::FETCH_ASSOC; //asso array
                break;
            case "num":
                $fetch = PDO::FETCH_NUM; //num array
                break;
            case "object":
                $fetch = PDO::FETCH_OBJ; //object array
                break;
            case "both":
                $fetch = PDO::FETCH_BOTH; //assoc array and num array
                break;
            default:
                $fetch = PDO::FETCH_ASSOC;
                break;
        }
        return $fetch;
    }

    //PDO 取得一行数据
    public function getOne($sql, $type = 'assoc') {
        return self::$_db->query($sql)->fetch($this->fetchType($type));
    }

    //PDO 取得所有数据
    public function getAll($sql, $type = 'assoc') {
        return self::$_db->query($sql)->fetchAll($this->fetchType($type));
    }

}