<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

//陆由
class Router extends Object {

    private static $_instance;

    //获取父类变量
    public static function getInstance() {
        if (!isset(self::$_instace)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    //获取当前url,并全局过滤，防止注入
    public function currentURL() {
        //获取URL的Query字符串
        $query = $_SERVER['REQUEST_URI'];
        if (preg_match('/and|select|insert|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile/', $query)) {
            throw new Exception('XPHP:你想干嘛');
        }
        $bad = array('$', '(', ')', '%28', '%29');
        $good = array('&#36;', '&#40;', '&#41;', '&#40;', '&#41;');
        $query = str_replace($bad, $good, $query);
        if (strpos($query, '.')) {
            //URL有了后缀
            $urlarr = explode('.', $query);
            $query = $urlarr[0];
            if ($urlarr[1] != $this->_XPHP['config']['url']['suffix']) {
                throw new Exception('XPHP:404,该页面不存在');
            }
        }
        return $query;
    }

    //这里是路由规则
    public function createURL($url) {
        $userurl = $this->_XPHP['config']['url']['router'];
        $map = $this->_XPHP['config']['url']['map'];
        switch ($userurl) {
            case 'default': //智能模式
                $urlarr = $this->pathUrl($url);
                if ((empty($urlarr['controller']) && empty($urlarr['action'])) || $urlarr == false) {
                    $urlarr = $this->rewriteUrl($url, $map);
                }
                break;
            case 'path': //原生模式
                $urlarr = $this->pathUrl($url);
                break;
            case 'rewrite': //重写模式
                $urlarr = $this->rewriteUrl($url, $map);
                break;
            default :
                break;
        }
        return $urlarr;
    }

    //原生模式
    public function pathUrl($url) {
        $controller = isset($_GET['c']) ? $_GET['c'] : '';
        $action = isset($_GET['a']) ? $_GET['a'] : '';
        if (!empty($controller) && !empty($action)) {
            return array(
                'controller' => $controller,
                'action' => $action
            );
        } else {
            return false;
        }
    }

    //重写模式
    public function rewriteUrl($url, $map) {
        if (empty($url)) {
            return array(
                'controller' => '',
                'action' => ''
            );
        }
        //$map优先级比$url高
        if (is_array($map) && !empty($map)) {
            if (isset($map[$url[0]]) && !empty($map[$url[0]])) {
                $maparr = explode('/', $map[$url[0]]);
                unset($url[0]);
                return array(
                    'controller' => $maparr[0],
                    'action' => $maparr[1],
                    'parameters' => array_values($url)
                );
            }
        }
        if (!empty($url)) {
            if (strpos($url[0], '?') === false && !empty($url)) {
                $controller = isset($url[0]) ? $url[0] : '';
                $action = isset($url[1]) ? $url[1] : '';
                unset($url[0], $url[1]);
                return array(
                    'controller' => $controller,
                    'action' => $action,
                    'parameters' => array_values($url)
                );
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    //获取url分析url拆分控制器和动作以及参数,url为智能分辨(index.php?c=home&a=test&t=1111
    public function getAppUrl() {
        $query = $this->currentURL();
        //preg_match("/.[^\.\/]+$/", $query, $matches);//正则匹配出URL
        //print_r($matches);
        //不为空下切分字符串
        if (!empty($query)) {
            $urlarr = array();
            $queryarr = array_values(array_filter(str_replace(array('index.php'), array(''), explode('/', $query))));
            ksort($queryarr); //按照Key值排序
            $urlarr = $this->createURL($queryarr);
            return $urlarr;
        } else {
            throw new Exception('XPHP:URL地址为空');
        }
    }

    //分析控制器和动作
    public function parseAction($app_dir) {
        $module = $this->getAppUrl();
        //print_r($module); //路由器分析结果数组
        if (empty($module['controller']) && empty($module['action'])) {
            $module['controller'] = $this->_XPHP['config']['base']['controller'];
            $module['action'] = $this->_XPHP['config']['base']['action'];
        }
        $action = $app_dir . $module['controller'] . ".php";
        if (file_exists($action)) {
            require_once $action;
            return $module;
        }
    }

}