<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

//系统类加载函数,载入用户调用的第三方扩展
function L($file) {
    $file = AppExpansion.$file.'.php';
    if (is_readable($file)) {
        require_once $file;
    }
}

//用户使用原生态PHP模版
function V($filename, $data) {
    extract($data, EXTR_OVERWRITE);
    require(AppViews . $filename . '.php');
}

//取得用户的终端类型
function getMachineTypeName() {
    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    if (empty($user_agent)) {
        return 'unknown';
    }
    if (preg_match('~xmidea~is', $user_agent)) {
        return 'xmidea';
    }
    if (preg_match('~(windows|macintosh|Ubuntu)~is', $user_agent)) {
        return 'pc';
    } else if (preg_match('~ipad~is', $user_agent)) {
        return 'pad';
    } else if (preg_match('~(Android|iPhone)~is', $user_agent)) {
        return 'mobile';
    } else {
        return 'pc';
    }
}

//获得用户浏览器信息
function getClientBrowser() {
    $browser = array(
        'MetaSr', //sogou
        '360SE', //360浏览器
        'Maxthon',
        'Chrome',
        'Safari',
        'Opera',
        'Konqueror',
        'Lynx',
        'Netscape',
        'NetCaptor',
        "Firefox",
        'MSIE 9.0',
        'MSIE 8.0',
        'MSIE 7.0',
        'MSIE 6.0'
    );
    $client_browser = 'unknow';
    foreach ($browser as $v) {
        if (strpos($_SERVER['HTTP_USER_AGENT'], $v) !== false) {
            $client_browser = $v;
            break;
        }
    }
    return $client_browser;
}

//获得用户操作系统
function getClientSystem() {
    $system = array(
        'iPad' => 'iPad',
        'Android' => "Android",
        'iPone' => "iPone",
        'Windows 7' => 'NT 6.1',
        'Windows Vista' => 'NT 6.0',
        'Windows 2003' => 'NT 5.2',
        'Windows XP' => 'NT 5.1',
        'Windows 2000' => 'NT 5',
        'Windows ME' => '4.9',
        'Windows NT 4' => 'NT 4',
        'Windows 98' => '98',
        'Windows 95' => '95',
        'Mac' => 'Mac',
        'Linux' => 'Linux',
        'Unix' => 'Unix',
        'FreeBSD' => 'FreeBSD',
        'SunOS' => 'SunOS',
        'OS/2' => 'OS/2',
        'BeOS' => 'BeOS',
        'Macintosh' => 'PC');
    $client_system = 'unknow';
    foreach ($system as $k => $v) {
        if (strpos($_SERVER['HTTP_USER_AGENT'], $v) !== false) {
            $client_system = $v;
            break;
        }
    }

    return $client_system;
}

//获取用户IP
function getClientIp() {
    $onlineip = "";
    if (getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
        $onlineip = getenv('HTTP_CLIENT_IP');
    } elseif (getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
        $onlineip = getenv('HTTP_X_FORWARDED_FOR');
    } elseif (getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
        $onlineip = getenv('REMOTE_ADDR');
    } elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
        $onlineip = $_SERVER['REMOTE_ADDR'];
    }
    return $onlineip;
}

//判断是否为手机号
function isMobile($var) {
    return preg_match('~1[358][0-9]{9}~is', $var);
}

//dz的加密解密函数
function authCode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
    $ckey_length = 4;
    $key = md5($key ? $key : '!@#$%^&*()___+');
    $keya = md5(substr($key, 0, 16));
    $keyb = md5(substr($key, 16, 16));
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length) : substr(md5(microtime()), -$ckey_length)) : '';
    $cryptkey = $keya . md5($keya . $keyc);
    $key_length = strlen($cryptkey);
    $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
    $string_length = strlen($string);
    $result = '';
    $box = range(0, 255);
    $rndkey = array();
    for ($i = 0; $i <= 255; $i++) {
        $rndkey[$i] = ord($cryptkey[$i % $key_length]);
    }
    for ($j = $i = 0; $i < 256; $i++) {
        $j = ($j + $box[$i] + $rndkey[$i]) % 256;
        $tmp = $box[$i];
        $box[$i] = $box[$j];
        $box[$j] = $tmp;
    }
    for ($a = $j = $i = 0; $i < $string_length; $i++) {
        $a = ($a + 1) % 256;
        $j = ($j + $box[$a]) % 256;
        $tmp = $box[$a];
        $box[$a] = $box[$j];
        $box[$j] = $tmp;
        $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }
    if ($operation == 'DECODE') {
        if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
            return substr($result, 26);
        } else {
            return '';
        }
    } else {
        return $keyc . str_replace('=', '', base64_encode($result));
    }
}

//将图片地址转换成html
function img($var,$alt) {
    return "<img scr='$var' alt='$alt'>";
}

//将用户传递来的ul ol 转换成html
/*
 * $ul = array('id' => 'xphp','class' => 'xphp')
 * $ol = array('php','python','ruby')
 */
function ul($ul,$ol) {
    $str = '<ul ';
    foreach($ul as $key => $val) {
        $str .= " $key= '$val' ";
    }
    $str .= '>';
    foreach($ol as $key => $val) {
        $str .= " <li>$val</li> ";
    }
    $str .= '</ul>';
    return $str;
}

//替换一段字符中任意位置
function str_replace_custom($text,$word,$cword,$pos = array(1) ) {
    $text_array = explode($word,$text);
    $num = count($text_array) - 1;
    if(empty($pos)) {
        return false; //找不到替换次数,替换次数比数组大
    }
    array_walk($pos, 'arrwalk');
    $result_str = '';
    for($i = 0;$i <= $num; $i++) { //词语的次数
        if( in_array($i,$pos) ) { //$i == $pos - 1
            $result_str .= $text_array[$i].$cword; //替换新词
        } else {
            $result_str .= $text_array[$i].$word; //旧词
        }
    }
    return rtrim($result_str,$word);
}

function arrwalk(&$val) {
    $val = $val - 1;
}

/*
$imgSrc：目标图片
$markImg：水印图片
$markText：给图片添加的水印文字
$TextColor：水印文字的字体颜色
$markPos：图片水印添加的位置，取值范围：0~9[0：随机位置，在1~8之间随机选取一个位置 1：顶部居左 2：顶部居中 3：顶部居右 4：左边居中 5：图片中心 6：右边居中 7：底部居左 8：底部居中 9：底部居右]
$fontType：具体的字体库，可带相对目录地址
$markType：图片添加水印的方式，img代表以图片方式，text代表以文字方式添加水印
 */
function setWater($imgSrc, $markImg = '', $markText, $TextColor, $markPos, $fontType, $markType = 'text') {
    if (empty($imgSrc)) {
        return false;
    }

    $srcInfo = getimagesize($imgSrc); //获取图片的尺寸和类型
    $srcImg_w = $srcInfo[0]; //宽
    $srcImg_h = $srcInfo[1]; //高

    switch ($srcInfo[2]) { //类别
        case 1:
            $srcim = imagecreatefromgif($imgSrc);
            break;
        case 2:
            $srcim = imagecreatefromjpeg($imgSrc);
            break;
        case 3:
            $srcim = imagecreatefrompng($imgSrc);
            break;
        default:
            exit("不支持的图片文件类型");
    }

    if ($markType == "img") {
        if (!file_exists($markImg) || empty($markImg)) {
            return false;
        }

        $markImgInfo = getimagesize($markImg); //水印图片
        $markImg_w = $markImgInfo[0];
        $markImg_h = $markImgInfo[1];

        if ($srcImg_w < $markImg_w || $srcImg_h < $markImg_h) { //水印图片不能比原图大
            return false;
        }

        switch ($markImgInfo[2]) {
            case 1:
                $markim = imagecreatefromgif($markImg);
                break;
            case 2:
                $markim = imagecreatefromjpeg($markImg);
                break;
            case 3:
                $markim = imagecreatefrompng($markImg);
                break;
            default:
                die("不支持的水印图片文件类型");
                exit;
        }

        $logow = $markImg_w;
        $logoh = $markImg_h;
    }


    if ($markType == "text") {
        $fontSize = 16; //字体大小
        if (!empty($markText)) {
            if (!file_exists($fontType)) {
                return false;
            }
        } else {
            return false;
        }

        $box = imagettfbbox($fontSize, 0, $fontType, $markText);
        $logow = max($box[2], $box[4]) - min($box[0], $box[6]);
        $logoh = max($box[1], $box[3]) - min($box[5], $box[7]);
    }

    if ($markPos == 0) { //0是随机位置
        $markPos = rand(1, 9);
    }

    switch ($markPos) {
        case 1:
            $x = +5;
            $y = +5;
            break;
        case 2:
            $x = ($srcImg_w - $logow) / 2;
            $y = +5;
            break;
        case 3:
            $x = $srcImg_w - $logow - 5;
            $y = +15;
            break;
        case 4:
            $x = +5;
            $y = ($srcImg_h - $logoh) / 2;
            break;
        case 5:
            $x = ($srcImg_w - $logow) / 2;
            $y = ($srcImg_h - $logoh) / 2;
            break;
        case 6:
            $x = $srcImg_w - $logow - 5;
            $y = ($srcImg_h - $logoh) / 2;
            break;
        case 7:
            $x = +5;
            $y = $srcImg_h - $logoh - 5;
            break;
        case 8:
            $x = ($srcImg_w - $logow) / 2;
            $y = $srcImg_h - $logoh - 5;
            break;
        case 9:
            $x = $srcImg_w - $logow - 5;
            $y = $srcImg_h - $logoh - 5;
            break;
        default:
            exit("此位置不支持");
    }

    $dst_img = imagecreatetruecolor($srcImg_w, $srcImg_h);
    imagecopy($dst_img, $srcim, 0, 0, 0, 0, $srcImg_w, $srcImg_h);

    //生成img水印
    if ($markType == "img") {
        imagecopy($dst_img, $markim, $x, $y, 0, 0, $logow, $logoh);
        imagedestroy($markim);
    }

    //生成文本水印
    if ($markType == "text") {
        $rgb = explode(',', $TextColor);
        $color = imagecolorallocate($dst_img, $rgb[0], $rgb[1], $rgb[2]);
        imagettftext($dst_img, $fontSize, 0, $x, $y, $color, $fontType, $markText);
    }

    //拼合图片
    switch ($srcInfo[2]) {
        case 1:
            imagegif($dst_img, $imgSrc);
            break;
        case 2:
            imagejpeg($dst_img, $imgSrc);
            break;
        case 3:
            imagepng($dst_img, $imgSrc);
            break;
        default:
            exit("不支持的水印图片文件类型");
    }

    imagedestroy($dst_img);
    imagedestroy($srcim);
}