<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

class mem extends Object {

    private $conn;
    private $mem;
    private $m;

    //构造函数
    public function __construct() {
        $this->conn = Loader::loadCfg('mem');
        if (empty($this->conn)) {
            throw new Exception('XPHP:Memcache/Memcached配置文件为空');
        }
        foreach ($this->conn as $key => $val) {
            $this->m = $key;
            if (class_exists($key)) {
                $this->mem = new $key;
                foreach ($val as $k => $v) {
                    //向Memcache/Memcached链接池中添加服务器
                    $this->mem->addserver($v['host'], $v['port']);
                }
            } else {
                throw new Exception('XPHP:不支持' . $this->m);
            }
        }
    }

    //插入数据set 
    public function set($key, $data, $ttl = 3600) {
        if ($this->m == 'memcached') {
            return $this->mem->set($key, array($data, time(), $ttl), $ttl);
        } elseif ($this->m == 'memcache') {
            return $this->mem->set($key, array($data, time(), $ttl), 0, $ttl);
        }
        return false;
    }

    //获取数据get
    public function get($key) {
        $data = $this->mem->get($key);
        return (is_array($data)) ? $data[0] : false;
    }

    //删除数据
    public function del($key) {
        return $this->mem->delete($key);
    }

    //作废缓存中所有元素
    public function flush() {
        return $this->mem->flush();
    }

    //获取mem状态
    public function memStatus() {
        return $this->mem->getStats();
    }

    //获取Cache版本
    public function memVersion() {
        return $this->mem->getVersion();
    }

    //关闭memcache
    public function __destruct() {
        if ($this->mem != null) {
            $this->mem->close();
        }
    }

}