<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
defined('XPHP') or die('XPHP:Restricted access');

class res extends Object {

    private $conn;
    private $res;

    //构造函数
    public function __construct() {
        $this->conn = Loader::loadCfg('res');
        if (empty($this->conn)) {
            throw new Exception('XPHP:Redis配置文件为空');
        }
        if (!class_exists('redis')) {
            throw new Exception('XPHP:不支持Redis');
        }
        $this->res = new Redis();
        $this->res->connect($this->conn['host'], $this->conn['port']);
    }

    //插入数据set 
    public function set($key, $data, $ttl = 0) {
        $data = json_encode($data, true);
        $res = $this->res->set($key, $data);
        if ($ttl > 0) {
            $this->res->setTimeout($key, $ttl);
        }
        return $res;
    }

    //获取数据get
    public function get($key) {
        $res = $this->res->get($key);
        return json_decode($res, true);
    }

    //删除数据
    public function del($key) {
        return $this->res->delete($key);
    }

    //作废缓存中所有元素
    public function flush() {
        return $this->res->flushAll();
    }

    //数据入队列
    public function push($key, $data, $right = true) {
        $data = json_encode($data);
        return $right ? $this->res->rPush($key, $data) : $this->res->lPush($key, $data);
    }

    //数据出队列
    public function pop($key, $left = true) {
        $val = $left ? $this->res->lPop($key) : $this->res->rPop($key);
        return json_decode($val);
    }

    //数据自增
    public function increment($key) {
        return $this->res->incr($key);
    }

    //数据自减
    public function decrement($key) {
        return $this->res->decr($key);
    }

    //检查key是否存在
    public function exists($key) {
        return $this->res->exists($key);
    }

    //获取Redis的版本信息
    public function resVersion() {
        return $this->res->info();
    }

    //关闭Redis
    public function __destruct() {
        if ($this->res != null) {
            $this->res->close();
        }
    }

}