<?php

/*
  XPHP V1.0 beta
  Author:phper.yang@gmail.com(houhuiyang)
 */
define('RunStime', microtime());
define('RunSmem', memory_get_usage());
define('XPHP', true);
set_error_handler(array('BaseApp', 'errorHandler'));
set_exception_handler(array('BaseApp', 'exceptionHandler'));

//定义App目录&&定义用户的控制器
define('App', dirname($_SERVER['SCRIPT_FILENAME'])); //定义根目录
define('AppController', App . DIRECTORY_SEPARATOR . 'controller' . DIRECTORY_SEPARATOR); //定义控制器
define('AppModel', App . DIRECTORY_SEPARATOR . 'model' . DIRECTORY_SEPARATOR); //定义数据层
define('AppViews', App . DIRECTORY_SEPARATOR . 'views' . DIRECTORY_SEPARATOR); //模板文件
define('AppViews_c', App . DIRECTORY_SEPARATOR . 'views/templates_c' . DIRECTORY_SEPARATOR); //编译文件
define('AppConfig', App . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR); //用户配置文件
define('AppHooks', App . DIRECTORY_SEPARATOR . 'expansion' . DIRECTORY_SEPARATOR. 'hooks.php'); //定义钩子(钩子也放到扩展文件夹)
define('AppExpansion', App . DIRECTORY_SEPARATOR . 'expansion' . DIRECTORY_SEPARATOR); //定义用户自定义扩展文件
//定义错误级别
deBug();

//对象基类

abstract class Object {

    protected $_XPHP;

    //构造框架全局变量XPHP
    public function __construct() {
        $this->_XPHP = array(
            'files' => get_included_files(),
            'config' => Loader::loadCfg('config'),
            'db' => Loader::loadCfg('db'),
            'run' => array(
                'stime' => floatval(RunStime),
                'etime' => floatval(RunEtime),
                'run' => floatval(RunEtime - RunStime),
            ),
            'mem' => array(
                'smem' => floatval(RunSmem),
                'emem' => floatval(RunEmem),
                'mem' => ((RunEmem - RunSmem) / 1024 / 1024) . "M",
            )
        );
    }

}

//应用程序基类
abstract class BaseApp extends Object {

    protected $_GET;
    protected $_POST;
    protected $_COOKIE;
    protected $_REQUEST;

    //构造函数，递归过滤框架中的$_GET等...
    public function __construct() {
        parent::__construct();
        $this->_GET = $this->addslashes_deep($_GET);
        $this->_POST = $this->addslashes_deep($_POST);
        $this->_COOKIE = $this->addslashes_deep($_COOKIE);
        $this->_REQUEST = $this->addslashes_deep($_REQUEST);
        $this->router = Router::getInstance();
        $this->_XPHP = array_merge_recursive($this->_XPHP, array('parse' => $this->router->parseAction(AppController)));
    }

    //过滤函数
    static function addslashes_deep($var) {
        if (!empty($var) && !get_magic_quotes_gpc()) {
            return is_array($var) ? array_map(array('BaseApp', 'addslashes_deep'), $var) : addslashes($var);
        }
    }

    //静态函数错误处理
    static public function errorHandler($errno, $errstr, $errfile, $errline) {
        throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
    }

    //静态函数错误处理(具体信息)
    static public function exceptionHandler($e) {
        ob_start();
        include AppViews . 'error.php';
        $buffer = ob_get_contents();
        ob_end_clean();
        echo $buffer;
    }

}

//程序App
class App extends BaseApp {

    //构造函数
    public function __construct() {
        parent::__construct();
    }

    //App开始工作
    public function run() {
        try {
            //路由
            $route_path = $this->_XPHP['parse'];
            if ($route_path) {
                extract($route_path);
                $controller = ucfirst(trim($controller));
                $app = new $controller();
                $fun = get_class_methods($app);
                if (in_array($action, $fun)) {
                    if(file_exists(AppHooks)) { //引入用户自定义全局钩子文件
                        require(AppHooks);
                    }
                    $before = $this->_XPHP['config']['base']['hooks']['before'];
                    $after = $this->_XPHP['config']['base']['hooks']['after'];
                    if(!empty($before)) {
                        $before(); //用户访问控制器之前载入
                    }
                    $app->$action(); //用户访问的控制器
                    if(!empty($after)) { 
                        $after(); //控制器之后载入
                    }
                } else {
                    throw new Exception('XPHP:方法不存在');
                }
            } else {
                throw new Exception('XPHP:类文件不存在或者路由处理失败');
            }
        } catch (Exception $e) {
            return self::exceptionHandler($e);
        }
    }

}

//sys配置文件
class Loader {

    //配置文件
    public static function loadCfg($class) {
        $config_file_path = AppConfig . $class . ".php";
        if (is_readable($config_file_path)) {
            return include $config_file_path;
        }
    }

    //模型文件
    public static function loadModel($class) {
        $class_path = AppModel . $class . '.php';
        if (is_readable($class_path)) {
            require_once $class_path;
        }
    }

    //系统类库
    public static function loadLib($type, $class) {
        $class_path = XPHP_Path . DIRECTORY_SEPARATOR . $type . DIRECTORY_SEPARATOR . $class . '.php';
        if (is_readable($class_path)) {
            require_once $class_path;
        }
    }

}

//系统Bug级别
function deBug() {
    switch (XPHP_Debug) {
        case 'development':
            error_reporting(E_ALL);
            break;
        case 'test':
        case 'products':
            error_reporting(0);
            break;
        default:
            throw new Exception('XPHP:没有定义错误级别');
    }
}

//控制器层&数据层&路由
Loader::loadLib('core', 'controller');
Loader::loadLib('core', 'model');
Loader::loadLib('core', 'router');

define('RunEtime', microtime());
define('RunEmem', memory_get_usage());