<?php
 /**
 * Register a custom post type called "产品".
 *
 * @see get_post_type_labels() for label keys.
 */

 //https://developer.wordpress.org/reference/functions/register_post_type/
 //  https://developer.wordpress.org/reference/functions/get_post_type_labels/


function dmwp_cpt_product_init() {
    $labels = array(
        'name'                  => _x( '产品', 'Post type general name', 'textdomain' ),
        'singular_name'         => _x( '产品', 'Post type singular name', 'textdomain' ),
        'menu_name'             => _x( '公司产品', 'Admin Menu text', 'textdomain' ),
        'name_admin_bar'        => _x( '产品', 'Add New on Toolbar', 'textdomain' ),
        'add_new'               => __( '添加产品', 'textdomain' ),
        'add_new_item'          => __( '添加新产品', 'textdomain' ),
        'new_item'              => __( '新产品', 'textdomain' ),
        'edit_item'             => __( '编辑产品', 'textdomain' ),
        'view_item'             => __( '查看产品', 'textdomain' ),
        'all_items'             => __( '所有产品', 'textdomain' ),
        'search_items'          => __( '查找产品', 'textdomain' ),
    
    );
 
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'dmproduct' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' ),
    );
 
    register_post_type( 'dmproduct', $args );
}
 
 add_action( 'init', 'dmwp_cpt_product_init' );

//---------------------
//https://howto-wordpress-tips.com/wordpress-custom-post-type-register/
//https://developer.wordpress.org/reference/functions/register_taxonomy/
function dmwp_cpt_product_taxo() {
   $labels = array(
        'name'                       => _x( '产品分类', 'taxonomy general name', 'textdomain' ),
        'singular_name'              => _x( '产品分类', 'taxonomy singular name', 'textdomain' ),
        'search_items'               => __( 'Search 产品分类', 'textdomain' ),
        'popular_items'              => __( 'Popular 产品分类', 'textdomain' ),
        'all_items'                  => __( '所有产品分类', 'textdomain' ),
        'parent_item'       => __( '父级产品分类' ),
        'parent_item_colon' => __( '父级产品分类:' ),
        'edit_item'                  => __( 'Edit 产品分类', 'textdomain' ),
        'update_item'                => __( 'Update 产品分类', 'textdomain' ),
        'add_new_item'               => __( 'Add New 产品分类', 'textdomain' ),
        'new_item_name'              => __( 'New 产品分类', 'textdomain' ),
        'separate_items_with_commas' => __( 'Separate 产品分类 with commas', 'textdomain' ),
        'add_or_remove_items'        => __( 'Add or remove 产品分类', 'textdomain' ),
        'choose_from_most_used'      => __( 'Choose from the most used 产品分类', 'textdomain' ),
        'not_found'                  => __( 'No 产品分类 found.', 'textdomain' ),
    );
 
    $args = array(
        'hierarchical'          => true,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'rewrite'               => array( 'slug' => 'dmprocate' ),
    );
    
 register_taxonomy( 'dmprocate', 'dmproduct', $args ); }

add_action( 'init', 'dmwp_cpt_product_taxo', 0 );

//-----------

//https://developer.wordpress.org/reference/functions/add_meta_box/
//Register Meta Box

$boxscreen = array(
       // 'post',
        'dmproduct'   
    );

function dmwp_register_meta_box() {
    add_meta_box( 'rm-meta-box-id', esc_html__( '相册管理', 'text-domain' ), 'dmwp_meta_box_callback', $boxscreen, 'advanced', 'high' );
}
add_action( 'add_meta_boxes', 'dmwp_register_meta_box');
 
//Add field
function dmwp_meta_box_callback( $meta_id ) {
    
 $postid = $meta_id->ID;
  //$postid=get_post_meta($meta_id->ID);

  //print_r($cs_meta_val);

  //  $outline = '<label for="title_field" style="width:150px; display:inline-block;">'. esc_html__('Title Field', 'text-domain') .'</label>';
  //  $title_field = get_post_meta( $meta_id->ID, 'title_field', true );
   // $outline .= '<input type="text" name="title_field" id="title_field" class="title_field" value="'. esc_attr($title_field) .'" style="width:300px;"/>';
 
   // echo $outline;
  echo '<a href="'.home_url().'/wp-content/dmandwp/admindm/mod_albumwp/mod_albumwp.php?lang=cn&pid='.$postid.'" target="_blank">点击进入相册管理> </a>';



}
