<?php
/**
 * The header for Astra Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<?php astra_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
	<?php astra_head_top(); ?>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	<?php astra_head_bottom(); ?>
</head>

<body <?php astra_schema_body(); ?> <?php body_class(); ?>>
	<?php astra_body_top(); ?>
	<?php wp_body_open(); ?>
	<div 
	<?php
	echo astra_attr(
		'site',
		array(
			'id'    => 'page',
			'class' => 'hfeed site',
		)
	);
	?>
	>

	<?php
	require   BLOCKROOT.'tpl/dmheader.php';

	require BLOCKROOT.'tpl/dmbanner.php';

	?>
	<?php
	global $showwpwhichmb;
	if($showwpwhichmb=='y'){
		global $template;
		echo '<div style="background:red;color:#fff;text-align:center;padding:5px;font-size:14px">'.basename($template).'</div>';  
	}
	?>

	<?php 
	//astra_header_before(); 

	//astra_header(); 

	//astra_header_after();

	//astra_content_before(); 
	?>
	<div id="content" class="site-content">
		<div class="ast-container">
			<?php astra_content_top(); ?>
