/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function ( $ ) {

	// Site title.
	wp.customize(
		'blogname',
		function ( value ) {
			value.bind(
				function ( to ) {
					$( '#site-title a' ).text( to );
				}
			);
		}
	);

	// Site description.
	wp.customize(
		'blogdescription',
		function ( value ) {
			value.bind(
				function ( to ) {
					$( '#site-description' ).text( to );
				}
			);
		}
	);

	// Header display type.
	wp.customize(
		'spacious_header_display_type',
		function ( value ) {
			value.bind(
				function ( layout ) {
					var display_type = layout;

					if ( display_type === 'type_two' ) {
						$( 'body' ).removeClass( 'header_display_type_two' ).addClass( 'header_display_type_one' );
					} else if ( display_type === 'type_three' ) {
						$( 'body' ).removeClass( 'header_display_type_one' ).addClass( 'header_display_type_two' );
					} else if ( display_type === 'type_one' ) {
						$( 'body' ).removeClass( 'header_display_type_one header_display_type_two' );
					}
				}
			);
		}
	);

	// Site Layout Option.
	wp.customize(
		'spacious_site_layout',
		function ( value ) {
			value.bind(
				function ( layout ) {
					var site_layout = layout;

					if ( 'wide_layout' === site_layout ) {
						$( 'body' ).removeClass( 'box-layout' ).addClass( 'wide' );
					} else if ( 'boxed_layout' === site_layout ) {
						$( 'body' ).removeClass( 'wide' ).addClass( 'box-layout' );
					}
				}
			);
		}
	);

	// Footer copyright alignment.
	wp.customize(
		'spacious_footer_copyright_alignment_setting',
		function ( value ) {
			value.bind(
				function ( alignment ) {
					var alignment_type = alignment;

					if ( alignment_type === 'left' ) {
						$( '#colophon' ).removeClass( 'copyright-right copyright-center' );
					} else if ( alignment_type === 'right' ) {
						$( '#colophon' ).removeClass( 'copyright-center' ).addClass( 'copyright-right' );
					} else if ( alignment_type === 'center' ) {
						$( '#colophon' ).removeClass( 'copyright-right' ).addClass( 'copyright-center' );
					}
				}
			);
		}
	);

	// Footer Main Area Display Type.
	wp.customize(
		'spacious_main_footer_layout_display_type',
		function ( value ) {
			value.bind(
				function ( layout ) {
					var display_type = layout;

					if ( display_type === 'type_two' ) {
						$( '#colophon' ).removeClass( 'spacious-footer--classic-bordered' ).addClass( 'spacious-footer--classic' );
					} else if ( display_type === 'type_three' ) {
						$( '#colophon' ).removeClass( 'spacious-footer--classic' ).addClass( 'spacious-footer--classic-bordered' );
					} else if ( display_type === 'type_one' ) {
						$( '#colophon' ).removeClass( 'spacious-footer--classic spacious-footer--classic-bordered' );
					}
				}
			);
		}
	);

	// Remove all of the post meta.
	wp.customize(
		'spacious_all_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.above-entry-meta,.below-entry-meta,.tg-module-meta,.tg-post-categories' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.above-entry-meta,.below-entry-meta,.tg-module-meta,.tg-post-categories' ).css(
							{
								'display' : 'block'
							}
						);
					}
				}
			);
		}
	);

	// Disable the author post meta only.
	wp.customize(
		'spacious_author_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.below-entry-meta .byline,.tg-module-meta .tg-post-auther-name' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.below-entry-meta .byline,.tg-module-meta .tg-post-auther-name' ).css(
							{
								'display' : 'inline-block'
							}
						);
					}
				}
			);
		}
	);

	// Disable the date post meta only.
	wp.customize(
		'spacious_date_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.below-entry-meta .posted-on,.tg-module-meta .tg-post-date' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.below-entry-meta .posted-on,.tg-module-meta .tg-post-date' ).css(
							{
								'display' : 'inline-block'
							}
						);
					}
				}
			);
		}
	);

	// Disable the category post meta only.
	wp.customize(
		'spacious_category_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.above-entry-meta,.tg-post-categories' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.above-entry-meta,.tg-post-categories' ).css(
							{
								'display' : 'inline-block'
							}
						);
					}
				}
			);
		}
	);

	// Disable the comments post meta only.
	wp.customize(
		'spacious_comments_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.below-entry-meta .comments,.tg-module-meta .tg-module-comments' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.below-entry-meta .comments,.tg-module-meta .tg-module-comments' ).css(
							{
								'display' : 'inline-block'
							}
						);
					}
				}
			);
		}
	);

	// Disable the tags post meta only.
	wp.customize(
		'spacious_tags_entry_meta_remove',
		function ( value ) {
			value.bind(
				function ( to ) {
					if ( to ) {
						$( '.below-entry-meta .tag-links' ).css(
							{
								'display' : 'none'
							}
						);
					} else {
						$( '.below-entry-meta .tag-links' ).css(
							{
								'display' : 'inline-block'
							}
						);
					}
				}
			);
		}
	);

} )( jQuery );
