<?php
/*普通分页类*/
namespace app\common\org;
class Page {
    // 前渐减的页数导航总数
    public $BeforePages = 5;
    // 后渐加的页数导航总数
    public $AfterPages = 5;
    // 页数跳转时要带的参数
    public $parameter = '';
    // 默认列表每页显示行数
    public $listRows = 5;
    // 起始行数
    public $firstRow;
    // 分页总页面数
    protected $totalPages;
    // 总行数
    protected $totalRows;
    // 当前页数
    protected $nowPage;
    // 分页的栏的总页数
    protected $coolPages;
    // 栏目英文名
    protected $entitle;
	// 判断终端
    protected $mbispc;
    // 分页显示定制
    protected $config = array(
        'first' => '首页',
        'prev' => '上一页',
        'next' => '下一页',
        'last' => '末页',
        'theme' => '%first% %upPage%  %linkPage%  %downPage% %end%'
    );
    // 默认分页变量名
    protected $varPage;
    /**
     * 架构函数
     * @access public
     * @param array $totalRows  总的记录数
     * @param array $listRows  每页显示记录数
     * @param array $parameter  分页跳转的参数
     */
    public function __construct($totalRows, $listRows = '', $entitle, $nowPage, $parameter = '',$mbispc = '') {
        $this->totalRows = $totalRows; // 构造函数参数 1，总页数
        $this->parameter = $parameter; // 构造函数参数 3，URL 附加参数
		$this->nowPage	= $nowPage; //当前页
        $this->entitle = $entitle; //栏目英文名
		$this->mbispc = $mbispc;  //判断终端
        $this->varPage = config('VAR_PAGE') ? config('VAR_PAGE') : 'p'; // 获取分页变量名，如果未定义则定义默认分页变量名
        
        /**
         * intval() 将变量转成整数类型
         */
        if (!empty($listRows)) { // 构造函数参数 2，获取每页显示的条数，如果每页显示的条数不为空则
            $this->listRows = intval($listRows); // 转换为整型并赋值给每页显示的条数
            
        }
        /**
         * ceil() 函数向上舍入为最接近的整数(1.1=2)
         */
        $this->totalPages = ceil($this->totalRows / $this->listRows); // 获取总页数，记录集的总数除以每页显示的条数等于总页数
        // 假设有 40 条数据，每页显示 5 条，就是有 8 页，每个页面显示 2 个导航栏，就是有4栏
        //$this->coolPages    =   ceil($this->totalPages/$this->AfterPages); // 获取总栏数， 总栏数除以每页显示的栏数等于总栏数
        
        /**
         * empty() 如果参数是非空或非零的值，则返回 FALSE,否则返回 TRUE
         */		
        if (!empty($this->totalPages) && $this->nowPage > $this->totalPages) { // 如果总页数不为空并且当前页数大于总页数则
            $this->nowPage = $this->totalPages; // 赋值当前页数为总页数            
        }
        // 假设当前页数为 2，每页显示 5 条数据，当前页面就是从第 (5*(2-1)=5) 条记录开始读取数据,
        // 根据 limit 函数定义，索引从零开始，也就是实际的值是记录集的第六条数据
        $this->firstRow = $this->listRows * ($this->nowPage - 1); // 获取起始页，起始行数等于每页显示的条数乘以当前页面减 1
        
    }
    /**
     * 自定义导航显示
     * @access public
     * @param String $name 待替换的参数名称
     * @param String $value 替换的参数值
     * isset() 返回  bool 值
     * 若变量不存在则返回 FALSE
     * 若变量存在且其值为NULL，也返回 FALSE
     * 若变量存在且值不为NULL，则返回 TURE
     */
    public function setConfig($name, $value) {
        if (isset($this->config[$name])) {
            $this->config[$name] = $value;
        }
    }
	
	public function pageurl($p){
		if(config('weburltype')){
			if($this->mbispc==0){
				$dir = config('webhtmlpath') ? '/'.config('webhtmlpath') : '';
			}else{
				if(config('webmurl')==""){
					$dir = '/'.config('webmhtmlpath');
				}
			}
			$url = $dir.'/'.$this->entitle.'/'.$p.'/index.html';
		}else{
			$url = '/'.$this->entitle.'?p='.$p;
		}
		if($params){
			foreach($params as $key=>$v){
				$url .= '&'.$key.'='.$v;
			}
		}
		return $url;
	}
	
    /**
     * 分页显示输出
     * @access public
     * 
     */
    public function show() {
        if (0 == $this->totalRows) return '';
        $p = $this->varPage; // 默认分页变量名
        //上翻页字符串
        $upRow = $this->nowPage - 1;
        $theFirstRow = 1;
        if ($upRow > 0) {
            $theFirst = "<li><a href='" . $this->pageurl($theFirstRow) . "'>" . $this->config['first'] . "</a></li>";
            $upPage = "<li><a href='" . $this->pageurl($upRow) . "'>" . $this->config['prev'] . "</a></li>";
        } else {
            $theFirst = "<li><span>" . $this->config['first'] . "</span></li>";
            $upPage = "<li><span>" . $this->config['prev'] . "</span></li>";
        }
        // 下翻页字符串
        $downRow = $this->nowPage + 1;
        $theEndRow = $this->totalPages;
        if ($downRow <= $this->totalPages) {
            $downPage = "<li><a href='" . $this->pageurl($downRow) . "'>" . $this->config['next'] . "</a></li>";
            $theEnd = "<li><a href='" . $this->pageurl($theEndRow) . "'>" . $this->config['last'] . "</a></li>";
        } else {
            $downPage = "<li><span>" . $this->config['next'] . "</span></li>";
            $theEnd = "<li><span>" . $this->config['last'] . "</span></li>";
        }
        // 后置导航
        $AfterPage = $this->nowPage - 1;
        if ($AfterPage >= 0) {
            $this->AfterPages+= $AfterPage;
        }
        $j = '';
        if ($AfterPage > $this->totalPages) $AfterPage = $this->totalPages;
        $nowCoolPage = ceil($this->nowPage / ($this->AfterPages));
        // 前置导航
        if ($this->nowPage > 5) {
            $BeforePage = $this->nowPage - $this->BeforePages;
            $j = $BeforePage;
        } else {
            $j = 1;
        }
        if ($j < 0) $j = 1;
        // 1 2 3 4 5
        $linkPage = "";
        for (;$j <= $this->AfterPages; $j++) {
            $page = ($nowCoolPage - 1) * ($this->AfterPages - $AfterPage) + $j;
			if ($page != $this->nowPage) {
				if($page <= $this->totalPages) {
					$linkPage.= "<li><a href='" . $this->pageurl($page) . "'>" . $page . "</a></li>";
				}else{
					break;
				}
			} else {
				if ($this->totalPages != 1) {
					$linkPage.= "<li class='active'><span>" . $page . "</span></li>";
				}
			}
        }		
        $pageStr = str_replace(array(
            '%nowPage%',
            '%totalRow%',
            '%totalPage%',
            '%upPage%',
            '%downPage%',
            '%first%',
            '%linkPage%',
            '%end%'
        ) , array(
            $this->nowPage,
            $this->totalRows,
            $this->totalPages,
            $upPage,
            $downPage,
            $theFirst,
            $linkPage,
            $theEnd
        ) , $this->config['theme']);
					
        return $this->totalPages > 1 ? '<ul>'.$pageStr.'</ul>' : '';
    }
}

