<?php
namespace app\hsycms\controller;
use think\Controller;
use app\hsycms\controller\Base;
use think\Db;

class Chtml extends Base
{
	public $mbispc;  //0电脑端 1手机端			
	public function __construct(){
		parent::__construct();
		$this->mbispc = input('htmlpath');		
	}	
	//生成首页
	public function index(){		
		if($_POST){
			action('index/index/doindex');
			$indexName = config('webindexname') ? config('webindexname') : 'index.html';
			$htmlpath = $this->mbispc==0?$indexName:config('webmhtmlpath').'/'.$indexName; 
			$this->filePutContents('./'.$htmlpath,'index');	
			return json(array('status'=>'y','info'=>'生成成功'));			
		}else{
			return $this->fetch();
		}
	}

	//生成列表页
	public function lists(){
		$list = db('nav')->where('mid<>6')->field('id,title,entitle')->order('sort,id')->select();
		$this->assign("list",$list);
		return $this->fetch();
	}	
	
	//生成进度条页
	public function process(){
		if($_POST){
			$page = input('process_page','','intval');
			$nid  = input('process_nid','','intval');
			$where['mid'] = array('neq',6);
			if($nid!=0){
				$where['id'] = $nid;
			}
			$list = db('nav')->where($where)->limit($page-1,1)->order('sort,id')->select();
			$list = current($list);			
			if($list){
				$count = db('nav')->where('isshow=1')->count();
				$process = ceil($page/$count*100);
				$tplpath = $this->dolist($list);
				return json(array('status'=>'1','info'=>'生成中','data'=>$tplpath,'process'=>$process));
			}else{
				return json(array('status'=>'0','info'=>'加载完成','data'=>'生成完成'));
			}	
		}else{
			$this->assign('nid',intval(input('process_nid')));
			$this->assign('htmlpath',$this->mbispc);
			return $this->fetch('create');
		}
	}
	
	//生成栏目页处理
	public function dolist($data){
		$result = action('index/article/doarticle',array('type'=>$data['entitle'],'p'=>1,'mbispc'=>$this->mbispc)); //调用index控制器方法传entitle
		$retpl = $result['showcate']==1?'list'.$result['tpl']:'show'.$result['tpl']; //生成目录名称
		$htmlpath = $this->mbispc==0?config('webthemes'):config('webmthemes');					
		$tpl = ROOT_PATH.'app/index/view/'.$htmlpath.'/'.$retpl.'.html';   //模板路径
		$redata = array();
		if(file_exists($tpl)){
			//无分类
			if($data['showcate']==0){
				$redata0 = $this->docreate($data['entitle'],$retpl,1);						
				array_push($redata,$redata0);
			}else{
				//有分类
				$redata1 = $this->docreate($data['entitle'],$retpl,1);						
				array_push($redata,$redata1);	
				
				$pagesize = 12;
				$data['page'] && $pagesize = $data['page'];
				$numArticleNum = db('article')->where(['nid'=>$data['id']])->count();
				if($numArticleNum>0){
					$numTotalpage = ceil($numArticleNum/$pagesize);
					if($numTotalpage > 1){
						for ($a=1; $a <= $numTotalpage; $a++){
							action('index/article/doarticle',array('type'=>$data['entitle'],'p'=>$a,'mbispc'=>$this->mbispc));
							$redata2 = $this->docreate($data['entitle'],$retpl,3,$a);						
							array_push($redata,$redata2);
						}
					}	
				}
				//分类生成			
				$list = db('cate')->where(array('isshow'=>1,'nid'=>$data['id']))->order('sort,id')->select();	
				if($list){
					foreach($list as $key=>$v){
						action('index/article/doarticle',array('type'=>$v['entitle'],'p'=>1,'mbispc'=>$this->mbispc));
						$redata3 = $this->docreate($v['entitle'],$retpl,2);						
						array_push($redata,$redata3);
						$articleNum = db('article')->where('cid',$v['id'])->count();
						if($articleNum>0){
							$v['page'] && $pagesize = $v['page'];
							$totalpage = ceil($articleNum/$pagesize);						
							if($totalpage > 1){
								for ($i=1; $i <= $totalpage; $i++){
									action('index/article/doarticle',array('type'=>$v['entitle'],'p'=>$i,'mbispc'=>$this->mbispc));
									$redata4 = $this->docreate($v['entitle'],$retpl,3,$i);						
									array_push($redata,$redata4);
								}
							}
						}
					}
				}
			}		
		}else{
			$redata = $retpl.'模板不存在';
		}
		return $redata;
	}
	
		
	//处理列表生成
	public function docreate($entitle,$retpl,$type,$i=2){
		$htmlpath = $this->mbispc==0?config('webhtmlpath'):config('webmhtmlpath');
		if($type==1||$type==2){
			$dir = ROOT_PATH.$htmlpath.'/'.$entitle;			
			if (!file_exists($dir)){				
				mkdir ($dir,0777,true);
			}			
			$tplpath = $dir.'/index.html'; 			
			$this->filePutContents($tplpath,$retpl);
			return $htmlpath.'/'.$entitle.'/index.html';
		}elseif($type==3){
			$dir = ROOT_PATH.$htmlpath.'/'.$entitle.'/'.$i;			
			if (!file_exists($dir)){				
				mkdir ($dir,0777,true);
			}			
			$tplpath = $dir.'/index.html'; 			
			$this->filePutContents($tplpath,$retpl);
			return $htmlpath.'/'.$entitle.'/'.$i.'/index.html';
		}
	}
	
	//生成详情页
	public function detail(){
		$list = db('nav')->where('mid<>6')->field('id,title,entitle')->order('sort,id')->select();
		$this->assign("list",$list);
		return $this->fetch();
	}
	
	//生成详情页处理
	public function doDetail(){
		$nid     = input('param.process_nid','','intval');
		$startId = input('param.process_startId','','intval');
		$endId   = input('param.process_endId','','intval');
		$num     = input('param.process_num','','intval');
		if($this->request->isPost()){
			$where['n.mid'] = array('neq',6);
			$page = input('param.process_page','','intval');
			$nid && $where['c.nid']    = $nid;
			$startId && $where['c.id'] = array('egt',$startId);
			$endId && $where['c.id']   = array('elt',$endId);	
			$startId && $endId && $where['c.id'] = array('between',[$startId,$endId]);
			$start =($page-1) * $num;
			$list  = db('article')->alias('c')->join("nav n","c.nid=n.id")->where($where)->field("c.id,c.nid,n.entitle")->limit($start,$num)->order("c.istop desc,c.sort desc,c.id desc")->select();
			$count = db('article')->alias('c')->join("nav n","c.nid=n.id")->where($where)->limit($start,$num)->count();
			if($list){
				$tplpath = array();
				foreach($list as $key=>$v){
					$result = action('index/show/doindex',array('id'=>$v['id'],'mbispc'=>$this->mbispc)); //调用index控制器方法传entitle
					$retpl  = 'show'.$result; //生成目录名称
					$htmlpath = $this->mbispc==0?config('webthemes'):config('webmthemes');					
					$tpl = ROOT_PATH.'app/index/view/'.$htmlpath.'/'.$retpl.'.html'; //模板路径
					if(file_exists($tpl)){
						$redata = $this->doDetailCreate($v['id'],$v['entitle'],$retpl);
						array_push($tplpath,$redata);
						$per = ceil($count/$pagesize);
						$process = ceil($page/$per*100);						
					}else{
						array_push($tplpath,$retpl.'模板不存在');
					}
				}
				return json(array('status'=>'1','info'=>'生成中','data'=>$tplpath,'process'=>$process));
			}else{
				return json(array('status'=>'0','info'=>'加载完成','data'=>'生成完成'));
			}			
		}else{
			$this->assign('nid',$nid);
			$this->assign('startId',$startId);
			$this->assign('endId',$endId);
			$this->assign('num',$num);
			$this->assign('isdetail',true);
			$this->assign('htmlpath',$this->mbispc);
			return $this->fetch("create");
		}
	}	

	
	//处理详情页生成
	public function doDetailCreate($id,$entitle,$retpl){
		$htmlpath = $this->mbispc==0?config('webhtmlpath'):config('webmhtmlpath');
		$dir = ROOT_PATH.$htmlpath.'/'.$entitle;	
		if (!file_exists($dir)){				
			mkdir ($dir,0777,true);
		}			
		$tplpath = $dir.'/'.$id.'.html'; 
		$this->filePutContents($tplpath,$retpl);
		return $htmlpath.'/'.$entitle.'/'.$id.'.html';	
	}	
	
	//写入
	private function filePutContents($filepath,$tpl){
		ob_start();
		$webthemes = $this->mbispc==0?config('webthemes'):config('webmthemes'); 
		$content = $this->fetch('index@'.$webthemes.'/'.$tpl);
		echo $content;
		$_cache=ob_get_contents();
		ob_end_clean();
		if($_cache){
			$File = new \think\template\driver\File();
			$File->write($filepath, $_cache);
		}
	}

}