<?php
namespace app\hsycms\controller;
use think\Controller;
use app\hsycms\controller\Base;

class Order extends Base
{
			//订单列表
			public function index(){	
						if(input('s_status')!=""){
									$map['status'] = input('s_status');
						}
						if(input('s_paystate')!=""){
									$map['paystate'] = input('s_paystate');
						}
						if(input('s_title')!=""){
									$map['title|name|mobile|orderno|price|paymoney'] = array('like','%'.input('s_title').'%');
						}		
						if(input('s_starttime')!=""){
								$map['datetime'] = array('gt',input('s_starttime'));
						}
						if(input('s_endtime')!=""){
							 $map['datetime'] = array('lt',input('s_endtime'));
						}
						if(input('s_starttime')!="" && input('s_endtime')!=""){
								$map['datetime'] = array('between', array(input('s_starttime'),input('s_endtime')));
						}
						
						//24小时未支付自动取消订单
						$nopayList = db('order')->where(['status'=>0,'paystate'=>0])->select();
						if($nopayList){ foreach($nopayList as $key=>$v){ orderAutoCancel($v['id'],$v['datetime']); } }
						
						$list = db('order')->where($map)->order("id desc,datetime desc")->paginate(10,false,['query' => request()->param()]);	
						$page = $list->render();					
						$this->assign("list",$list);
						$this->assign("page",$page);
						return $this->fetch(); 
		}
	
	 //订单详情
		public function detail(){
			  $id   = input('id','','intval');
					$one  = db('order')->where(['id'=>$id])->find();				
					$this->assign("v",$one);
					return $this->fetch();
		}
	
	 //退款
		public function refund(){	
				import("Wxpay.lib.WxPay#Api", EXTEND_PATH);
				import('Wxpay.WxPay#Config', EXTEND_PATH); 
				
				//退款配置
				$appid      = config('appid');   //APPID
				$appSecret  = unlock_key(config('appsecret'),config('openid')); //appsecret;
				$merchantId = config('merchantid');	 //商户号
				$appkey     = unlock_key(config('appkey'),config('openid')); //支付key		
				$notifyUrl  = config('weburl').'index/api/refundNotify/';
				$config = new \WxPayConfig($appid, $appSecret, $merchantId, $appkey);											
												
				//退款内容									
				$id = input('id','','intval');
				$one = db('order')->where(['id'=>$id])->find();				
				if($one['paystate']==1 && $one['status']==2){
							$input = new \WxPayRefund();
							$input->SetOut_trade_no($one['orderno']);  //订单号
							$input->SetTotal_fee($one['paymoney']*100);    //订单金额
							$input->SetRefund_fee($one['paymoney']*100);		 //退款金额	
							$input->SetOut_refund_no(date("YmdHis").getRandomNumber(5));
							$input->SetOp_user_id($config->GetMerchantId());				
							$result = \WxPayApi::refund($config, $input);		
							if($result['return_code']=="SUCCESS" && $result['result_code']=="SUCCESS"){
								  $d['refundtime'] = date('Y-m-d H:i:s',time());
										$d['paystate'] = 2;
										db('order')->where(['id'=>$id])->update($d);
								  return json(['status'=>'y','info'=>'退款成功']);
							}else{
								  return json(['status'=>'no','info'=>'退款失败']);	
							}
				}else{
							return json(['status'=>'no','info'=>'未支付或订单处于正常状态']);
				}
								
		}
	
		//删除订单
		public function del(){	
					$id  = input('id');				
					db('order')->where('id',$id)->delete();		
					return json(['status'=>'y','info'=>'删除订单']);				
		}
	
		//指量删除订单
		public function dels(){
			if($_POST['id'])foreach($_POST['id'] as $v){				
						db('order')->where(['id'=>$v])->delete();			
			}
			$this->success("批量删除订单成功",url('index'));
		}
		
	//批量处理订单状态	
	public function upStatus(){	
		$d['status'] = input('status');			
		if($_POST['id'])
		foreach($_POST['id'] as $v){	
				db('order')->where(['id'=>$v])->setField($d);
		}		
		$this->success("批量操作成功",url('index'));					
	}	
	
	//批量支付状态修改
		public function upPaystate(){	
				$d['paystate'] = input('paystate');	
				if($d['paystate']==0){	$d['paytime'] =""; $d['refundtime'] ="";	}
				if($d['paystate']==1){	$d['paytime'] = date('Y-m-d H:i:s',time());	}
				if($d['paystate']==2){	$d['refundtime'] = date('Y-m-d H:i:s',time()); }
				if($_POST['id'])foreach($_POST['id'] as $v){	
						db('order')->where(['id'=>$v])->setField($d);		
				}		
				$this->success("批量操作成功",url('index'));					
	}	

}