<?php
namespace app\index\controller;
use think\Controller;
use app\index\controller\Common;
class Login extends Common {

    //登录页面
    public function index(){
        $data["site"] = getseo();
        $data["site"]["webtitle"] = '登录-' . $data['site']['webtitle'];
        $this->assign($data); 
        return $this->fetch('index@' . config('webthemes') . '/member/login');
    }

    //注册页面
    public function register(){
        $data["site"] = getseo();
        $data["site"]["webtitle"] = '注册-' . $data['site']['webtitle'];
        $this->assign($data); 
        return $this->fetch('index@' . config('webthemes') . '/member/register');
    }

    //找回密码
    public function forgetpass(){
        $data["site"] = getseo();
        $data["site"]["webtitle"] = '注册-' . $data['site']['webtitle'];
        $this->assign($data); 
        return $this->fetch('index@' . config('webthemes') . '/member/forgetpass');
    }

    //登录处理
    public function doLogin() {
        if ($_POST) {
            $user = input('user');
            $pass = input('pass');
            if ($user == "") {
                result(RE_ERROR, "请输入用户名/手机号/邮箱");
            }
            if ($pass == "") {
                result(RE_ERROR, "请输入密码");
            }
            $map['username|email|mobile'] = $user;
            $res = db('member')->whereOr($map)->find();
            if ($res) {
                if ($res['userpass'] != md5($pass)) {
                    result(RE_ERROR, "登录失败，密码错误!");
                } elseif ($res['status'] == 1) {
                    result(RE_ERROR, "登录失败，账号已锁定!");
                } else {
                    $d['token'] = md5(time() . $res['user']);
                    $d['logintime'] = time();
                    db('member')->where(['id' => $res['id']])->update($d);
                    \think\Cookie::set('token', $d['token'], 60 * 60 * 8);
                    \think\Cookie::set('uid', $res['id'], 60 * 60 * 8);
                    result(RE_SUCCESS, "登录成功");
                }
            } else {
                result(RE_ERROR, "登录失败，账号不存在!");
            }
        }
    }

    //QQ登录
    public function qqLogin() {
    }

    //退出登录
    public function exitLogin() {
        \think\Cookie::set('token', null);
        \think\Cookie::set('uid', null);
        header("Location: /");
        exit;
    }

    //发送验证码
    public function sendCode() {
        if ($_POST) {
            $mobile = input('mobile');
            if ($mobile == "") {
                result(RE_ERROR, "手机号不能为空");
            }
            if (!preg_match('/^1([0-9]{9})/', $mobile)) {
                result(RE_ERROR, "手机号格式不正确");
            }
            //sendCode($mobile); //调用发送方法
            $smscode = GetRandNumStr(6);
            session('MobileCode', $smscode);
            result(RE_SUCCESS, "发送成功" . $smscode);
        }
    }
    //注册
    public function doReg() {
        $data['mobile'] = input('mobile');
        $code = input('code');
        $pass = input('pass');
        $repass = input('repass');
        if ($data['mobile'] == "") {
            result(RE_ERROR, "手机号不能为空");
        }
        if (!preg_match('/^1([0-9]{9})/', $data['mobile'])) {
            result(RE_ERROR, "手机号格式不正确");
        }
        if ($code == "") {
            result(RE_ERROR, "验证码不能为空");
        }
        if ($code != session('MobileCode')) {
            result(RE_ERROR, "验证码输入不正确");
        }
        if ($pass == "") {
            result(RE_ERROR, "请输入密码");
        }
        if (strlen($pass) < 6) {
            result(RE_ERROR, "密码不能小于6位数");
        }
        if ($repass == "") {
            result(RE_ERROR, "请再次输入密码");
        }
        if ($repass != $pass) {
            result(RE_ERROR, "两次输入的密码不一致");
        }
        if (db('member')->where(['mobile' => $data['mobile']])->find()) {
            session('MobileCode', null);
            result(RE_ERROR, "手机号码已存在");
        } else {
            $data['userpass'] = md5($pass);
            $data['username'] = 'sy' . GetRandNumStr(6);
            $data['name'] = '默认呢称';
            $data['regtime'] = time();
            $res = db('member')->insert($data);
            if ($res) {
                session('MobileCode', null);
                result(RE_SUCCESS, "注册成功,请登录");
            } else {
                session('MobileCode', null);
                result(RE_ERROR, "注册失败");
            }
        }
    }
    
    //找回密码
    public function doForget() {
        $data['mobile'] = input('mobile');
        $code = input('code');
        $pass = input('pass');
        $repass = input('repass');
        if ($data['mobile'] == "") {
            result(RE_ERROR, "手机号不能为空");
        }
        if (!preg_match('/^1([0-9]{9})/', $data['mobile'])) {
            result(RE_ERROR, "手机号格式不正确");
        }
        if ($code == "") {
            result(RE_ERROR, "验证码不能为空");
        }
        if ($code != session('MobileCode')) {
            result(RE_ERROR, "验证码输入不正确");
        }
        if ($pass == "") {
            result(RE_ERROR, "请输入密码");
        }
        if (strlen($pass) < 6) {
            result(RE_ERROR, "密码不能小于6位数");
        }
        if ($repass == "") {
            result(RE_ERROR, "请再次输入密码");
        }
        if ($repass != $pass) {
            result(RE_ERROR, "两次输入的密码不一致");
        }
        $data['userpass'] = md5($pass);
        if (db('member')->where(['mobile' => $data['mobile']])->update($data) !== false) {
            session('MobileCode', null);
            result(RE_SUCCESS, "密码找回成功,请重新登录");
        } else {
            result(RE_ERROR, "密码找回失败");
        }
    }
}

