<?php

namespace app\index\controller;
use think\Controller;
use app\index\controller\Common;


class Member extends Common {
    public function __construct() {
        parent::__construct();
        $memid = \think\Cookie::get('uid');
        $token = \think\Cookie::get('token');
        if ($memid == null || $token == null) {
            header("Location: /");
            exit;
        }
        $memMenu = [["action" => "index", "url" => "Member/index", "title" => "会员中心"], ["action" => "userinfo", "url" => "Member/userinfo", "title" => "个人资料"], ["action" => "updatepass", "url" => "Member/updatepass", "title" => "修改密码"], ];
        $this->assign("memMenu", $memMenu);
    }
    //检测登录
    public function checkLogin() {
        $memid = \think\Cookie::get('uid');
        $token = \think\Cookie::get('token');
        if ($memid == null || $token == null) {
            return json(['code' => '100', 'msg' => '请先登录']);

        }
        if (!db('member')->where(['id' => $memid, 'token' => $token])->find()) {
            return json(['code' => '101', 'msg' => '登录已过期,请重新登录']);
        }
    }
    //获取标题
    public function getTitle($title, $mid) {
        $data["site"] = getseo();
        $data["site"]["webtitle"] = $title . '-' . $data['site']['webtitle'];
        $data["action"] = request()->action();
        $this->assign($data);
    }
    public function index() {
        $this->getTitle('会员中心');
        return $this->fetch('index@' . config('webthemes') . '/member/index');
    }

    public function userinfo() {
        $this->getTitle('账户信息');
        $memid = \think\Cookie::get('uid');
        $one = db('member')->where(['id' => $memid])->find();
        $this->assign("one", $one);
        return $this->fetch('index@' . config('webthemes') . '/member/userinfo');
    }

    //保存用户信息
    public function saveAccount() {
        $this->checkLogin();
        $memid = \think\Cookie::get('uid');
        $data['head'] = input('head');
        $data['email'] = input('email');
        $data['name'] = input('name');
        $data['address'] = input('address');
        $data['remark'] = input('remark');
        if ($data['name'] == "") {
            $this->error('请输入呢称');
        }
        if ($data['remark'] == "") {
            $this->error('请输入个人简介');
        }
        $mp['email'] = $data['email'];
        $mp['id'] = array('neq',$memid);
        if (db('member')->where($mp)->find()) {
            $this->error("该邮箱已存在");
        }
        if (db('member')->where(['id' => $memid])->update($data) !== false) {
            $this->success("账号信息保存成功!");
        }
    }

    //修改密码
    public function updatepass() {
        $this->getTitle('修改密码');
        return $this->fetch('index@' . config('webthemes') . '/member/updatepass');
    }


    //找回密码
    public function doUpdatepass() {
        $this->checkLogin();
        $memid = \think\Cookie::get('uid');
        $oldpass = input('oldpassword');
        $pass = input('password');
        $repass = input('repassword');        
        if ($oldpass == "") {
            result(RE_ERROR, "请输入原密码");
        }
        if(!db('member')->where(['id'=>$memid,'userpass'=>md5($oldpass)])->find()){
            result(RE_ERROR, "原始密码不正确"); 
        }
        if ($pass == "") {
            result(RE_ERROR, "请输入新密码");
        }
        if (strlen($pass) < 6) {
            result(RE_ERROR, "密码不能小于6位数");
        }
        if ($repass == "") {
            result(RE_ERROR, "请再次输入新密码");
        }
        if ($repass != $pass) {
            result(RE_ERROR, "两次输入的密码不一致");
        }
        $data['userpass'] = md5($repass);
        if (db('member')->where(['id' => $memid])->update($data) !== false) {
            \think\Cookie::set('token', null);
            \think\Cookie::set('uid', null); 
            result(RE_SUCCESS, "密码修改成功,请重新登录");
        } else {
            result(RE_ERROR, "更新失败");
        }
    }

    //上传图片处理
    public function uploadImage() {
        // $this->checkLogin();
        // $file = request()->file('file');
        // if ($file) {
        //     $size = 1024 * 1024 * 2; //允许上传2M
        //     $ext = 'jpg,gif,png,jpeg';
        //     $info = $file->validate(['size' => $size, 'ext' => $ext])->move(ROOT_PATH . DS . 'upload');
        //     if ($info) {
        //         $url = str_replace('\\', '/', $info->getPathname());
        //         $url = substr($url, strpos($url, '//') + 1);
        //         session("curuploadthumb", $url);
        //         return json(['code' => '0', 'msg' => '图片上传成功', 'url' => $url]);
        //     } else {
        //         return json(['code' => '1', 'msg' => $file->getError() ]);
        //     }
        // }
    }
}

