<?php
namespace taglib;
use think\template\TagLib;
// +----------------------------------------------------------------------
// | Copyright (c) 2018 http://www.hsycms.com All rights reserved.
// | Author: 神夜 <564379992@qq.com>
// +----------------------------------------------------------------------
class Sy extends TagLib{
    /**
     * 定义标签列表
     */
    protected $tags   =  [
     	 'list'      => ['attr' => 'nid,cid,aid,at,sort,num,name', 'close' => 1],
		 'cate'      => ['attr' => 'nid,num,name', 'close' => 1],
		 'one'       => ['attr' => 'aid,name', 'close' => 1],
		 'link'      => ['attr' => 'num,name', 'close' => 1],
		 'cateone'   => ['attr' => 'cid,name', 'close' => 1],
    ];
	
    /**
     * article 文章列表 可传入参数：nid 栏目ID ， cid 分类ID 可以多个用逗号分割 ， at 属性 at='istop' 置顶 isvouch 推荐 ishome 首页 ， sort 排序 ， num 显示数量
     */
    public function taglist($tag, $content)
    {     
        $name 	 = $tag['name'];
		$where   = 'nid = '.$tag['nid']; 
		if($tag['cid']!=""){
			$where .= ' and cid in ('.webtreecatewhere($tag['cid']).')';
		}
		if($tag['at']!=""){
			$where .= ' and '.$tag['at'].' = 1';
		}
		if($tag['aid']!=""){
			$where .= ' and id ='.$tag['aid'];
		}		
		$sort = $tag['sort']?$tag['sort']:'istop desc,sort desc,id desc';
		$num  = $tag['num']?$tag['num']:10;		
        $parse = '<?php ';
        $parse .= '$test_arr=db("article")->where("'.$where.'")->order("'.$sort.'")->limit("'.$num.'")->select();'; 		
        $parse .= '$__LIST__ = $test_arr;';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
    
	/**
     * cate 分类列表 可传入参数：nid 栏目id , num 显示数量
     */
    public function tagcate($tag, $content)
    {       
        $name 	 = $tag['name'];
		$where= 'pid = 0 and nid = '.$tag['nid'].' and isshow=1';		
		$sort = 'sort,id';
		$num  = $tag['num'];		
        $parse = '<?php ';
        $parse .= '$test_arr=db("cate")->where("'.$where.'")->order("'.$sort.'")->limit("'.$num.'")->select();'; 
        $parse .= '$__LIST__ = $test_arr;';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
	
	 /**
     * article 单篇文章 可传入参数：id 文章ID 
     */
    public function tagone($tag, $content)
    {       
        $name 	 = $tag['name'];
		$where   = 'id = '.$tag['aid']; 
        $parse = '<?php ';
        $parse .= '$test_arr=db("article")->where("'.$where.'")->select();'; 	
        $parse .= '$__LIST__ = $test_arr;';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
	
	 /**
     * cate 单个分类 可传入参数：cid 分类ID 
     */
    public function tagcateone($tag, $content)
    {       
        $name 	 = $tag['name'];
		$where   = 'id = '.$tag['cid']; 
        $parse = '<?php ';
        $parse .= '$test_arr=db("cate")->where("'.$where.'")->select();'; 	
        $parse .= '$__LIST__ = $test_arr;';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
    
	/**
     * link 友情连接 可传入参数： num 显示数量
     */
    public function taglink($tag, $content)
    {       
        $name 	 = $tag['name'];		
		$sort = 'id';
		$num  = $tag['num'];		
        $parse = '<?php ';
        $parse .= '$test_arr=db("link")->order("'.$sort.'")->limit("'.$num.'")->select();'; 		
        $parse .= '$__LIST__ = $test_arr;';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
    
   
}