//通用弹窗
function open(id) {
	let width = $("#"+id).width();
	layer.open({
		type: 1,
		title: false,
		closeBtn: 0,
		skin: 'layui-layer-nobg',
		area: width+'px',
		content: $('#' + id)
	})
}

//注册
function submitReg(flag=0) {
	var mobile = $("#reg_mobile");
	var code = $("#reg_code");
	var pass = $("#reg_pass");
	var repass = $("#reg_repass");
	var xieyi = $("#reg_xieyi");
	if (mobile.val().trim().length == 0) {
		layer.msg("请输入手机号");
		mobile.focus();
		return false
	}
	if (!/^[1][3,4,5,7,8][0-9]{9}$/.test(mobile.val())) {
		layer.msg("手机号码格式错误");
		mobile.focus();
		return false
	}
	if (code.val().trim().length == 0) {
		layer.msg("请输入验证码");
		code.focus();
		return false
	}
	if (pass.val().trim().length == 0) {
		layer.msg("请输入6-20位数字或字母密码");
		pass.focus();
		return false
	}
	if (pass.val().trim().length < 6) {
		layer.msg("密码不能小于6位数");
		pass.focus();
		return false
	}
	if (repass.val().trim().length == 0) {
		layer.msg("请再次输入密码");
		repass.focus();
		return false
	}
	if (repass.val() != pass.val()) {
		layer.msg("再次输入的密码不一致");
		pass.focus();
		return false
	}
	if (!xieyi.prop("checked")) {
		layer.msg("请同意并阅读《会员注册协议》");
		code.focus();
		return false
	}
	var params = {
		mobile: mobile.val(),
		code: code.val(),
		pass: pass.val(),
		repass: repass.val()
	}
	var load = layer.load(1);
	$.post("/index/Login/doReg", params, function(res) {
		layer.close(load);
		if (res.code == 0) {
			layer.alert(res.msg, {
				icon: 1
			}, function() {
				if(flag==0){
						layer.closeAll();
						clearInput();
						open('_login');
				}else{
					window.location.href = '/index/login/index.html'
				}
			})
		} else {
			layer.msg(res.msg);
		}
	},"json")
}

//找回密码
function submitForget(flag=0) {
	var mobile = $("#forget_mobile");
	var code = $("#forget_code");
	var pass = $("#forget_pass");
	var repass = $("#forget_repass");
	if (mobile.val().trim().length == 0) {
		layer.msg("请输入手机号");
		mobile.focus();
		return false
	}
	if (!/^[1][3,4,5,7,8][0-9]{9}$/.test(mobile.val())) {
		layer.msg("手机号码格式错误");
		mobile.focus();
		return false
	}
	if (code.val().trim().length == 0) {
		layer.msg("请输入验证码");
		code.focus();
		return false
	}
	if (pass.val().trim().length == 0) {
		layer.msg("请输入6-20位数字或字母密码");
		pass.focus();
		return false
	}
	if (pass.val().trim().length < 6) {
		layer.msg("密码不能小于6位数");
		pass.focus();
		return false
	}
	if (repass.val().trim().length == 0) {
		layer.msg("请再次输入密码");
		repass.focus();
		return false
	}
	if (repass.val() != pass.val()) {
		layer.msg("再次输入的密码不一致");
		pass.focus();
		return false
	}
	var params = {
		mobile: mobile.val(),
		code: code.val(),
		pass: pass.val(),
		repass: repass.val()
	}
	var load = layer.load(1);
	$.post("/index/Login/doForget", params, function(res) {
		layer.close(load);
		if (res.code == 0) {
			layer.alert(res.msg, {
				icon: 1
			}, function() {
				if(flag==0){
						layer.closeAll();
						clearInput();
						open('_login');
				}else{
					 window.location.href = '/index/login/index.html'
				}
			})
		} else {
			layer.msg(res.msg);
		}
	},"json")
}

//获取验证码
var send_time = 60;
function getCode(obj, id) {
	var mobile = $("#" + id);
	if (mobile.val().trim().length == 0) {
		layer.msg("请输入手机号");
		mobile.focus();
		return false
	}
	if (!/^1([0-9]{9})/.test(mobile.val())) {
		layer.msg("手机号码格式错误");
		mobile.focus();
		return false
	}
	var load = layer.load(1);
	$.post("/index/Login/sendCode", {mobile: mobile.val()}, function(res) {
			layer.close(load);
			if (res.code == 0) {
				layer.msg(res.msg);	
				$(obj).attr({"disabled": "disabled"});
				var timetimer = setInterval(function() {
					send_time--;
					$(obj).text(send_time + '秒后重新发送');
					if (send_time <= 0) {
						clearInterval(timetimer);
						send_time = 60;
						$(obj).removeAttr("disabled");
						$(obj).text('获取验证码');
					}
				}, 1000);
			} else {
				layer.msg(res.msg);
			}
		},
		'json')
}

//登录
function submitLogin(flag=0) {
	var user = $("#login_user");
	var pass = $("#login_pass");
	var jzpss = $("#login_jzpss");
	if (user.val().trim().length == 0) {
		layer.msg("请输入用户名/手机号/邮箱");
		user.focus();
		return false
	}
	if (pass.val().trim().length == 0) {
		layer.msg("请输入密码");
		pass.focus();
		return false
	}
	var load = layer.load(1);
	$.post("/index/Login/doLogin", {
		user: user.val(),
		pass: pass.val()
	}, function(res) {
		layer.close(load);
		if (res.code == 0) {
			layer.alert(res.msg, {
				icon: 1
			}, function() {
				if(flag==0){
						layer.closeAll();
						window.location.reload();
				}else{
						window.location.href = '/index/member/index.html'
				}
			})
		} else {
			layer.msg(res.msg);
		}
	},"json")
}

//清空输入
function clearInput() {
	$("#reg_mobile").val('');
	$("#reg_code").val('');
	$("#reg_pass").val('');
	$("#reg_repass").val('');
	$("#login_user").val('');
	$("#login_pass").val('');
	$("#forget_mobile").val('');
	$("#forget_code").val('');
	$("#forget_pass").val('');
	$("#forget_repass").val('');
}
