import api from '@/api/api.js'
import App from '@/App.vue'
import util from './util.js'
//随机生成字符串
function randomString(len) {
	len = len || 32;
	var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
	var maxPos = $chars.length;
	var pwd = '';
	for (var i = 0; i < len; i++) {
		pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
	}
	return pwd;
}

//获取图片信息高宽和路径
const getImageInfo = async (path) => {
	let imgInfo = await uni.getImageInfo({		src: path	});
	let imgMaxWidth = 1024; //图片最大宽
	let imgMaxHeight = 1024; //图片最大高
	let imgw = imgInfo[1].width;
	let imgh = imgInfo[1].height;
	let canvasW = imgw;
	let canvasH = imgh;
	if (imgw > imgh && imgw > imgMaxWidth) {
		canvasW = imgMaxWidth;
		canvasH = parseInt(imgMaxWidth * (imgh / imgw));
	} else if (imgw < imgh && imgh > imgMaxHeight) {
		canvasH = imgMaxHeight;
		canvasW = parseInt(imgMaxHeight * (imgw / imgh));
	} else if (imgw == imgh && imgw > imgMaxWidth) {
		canvasW = imgMaxWidth;
		canvasH = imgMaxWidth;
	}
	uni.showLoading({title: '上传中...',mask: true});	
	let name = randomString(32);
	let params = {
		path: imgInfo[1].path,
		name: name + '.jpg',
		imgw: imgw,
		imgh: imgh,
		canvasW: canvasW,
		canvasH: canvasH
	};
	return params;
}

//小程序开始压缩图片
function xcxCompress(imginfo, callback) {
	const ctx = uni.createCanvasContext('attendCanvasId');
	ctx.drawImage(imginfo.path, 0, 0, imginfo.canvasW, imginfo.canvasH);
	ctx.draw(false, function() {
		setTimeout(() => {
			uni.canvasToTempFilePath({
				canvasId: 'attendCanvasId',
				width:imginfo.canvasW,
				height:imginfo.canvasH,
				destWidth: imginfo.canvasW,
				destHeight: imginfo.canvasH,
				fileType: "jpg",
				success(res) {
					callback(res.tempFilePath);
					uni.hideLoading();		
				},
				fail(res) {
					uni.showToast({title: '图片缩放失败，请重试',icon: 'none'});
					uni.hideLoading()
				}
			});
		}, 100);
	});
}

// 上传图片
const uploadImg = (path, cb) => {	
			var that = this	
	    uni.uploadFile({
				  url: api.uploadUrl(),
						filePath: path,
						name: 'file',
						header:{
								"Content-Type": "multipart/form-data",
								"memid": App.globalData.userInfo==null?'' : App.globalData.userInfo.id,
								"token": App.globalData.userInfo==null?'' : App.globalData.userInfo.token
						},
						success:(r) => {	
							  if(r.statusCode==200){
												let data = JSON.parse(r.data)
												if(data.code==0){										
														cb(data.data)														
												}else{	
														if(data.code==100 || data.code==101){
																	uni.showModal({
																					title:"温馨提示",
																					content:data.msg,
																					success(res){
																								if(res.confirm){
																											util.goLogin();
																								}
																					}												
																	})	
														}else{
																	uni.showToast({title:data.msg,icon:'none'})
														}									
											}
								}
								uni.hideLoading();
						},
						fail:(res)=>{
							 uni.showToast({title: '图片上传失败',icon: 'none'});
							 uni.hideLoading();
						}
			})
}

module.exports = {
	getImageInfo: getImageInfo,
	xcxCompress: xcxCompress,
	uploadImg: uploadImg
}
