
//获取当前页完整URL路径包括参数
function getCurrentPageUrlWithArgs() {
  const pages = getCurrentPages()		
  const currentPage = pages[pages.length - 1]
  const url = currentPage.route
  const options = currentPage.options
  let urlWithArgs = `/${url}?`
  for (let key in options) {
    const value = options[key]
    urlWithArgs += `${key}=${value}&`
  }
  urlWithArgs = urlWithArgs.substring(0, urlWithArgs.length - 1)		
  return urlWithArgs
}

function getCurrentTime() {
	let keep = ''
	let date = new Date()
	let y = date.getFullYear()
	let m = date.getMonth() + 1
	m = m < 10 ? '0' + m : m
	let d = date.getDate() < 10 ? '0' + date.getDate() : date.getDate()
	let h = date.getHours() < 10 ? '0' + date.getHours() : date.getHours()
	let f = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()
	let s = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds()
	//   keep = y + '-' + m + '-' + d + ' ' + h + ':' + f + ':' + s
	keep = y + '-' + m + '-' + d + ' ' + h + ':' + f + ':' + s;
	return keep
}

 //计算两个时间差
function GetDateDiff(startTime, endTime, diffType) {
    //将xxxx-xx-xx的时间格式，转换为 xxxx/xx/xx的格式
    startTime = startTime.replace(/\-/g, "/");
    endTime = endTime.replace(/\-/g, "/");
    //将计算间隔类性字符转换为小写
    diffType = diffType.toLowerCase();
    var sTime = new Date(startTime); //开始时间
    var eTime = new Date(endTime); //结束时间
    //作为除数的数字
    var timeType = 1;
    switch (diffType) {
      case "second":
        timeType = 1000;
        break;
      case "minute":
        timeType = 1000 * 60;
        break;
      case "hour":
        timeType = 1000 * 3600;
        break;
      case "day":
        timeType = 1000 * 3600 * 24;
        break;
      default:
        break;
    }
    return parseInt((eTime.getTime() - sTime.getTime()) / parseInt(timeType));
}

//统一跳转登录处理
function goLogin(){	
	 uni.removeStorage({key:'userInfo'});
	 uni.removeStorage({key:'openid'});
		let currentUrl = getCurrentPageUrlWithArgs();	 
		uni.setStorage({key:'loginReturnUrl',data:currentUrl})
		uni.navigateTo({url:'/pages/index/login'})
}

module.exports = {	 
		getCurrentTime,
		goLogin,
		GetDateDiff
}