<?php
namespace jy_weishop\activity;
defined('BY_JYA') or exit('error');
/*
	限时卖
*/
class limit extends \plugin{
	public function goods_list($psize=10,$page=1,$total=null){
		$params=array(
			'uniacid'=>$_SESSION['uniacid'],
			'start_time <'=>TIMESTAMP,
			'end_time >'=>TIMESTAMP,
		);
		$pindex = max(1, intval($page));
		$parameter=array(
			'params'=>$params,
			'limit'=>array($pindex,$psize),
			'fields'=>array('goods_id'),
		);
		$list=$this->get_list('activity_limit',$parameter,$total);
		if($list){
			foreach($list as &$item){
				$goods=$this->model('goods')->goods_detail($item['goods_id'],array('id','title','image','price','marketprice','total'));
				$item=array_merge($item,$goods);
			}
		}
		return $list;
	}
	public function get_active($goods_id,$active_id){
		$active=$this->get('activity_limit',array('id'=>$active_id));
		if(!$active){
			return false;
		}
		if($active['stop'] ||  $active['end_time']<TIMESTAMP){
			return false;
		}
		if($active['start_time']<TIMESTAMP && $active['end_time']>TIMESTAMP){
			$status=1;
			$rest_time=$this->model()->date($active['end_time']-TIMESTAMP);
			$rest_time2=$active['end_time'];
		}
		if($active['start_time']>TIMESTAMP){
			$status=0;
			$rest_time=$this->model()->date($active['start_time']-TIMESTAMP);
			$rest_time2=$active['start_time'];
		}
		$active_price=price($active['price'],true);
		$count=pdo_getsum('jy_weishop_activity_limit_log',array('uniacid'=>$_SESSION['uniacid'],'active_id'=>$active_id),'num');
		$percent = ceil(($count / ($active['total'] ?: 1)) * 100);
		return array(
			'title'=>'限时卖',
			'price'=>$active_price,
			'status'=>$status,
			'end_time'=>date('Y-m-d H:i:s',$active['end_time']),
			'start_time'=>date('Y-m-d H:i:s',$active['start_time']),
			'rest_time'=>$rest_time,
			'rest_time2'=>$rest_time2,
			'percent'=>$percent
		);
	}
	public function check_stock($goods_id,$active_id,$num=1){
		$active=$this->get('activity_limit',array('id'=>$active_id));
		if(!$active){
			return false;
		}
		if($active['stop'] ||  $active['end_time']<TIMESTAMP){
			return false;
		}
		if($active['start_time']>TIMESTAMP){
			exi('活动还没开始！','error');
		}
		$count=pdo_getsum('jy_weishop_activity_limit_log',array('uniacid'=>$_SESSION['uniacid'],'active_id'=>$active_id),'num');
		if($active['total']<=$count){
			exi('本次活动商品已卖完！','error');
		}
		$hsnum=pdo_getsum('jy_weishop_activity_limit_log',array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid'],'active_id'=>$active_id),'num');
		if($active['num']<$num+$hsnum){
			exi('该活动每人只能购买'.$active['num'].'件商品！','error');
		}
		
		return true;
	}
	public function buy($goods_id,$active_id,$num){
		$this->check_stock($goods_id,$active_id,$num);
		return true;
	}
	public function order_create($params){
		$log=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$params['mid']?:$_SESSION['uid'],
			'goods_id'=>$params['goods_id'],
			'active_id'=>$params['active_id'],
			'ordersn'=>$params['ordersn'],
			'num'=>$params['num'],
			'price'=>$params['goods_price'],
			'createtime'=>TIMESTAMP,
		);
		$this->insert('activity_limit_log',$log);
	}
	public function ispay($params){
		$params=array(
			'uniacid'=>$_SESSION['uniacid'],
			'ordersn'=>$params['ordersn'],
		);
		$this->update('activity_limit_log',array('ispay'=>1),$params);
	}
	public function task(){
		$lasttime=time()-600;
		$logs = pdo_getall('jy_weishop_activity_limit_log',array('uniacid'=>$_SESSION['uniacid'],'createtime >'=>$lasttime));
		foreach($logs as $item){
			$status=pdo_getcolumn('jy_weishop_order',array('ordersn'=>$item['ordersn'],'uniacid'=>$_SESSION['uniacid']),'status');
			if($status==0 && $item['createtime']+120<time()){
				pdo_delete('jy_weishop_activity_limit_log',array('id'=>$item['id'],'uniacid'=>$_SESSION['uniacid']));
			}
		}
	}
}