<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	商品
*/
class goods extends \plugin{
	/*
		商品列表
	*/
	public function goods_list($params,&$total=null,$storeid=0){
		$params['params']['status']=1;
		$groupinfo = model('jy_weishop/member')->get_group();
		$groupinfo['id']=';'.$groupinfo['id'].';';
		$params['params']['showgroups OR']='showgroups=\'0\' or ifnull(showgroups,\'\')=\'\' or showgroups like \'%'.$groupinfo['id'].'%\' ';
		$levelinfo = model('jy_weishop/member')->get_level();
		$levelinfo['id']=';'.$levelinfo['id'].';';
		$params['params']['showlevels OR']='showlevels=\'0\' or ifnull(showlevels,\'\')=\'\' or showlevels like \'%'.$levelinfo['id'].'%\' ';
		if(!$params['orderby']){
			$params['orderby']=array('paixu desc','id desc');
		}
		$list=$this->pdo_getlist('goods',$params,$total);
		if($list){
			foreach($list as &$item){
				if($params['istomedia']){
					$item['image']=tomedia($item['image']);
				}
				$item['weight']=$this->pdo_getcolumn('goods_dispatch',array('goodsid'=>$item['id']),'weight');
				if($storeid){
					$item['storeid']=$storeid;
				}
				$pindex = max(1, 1);
				$parameter=array(
					'params'=>array('goodsid'=>$item['id']),
					'limit'=>array($pindex,1),
					'fields'=>$fields,
					'orderby'=>'price asc',
				);
				$options = pdo_getlist('jy_weishop_goods_option',$parameter);
				if($options){
					$item['optionid']=$options[0]['id'];
				}
				$item=$this->model('activity')->get_upgoods($item);
				if($item['salenum']>=10000){
					$wans=$item['salenum']/10000;
					$wans=sprintf('%.1f',$wans);
					$item['salenum']=$wans.'万';
				}
				$item['userbuy'] = 1;
				$item['levelbuy'] = 1;
				$item['groupbuy'] = 1;
				$item['canbuy'] = $item['total'] > 0?:false;
				if (0 < $item['usermaxbuy']) {
					$order_goodscount = pdo_fetchcolumn('select ifnull(sum(og.total),0)  from ' . tablename('jy_weishop_order_goods') . ' og ' . ' left join ' . tablename('jy_weishop_order') . ' o on og.orderid=o.id ' . ' where og.goodsid=:goodsid and  o.status>=1 and o.mid=:mid  and og.uniacid=:uniacid ', array(':goodsid' => $item['id'], ':uniacid' => $_SESSION['uniacid'], ':mid' => $_SESSION['uid']));
					if ($item['usermaxbuy'] <= $order_goodscount) {
						$item['userbuy'] = 0;
						$item['canbuy'] = false;
					}
					$item['order_goodscount']=$order_goodscount;
				}
				if ((0 < $item['isendtime']) && (0 < $item['endtime']) && ($item['endtime'] < time())) {
					$item['canbuy'] = false;
				}
				if($item['cant_buy']==1){
					$item['canbuy'] = false;
				}
				//判断nobuy状态：
				if($item['userbuy']==0){
					$item['nobuytitle']='您已经超出最大'.$item['usermaxbuy'].'件购买量';
				}elseif($item['levelbuy']==0){
					$item['nobuytitle']='您当前会员等级没有购买权限';
				}elseif($item['groupbuy']==0){
					$item['nobuytitle']='您所在的用户组没有购买权限';
				}elseif($item['timebuy']==-1){
					$item['nobuytitle']='未到开始抢购时间!';
				}elseif($item['timebuy']==1){
					$item['nobuytitle']='抢购时间已经结束';
				}elseif($item['cant_buy']==1){
					$item['nobuytitle']='不满足购买条件';
				}else{
					$item['nobuytitle']='商品已售罄';
				}
				if($item['minbuynum'] && $item['total']<$item['minbuynum']){
					$item['outnumtitle']='单次最少购买'.$item['minbuynum'].'件';
					$item['outtype']=3;
				}
				if($item['maxbuy'] && $item['total']>$item['maxbuy']){
					$item['outnumtitle']='单次最多购买'.$item['minbuynum'].'件';
					$item['outtype']=4;
				}
				$sales=$this->model('activity')->get_sales($item['id']);
				if($sales['maxnum']>0 && $item['total']>$sales['maxnum']){
					$item['outnumtitle']='只能购买活动品'.$sales['maxnum'].'件';
					$item['outtype']=5;
				}
			}
		}
		return $list;
	}
	/*
		商品详情
	*/
	public function goods_detail($goods_id,$fields=array()){
		$goods=$this->get('goods',array('id'=>$goods_id,'uniacid'=>$_SESSION['uniacid']),$fields);
		return $goods;
	}
	/*
		更新插件关联
	*/
	public function up_pluginname($goods_id,$pluginname){
		if(empty($pluginname) || empty($goods_id)){
			return false;
		}
		$isplugin=$this->get('goods',array('id'=>$goods_id,'uniacid'=>$_SESSION['uniacid']),'pluginname');
		if($isplugin['pluginname'] && $isplugin['pluginname']!=$pluginname){
			exi('该商品已经关联其他插件！','error');
		}
		$this->update('goods',array('pluginname'=>$pluginname),array('id'=>$goods_id,'uniacid'=>$_SESSION['uniacid']));
		return true;
	}
	/*
		检查是否能够购买指定商品
	*/
	public function check_buy($goods_id,$num=1,$optionid=0,$iscart=false,$isadd=false,$nomsg=false,$store_id=''){
		if(!$goods_id){
			return false;
		}
		$goods['unit']=$goods['unit']?:'件';
		$store_id=$store_id?:$_SESSION['store_id'];
		$goods=$this->pdo_get('goods',array('id'=>$goods_id));
		$storeset=$this->plugin_setting('storeset');//没开启商品统一
		if($store_id && $storeset['no_goods']!=1){
				$getinfo=model('jy_weishop/store')->getinfo($goods_id,$store_id);
				$goods['total']=$getinfo['id']>0?$getinfo['total']:$goods['total'];
				$goods['price']=$getinfo['price']>0?$getinfo['price']:$goods['price'];
				$topinfo='门店<'.$getinfo['title'].'>-';
		}
		if($optionid>0){
			if($store_id && $storeset['no_goods']!=1){
				$options=model('jy_weishop/store')->getoption($goods_id,$store_id,'',$optionid);
				$goods['total']=$options['id']?$options['stock']:$goods['total'];
			}else{
				$goods['total']=$this->pdo_getcolumn('goods_option',array('id'=>$optionid,'uniacid'=>$_SESSION['uniacid']),'stock');
			}
		}
		if($goods['total']<$num){
			//此处判断库存是否还够
			if($nomsg){
				return false;
			}
			if($iscart){
				if($isadd){
					exi($topinfo."该商品超出库存不能添加了！",'error');
				}
			}else{
				exi($topinfo."您所购买的商品【{$goods['title']}】库存不足！请选择其他商品！",'error');
			}
		}
		if($goods['maxbuy'] && $num>$goods['maxbuy']){
			if($nomsg){
				return false;
			}
			if($iscart){
				if($isadd){
					exi($topinfo."该商品单次最多只能购买{$goods['maxbuy']}{$goods['unit']}！",'error');
				}
			}else{
				exi($topinfo."您所购买的商品【{$goods['title']}】单次最多只能购买{$goods['maxbuy']}{$goods['unit']}！",'error');
			}
		}
		if($goods['minbuynum'] && $num<$goods['minbuynum']){
			if($nomsg){
				return false;
			}
			if($iscart){
				if(!$isadd && $_SESSION['container']!='wxapp'){
					exi($topinfo."该商品单次最低购买{$goods['minbuynum']}{$goods['unit']}，不能减了！",'error');
				}
			}else{
				exi($topinfo."您所购买的商品【{$goods['title']}】单次最低购买{$goods['minbuynum']}{$goods['unit']}！",'error');
			}
		}
		if($goods['usermaxbuy'] && $_SESSION['uid']){
			$history_num=pdo_fetchcolumn('select ifnull(sum(og.total),0)  from ' . tablename('jy_weishop_order_goods') . ' og ' . ' left join ' . tablename('jy_weishop_order') . ' o on og.orderid=o.id ' . ' where og.goodsid=:goodsid and  o.status>=1 and o.mid=:mid  and og.uniacid=:uniacid ', array(':goodsid' => $goods['id'], ':uniacid' => $_SESSION['uniacid'], ':mid' => $_SESSION['uid']));
			if(($history_num+$num)>$goods['usermaxbuy']){
				if($nomsg){
					return false;
				}
				if($iscart){
					if($isadd){
						exi($topinfo."该商品最多只能购买{$goods['usermaxbuy']}{$goods['unit']}！您之前已经购买了{$history_num}{$goods['unit']}！",'error');
					}
				}else{
					exi($topinfo."您所购买的商品【{$goods['title']}】最多只能购买{$goods['usermaxbuy']}{$goods['unit']}！您之前已经购买了{$history_num}{$goods['unit']}！",'error');
				}
			}
		}
		$sale_offer=$this->plugin_setting('sale_offer');
		if($sale_offer['isopen']==1){
			$weekid=date("w");
			$offer['list']=$sale_offer['goods_ids'.$weekid];
			if(empty($offer['list']) || count($offer['list'])==0){
			}else{
				foreach($offer['list'] as $k=>&$v){
					if($goods_id ==$v['id']){
						if($sale_offer['maxnum']>0 && $num>$sale_offer['maxnum']){
							if($nomsg){
									return false;
							}
							if($iscart){
								if($isadd){
									exi("活动商品，最多只能购买{$sale_offer['maxnum']}{$goods['unit']}！",'error');
								}
							}else{
									exi("活动商品，最多只能购买{$sale_offer['maxnum']}{$goods['unit']}！",'error');
							}
						}
					}
				}
			}
		}
		//商品在做活动，检查下库存是否不足
		if($goods['active_plugin'] && !$nomsg){
			$this->model('activity')->check_stock($goods_id,$goods['active_plugin'],$goods['active_id'],$num);
		}
		return true;
	}
	public function get_comments($goodsid,$limit=false,&$total,$type='all',$page=0,$merchid=0){		
		if($merchid){
			$goodsid=pdo_getall('jy_weishop_goods',array('merchid'=>$merchid,'uniacid' => $_SESSION['uniacid']),'id','id');
			$goodsid=array_keys($goodsid);
		}
		$params=array('goodsid'=>$goodsid,'show'=>1);
		$parameter['orderby']=array('star desc','id desc');
		if($type=='percent'){
			$params['star']=5;
		}
		if($type=='normal_percent'){
			$params['star']=array(2,3,4);
		}
		if($type=='bad_percent'){
			$params['star']=array(0,1);
		}
		if($type=='pic'){
			$params['images !=']='';
		}
		if($type=='new'){
			$parameter['orderby']=array('createtime desc','star desc');
		}
		$parameter['params']=$params;
		$pindex = max(1, intval($page));
		$psize = $limit?:5;
		$parameter['limit']=array($pindex,$psize);
		$list=$this->pdo_getlist('goods_comments',$parameter,$total);
		if($list){
			foreach($list as &$item){
				$item['member']=model('core/member')->detail($item['mid'],array('nickname','avatar'));
				$item['member']['nickname']=$item['member']['nickname']?:'匿名用户';
				$item['images']=$item['images']?json_decode($item['images'],true):array();
				$ordergoods=pdo_get('jy_weishop_order_goods',array('goodsid'=>$item['goodsid'],'orderid'=>$item['orderid']),array('optionid','createtime'));
				$item['optionid']=$ordergoods['optionid'];
				if($ordergoods['optionid']){
					$specs=pdo_getcolumn('jy_weishop_goods_option',array('id'=>$item['optionid']),'specs');
					$specs=explode("_",$specs);
					foreach($specs as &$spec){
						$spec=pdo_getcolumn('jy_weishop_goods_spec_item',array('id'=>$spec),'title');
					}
					$item['selespename']=implode("，",$specs);
				}
				$item['createtime']=date('Y-m-d H:i:s',$item['createtime']);
			}
		}
		return $list;
	}
	public function count_comments($goodsid,$merchid=0){
		if($merchid){
			$goodsid=pdo_getall('jy_weishop_goods',array('merchid'=>$merchid,'uniacid' => $_SESSION['uniacid']),'id','id');
			$goodsid=array_keys($goodsid);
		}
		$percent = 100;
		$count = array(
			'all'=>$this->pdo_count('goods_comments',array('goodsid'=>$goodsid)),
			'good'=>$this->pdo_count('goods_comments',array('goodsid'=>$goodsid,'star'=>5)),
			'normal'=>$this->pdo_count('goods_comments',array('goodsid'=>$goodsid,'star between'=>array(2,4))),
			'bad'=>$this->pdo_count('goods_comments',array('goodsid'=>$goodsid,'star'=>array(0,1))),
			'pic'=>$this->pdo_count('goods_comments',array('goodsid'=>$goodsid,'images !='=>'')),
		);
		if(0 < $count['all']){
			$percent = intval(($count['good'] / $count['all']) * 100);
			$normal_percent= intval(($count['normal'] / $count['all']) * 100);
			$bad_percent= intval(($count['bad'] / $count['all']) * 100);
			$pic= intval(($count['pic'] / $count['all']) * 100);
		}
		return array(
			"count" => $count,
			'percent' => $percent,
			'normal_percent'=>$normal_percent,
			'bad_percent'=>$bad_percent,
			'pic'=>$pic
		);
	}
	public function get_goodsitem($id){
		$store_id=$_SESSION['store_id'];
		$goods=pdo_get('jy_weishop_goods',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		if(!$goods){
			return error('选择的商品不存在，请重新选择！');
		}
		$goods['userbuy'] = 1;
		$goods['levelbuy'] = 1;
		$goods['groupbuy'] = 1;
		$goods['pcatetitle']=pdo_getcolumn('jy_weishop_goods_group',array('id'=>$goods['pcate']),'title');
		$goods['ccatetitle']=pdo_getcolumn('jy_weishop_goods_group',array('id'=>$goods['ccate']),'title');
		//来自分销MID（
		$goods['myshopmid']=intval($_RQ['frommyshop']);
		$jy_commission = check_account_permission('jy_commission');
		if($jy_commission && $goods['myshopmid']){
			$member=pdo_get('core_members',array('id'=>$goods['myshopmid']),array('id','avatar','nickname'));
			$goods['myshop']=pdo_get('jy_commission_shop',array('mid'=>$goods['myshopmid'],'uniacid'=>$_SESSION['uniacid']));
			$goods['myshop']['logo']=$goods['myshop']['logo']?tomedia($goods['myshop']['logo']):tomedia($member['avatar']);
			$goods['myshop']['title']=$goods['myshop']['title']?$goods['myshop']['title']:$member['nickname'].'的小店';
		}
		//来自多商户店(非下级也可以分销）
		$goods['merchid']=$_RQ['merchid']?intval($_RQ['merchid']):$goods['merchid'];
		$jy_kefu = check_account_permission('jy_kefu');
		$jy_merch = check_account_permission('jy_merch');
		if($jy_merch && $goods['merchid']){
			$goods['merch']=pdo_get('jy_merch_user',array('id'=>$goods['merchid'],'uniacid'=>$_SESSION['uniacid']));
			$member=pdo_get('core_members',array('id'=>$goods['merch']['mid']),array('id','avatar','nickname'));
			$goods['merch']['logo']=$goods['merch']['logo']?tomedia($goods['merch']['logo']):tomedia($member['avatar']);
			$goods['merch']['merchname']=$goods['merch']['merchname']?$goods['merch']['merchname']:$member['nickname'].'的小店';
			if($goods['merch']['iskefu']){
				$goods['merch']['showkefu']=1;
			}
		}
		pdo_update('jy_weishop_goods',array('readnum +='=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		//浏览权限
		$levelinfo = model('jy_weishop/member')->get_level();
		if($goods['showlevels']){
			$fastvalue=substr($goods['showlevels'],0,1);
			if($fastvalue!=';'){
				$goods['showlevels']=';'.$goods['showlevels'];
			}
			$lastvalue=substr($goods['showlevels'],-1,1);
			if($lastvalue!=';'){
				$goods['showlevels']=$goods['showlevels'].';';
			}
			if(strpos($goods['showlevels'],';'.$levelinfo['id'].';')===false){
				return error('您没有权限浏览该商品！');
			}
		}
		$groupinfo = model('jy_weishop/member')->get_group();
		if($goods['showgroups']){
			$fastvalue=substr($goods['showgroups'],0,1);
			if($fastvalue!=';'){
				$goods['showgroups']=';'.$goods['showgroups'];
			}
			$lastvalue=substr($goods['showgroups'],-1,1);
			if($lastvalue!=';'){
				$goods['showgroups']=$goods['showgroups'].';';
			}
			if(strpos($goods['showgroups'],';'.$groupinfo['id'].';')===false){
				return error('您没有权限浏览该商品！');
			}
		}
		//判断买家秀是否开启
		//买家秀
		$buyxiu=plugin('jy_weishop')->plugin_setting('buyxiu');
		foreach($buyxiu['goods_ids'] as $xiuv){
			if($xiuv['id'] == $goods['id']){
				$goods['isbuyxiu']=1;
			}
		}
		if($goods['isbuyxiu'] && $buyxiu['likes']){
			$install = check_account_permission('jy_vote');
			if(!$this->plugin_exists('jy_vote')){
				$goods['isbuyxiu'] =0;
			}
		}
		$install = check_account_permission('jy_commission');
		if($install){
				$goods['jy_commission'] =1;
		}
		//营销设置
		$saleset=plugin('jy_weishop')->plugin_setting('saleset');
		$member=pdo_get('jy_weishop_member',array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid']));
		$goods['canbuy'] = ($goods['status'] == 1) && empty($goods['deleted']) && ($goods['total'] > 0);
		$goods['unit'] = ((empty($goods['unit']) ? '件' : $goods['unit']));
		$goods['images'] = json_decode($goods['images'],true);
		foreach($goods['images'] as &$image){
			$image=tomedia($image);
		}
		$goods['images']=$images[0]?$images:array($goods['image']);
		$goods['subtitle'] = cfc('tools')->substr($goods['subtitle'],0,48);
		if($goods['weight']){
			$goods['weight']=round($goods['weight']/1000,2);
		}
		if (0 < $goods['usermaxbuy']) {
			$order_goodscount = pdo_fetchcolumn('select ifnull(sum(og.total),0)  from ' . tablename('jy_weishop_order_goods') . ' og ' . ' left join ' . tablename('jy_weishop_order') . ' o on og.orderid=o.id ' . ' where og.goodsid=:goodsid and  o.status>=1 and o.mid=:mid  and og.uniacid=:uniacid ', array(':goodsid' => $goods['id'], ':uniacid' => $_SESSION['uniacid'], ':mid' => $_SESSION['uid']));
			$goods['order_goodscount']=$order_goodscount;
			if ($goods['usermaxbuy'] <= $order_goodscount) {
				$goods['userbuy'] = 0;
				$goods['canbuy'] = false;
			}
		}
		$isfullback = false;
		if ($goods['isfullback']) {
			$isfullback = true;
			$fullbackgoods = pdo_fetch('SELECT * FROM ' . tablename('jy_weishop_goods_options') . ' WHERE uniacid = ' . $uniacid . ' and goodsid = ' . $id . ' limit 1 ');
			if ($goods['hasoption'] == 1) {
				$fullprice = pdo_fetch('select min(allfullbackprice) as minfullprice,max(allfullbackprice) as maxfullprice,min(allfullbackratio) as minfullratio' . "\r\n" . '                            ,max(allfullbackratio) as maxfullratio,min(fullbackprice) as minfullbackprice,max(fullbackprice) as maxfullbackprice' . "\r\n" . '                            ,min(fullbackratio) as minfullbackratio,max(fullbackratio) as maxfullbackratio,min(`day`) as minday,max(`day`) as maxday' . "\r\n" . '                            from ' . tablename('jy_weishop_goods_option') . ' where goodsid = ' . $id . '');
				$fullbackgoods['minallfullbackallprice'] = $fullprice['minfullprice'];
				$fullbackgoods['maxallfullbackallprice'] = $fullprice['maxfullprice'];
				$fullbackgoods['minallfullbackallratio'] = $fullprice['minfullratio'];
				$fullbackgoods['maxallfullbackallratio'] = $fullprice['maxfullratio'];
				$fullbackgoods['minfullbackprice'] = $fullprice['minfullbackprice'];
				$fullbackgoods['maxfullbackprice'] = $fullprice['maxfullbackprice'];
				$fullbackgoods['minfullbackratio'] = $fullprice['minfullbackratio'];
				$fullbackgoods['maxfullbackratio'] = $fullprice['maxfullbackratio'];
				$fullbackgoods['fullbackratio'] = $fullprice['minfullbackratio'];
				$fullbackgoods['fullbackprice'] = $fullprice['minfullbackprice'];
				$fullbackgoods['minday'] = $fullprice['minday'];
				$fullbackgoods['maxday'] = $fullprice['maxday'];
			}else{
				$fullbackgoods['maxallfullbackallprice'] = $fullbackgoods['minallfullbackallprice'];
				$fullbackgoods['maxallfullbackallratio'] = $fullbackgoods['minallfullbackallratio'];
				$fullbackgoods['minday'] = $fullbackgoods['day'];
			}
			$merchid = $goods['merchid'];
			if (json_decode($goods['labelname'], true)) {
				$labelname = json_decode($goods['labelname'], true);
			}
			 else {
				$labelname = unserialize($goods['labelname']);
			}
			if ($is_openmerch == 0) {
				if (0 < $merchid) {
					$err = true;
				}
			}
			 else if ((0 < $merchid) && ($goods['checked'] == 1)) {
				$err = true;
			}
		}
		if ((0 < $goods['isendtime']) && (0 < $goods['endtime']) && ($goods['endtime'] < time())) {
			$goods['canbuy'] = false;
		}
		$goods['timestate'] = '';		
		//配送设置
		$getdispatch=$this->get_dispatch($goods['id']);
		$goods=array_merge($goods,$getdispatch);
		$has_city=$goods['has_city'];	
		//规格
		$specs_list=pdo_getall('jy_weishop_goods_spec',array('goodsid'=>$id,'uniacid'=>$_SESSION['uniacid']),array('id','title'),'','paixu asc');
		//已选规格
		$selectspecs = array();
		$selespename = '';
		if($specs_list){
				foreach($specs_list as $k=>&$sp){
					$sp['items']=pdo_getall('jy_weishop_goods_spec_item',array('specid'=>$sp['id'],'uniacid'=>$_SESSION['uniacid']),array('id','title'),'','paixu asc');
					if($sp['items']){
						$selectspecs[$k]=$sp['items'][0]['id'];
						$selespename .=$sp['items'][0]['title'].'，';
					}
				}			
				if(count($specs_list)>0){
					$goods['optiontotal']=pdo_getsum('jy_weishop_goods_option',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$id),'stock');
					if($goods['optiontotal']<0){
						$goods['canbuy']==false;
					}else{
						$goods['canbuy']==true;
					}
				}
		}
		//默认已选参数：
		$spsids = '';
		foreach($selectspecs as $k=>&$s){
				if($k==0){
					$spsids .= $s;
				}else{
					$spsids .= '_'.$s;
				}
		}
		$goods['selectspecs']=$selectspecs;
		$optionsid=pdo_getcolumn('jy_weishop_goods_option',array('goodsid'=>$id,'specs'=>$spsids),'id');
		//默认商品规格价格：
		$goods['optionid']=$optionsid;
		$goods['storeid']=$store_id;
		$goods=$this->model('activity')->get_upgoods($goods);
		$return['options']=$goods['options'];
		$return['selespename'] = $selespename;
		$option_list=pdo_getall('jy_weishop_goods_option',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$id),array('id','specs','thumb','stock','price','productprice','costprice','goodssn','productsn','weight'),'','paixu asc');
		if($option_list){
				foreach($option_list as &$i){
					$i['specs']=explode('_',$i['specs']);
					foreach($i['specs'] as $j){
						$op=pdo_get('jy_weishop_goods_spec_item',array('id'=>intval($j)),array('specid','title'));
						$spec_title=pdo_getcolumn('jy_weishop_goods_spec',array('id'=>$op['specid']),'title');
						$i[$spec_title]=$op['title'];
					}
					$i['num']=$i['stock'];
					$i['old_price']=$i['productprice'];
					$i['cost_price']=$i['costprice'];
					$i['bm']=$i['goodssn'];
					$i['tm']=$i['productsn'];
					$i['image']=$i['thumb'];
				}
				//$specs_list['option']=$option_list;
		}
		$goods['specs_list'] = $specs_list;		
		//扩展属性
		if($goods['labelid']){
			$goods['labelname'] = pdo_getcolumn('jy_weishop_goods_label',array('id'=>$goods['labelid'],'uniacid'=>$_SESSION['uniacid']),'labelname');
			$goods['labelname'] = json_decode($goods['labelname'],true);
		}
		//商户满减
		$saleset['enough']=json_decode($saleset['enough'],true);
		//预计送达时间
		$deliverytime = date("m月d日",strtotime("+2 day"));
		$goods['deliverytime'] = $deliverytime;
		//是否可添加购物车
		$goods['canAddCart'] = true;
		if (($goods['type'] == 1) || ($goods['type'] == 2) || ($goods['type'] == 3) || ($goods['type'] == 20) || !(empty($goods['cannotrefund'])) || !(empty($is_task_goods)) || !(empty($gifts))) {
			$goods['canAddCart'] = false;
		}
		$goods['isdiscount_time']=json_decode($goods['isdiscount_time'],true);		
		if($goods['isdiscount'] && $goods['isdiscount_time']['end'] > time() && $goods['isdiscount_time']['start'] <time()){
			$goods['cuxiaoprice'] = $goods['price'];
			$goods['isdiscount']=1;
		}else{
			$goods['isdiscount']=0;
		}
		//满减、包邮活动
		if(($goods['type'] !=1 && $goods['isverify'] !=1 && $goods['dispatchtype'] ==1 && $goods['dispatchprice']==0) || $saleset['baoyou_status']==1 || $goods['fullnum']>0 || $goods['fullmoney']>0 ){
			$goods['manjian']=1;	
		}
		//抵扣、赠送积分活动
		if((!$goods['deduct'] && $goods['deduct'] !='0.00') || $goods['credit']){
			$goods['deduct_credit']=1;	
		}
		if($saleset['enough'] || $goods['manjian'] || $goods['deduct_credit']){
			$goods['huodong']=1;
		}else{
			$goods['huodong']=0;
		}
		if((!empty($coupons) || $goods['isdiscount'] || $goods['huodong'] || $credit['buy'] || $goods['buyagain']>0  || ($fullbackgoods && $isfullback))){
			$goods['sale']=1;
		}else{
			$goods['sale']=0;		
		}
		//商品描述为空
		$goods['content']=$goods['content']?$goods['content']:'<div></div>';
		//参数
		$goods['param']=json_decode($goods['param'],true);
		//货物地址：
		$goods['pcd'] = json_decode($goods['pcd'],true);
		//小程序二维码：
		$url='/jy_weishop/goods/detail/index?id='.$_SESSION['goodsid'].'&fromuser='.$_SESSION['uid'];
		$pid='id'.$_SESSION['goodsid'];
		$goods['appcode'] = model('jy_weishop/model')->get_wxappewm($url,$pid);
		$goods['subtitle1']=cfc('tools')->substr($goods['subtitle1'],0,13);
		$goods['title1']=cfc('tools')->substr($goods['title'],0,14);
		$goods['title2']=cfc('tools')->substr($goods['title'],14,13);
		$goods['title2']=$goods['subtitle1']?$goods['subtitle1']:$goods['title2'];
		$goods['title2']=$goods['title2']?$goods['title2'].'...':'暂无描述';
		//判断nobuy状态：
		if($goods['userbuy']==0){
			$goods['nobuytitle']='您已经超出最大'.$goods['usermaxbuy'].'件购买量';
		}elseif($goods['levelbuy']==0){
			$goods['nobuytitle']='您当前会员等级没有购买权限';
		}elseif($goods['groupbuy']==0){
			$goods['nobuytitle']='您所在的用户组没有购买权限';
		}elseif($goods['timebuy']==-1){
			$goods['nobuytitle']='未到开始抢购时间!';
		}elseif($goods['timebuy']==1){
			$goods['nobuytitle']='抢购时间已经结束';
		}else{
			$goods['nobuytitle']='商品已售罄';
		}
		$goods['looks']=pdo_count('jy_weishop_member_history',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),'id');
		$goods['likes']=pdo_count('jy_weishop_member_like',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),'id');
		$goods['votes']=pdo_count('jy_weishop_member_vote',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),'id');
		$pindex = max(1, 0);
		$psize = 5;
		$members=pdo_getslice('jy_weishop_member_history',array('uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),array($pindex,$psize),$total,array('mid'),'','id desc');
		foreach($members as &$mv){
					$memberinfo=pdo_get('core_members',array('id'=>$mv['mid']),array('nickname','avatar'));
					$mv['nickname']=$memberinfo['nickname'];
					$mv['avatar']=$memberinfo['avatar'];
		}
		$goods['lookusers']=$members;
		$goods['islike']=pdo_count('jy_weishop_member_like',array('mid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),'id');
		$goods['isvote']=pdo_count('jy_weishop_member_vote',array('mid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']),'id');
		//原价：
		$goods['oldprice']=$goods['oldprice']?:$goods['price']*1.3;
		$goods['oldprice']=price($goods['oldprice'],true);
		return $goods;
	}
	public function get_dispatch($goodsid,$total=''){
		$city_express=$this->plugin_setting('citypeisong');
		if($city_express['isopen']){//开启同城配送
			$goods['ispeisong']=true;
			$goods['peisong_pcd']=$city_express['pcd'];
			$goods['dispatchprice']=intval($city_express['start_fee']);
			$goods['isdispatcharea']=1;
			if($city_express['pcd']){
				$goods['has_city']=1;
				$goods['citys']=array(
					$goods['peisong_pcd']['province']=>true,
					$goods['peisong_pcd']['city']=>true,
				);
			}
			return $goods;
		}
		//配送设置
		$goodsdispatch=$this->pdo_get('goods_dispatch',array('goodsid'=>$goodsid));
		$goods['fullnum']=$goodsdispatch['fullnum'];
		$goods['fullmoney']=$goodsdispatch['fullmoney'];
		$goods['fullnoareas']=$goodsdispatch['fullnoareas'];
		$goods['template_id']=$goodsdispatch['template_id'];
		$goods['weight']=$goodsdispatch['weight'];
		$goods['dispatchprice']=$goodsdispatch['price'];
		//配送区域
		$goods['dispatchtype']=$goodsdispatch['type'];
		if($goods['type']==0 && $goods['dispatchtype']==0){
			$dispatch=pdo_get('jy_weishop_dispatch',array('uniacid'=>$_SESSION['uniacid'],'id'=>$goods['template_id']));
			$goods['dispatchprice']=$dispatch['shouprice'];	
			$goods['isdispatcharea']=$dispatch['isdispatcharea'];	
			if($dispatch['type']==1){//按件
				$goods['dispatchxutype']=0;
				if($total>1){
					$goods['dispatchprice'] +=intval(($total-1)*$dispatch['xuprice']);
				}
			}else{//按重量
				$goods['dispatchxutype']=1;
				$total=$total?:1;
				$goods['allweight'] =$total*$goods['weight'];
				if($goods['allweight']>$dispatch['shouweight']){
					$lastweight=$goods['allweight']-$dispatch['shouweight'];
					$goods['dispatchprice'] +=intval(($lastweight/$dispatch['xuweight'])*$dispatch['xuprice']);
				}
			}
			if($dispatch['isdispatcharea']==0){
				$citys=$dispatch['nodispatchareas'];
				if($citys){
					$goods['citys']=json_decode($citys,true);
					$goods['has_city']=1;
				}
				else{
					$goods['has_city']=0;
				}
			}elseif($dispatch['isdispatcharea']==1){
				$citys=$dispatch['onlydispatchareas'];
				if($citys){
					$goods['has_city']=1;
					$goods['citys']=json_decode($citys,true);
				}
				else{
					$goods['has_city']=0;
				}
			}elseif($dispatch['isdispatcharea']==2){
				$citys=array();
				$dispatch['areas']=json_decode($dispatch['areas'],true);
				$goods['has_city']=0;
				foreach($dispatch['areas'] as $cv){
					if($cv['area']){
						$goods['has_city']=1;
						$cv['area']=json_decode($cv['area'],true);
						foreach($cv['area'] as $k=>$av){
							$citys[$k]=$av;
						}
					}
				}
				$goods['citys']=$citys;
				//获取首个区域费用
				$areasone=$dispatch['areas'][0];
				$goods['dispatchprice']=$areasone['shouprice'];	
				if($areasone['type']==1){//按件
					$goods['dispatchxutype']=0;
					if($total>1){
						$goods['dispatchprice'] +=intval(($total-1)*$areasone['xuprice']);
					}
				}else{//按重量
					$goods['dispatchxutype']=1;
					$total=$total?:1;
					$goods['allweight'] =$total*$goods['weight'];
					if($goods['allweight']>$areasone['shou']){
						$lastweight=$goods['allweight']-$areasone['shou'];
						$goods['dispatchprice'] +=intval(($lastweight/$areasone['xu'])*$areasone['xuprice']);
					}
				}
			}
		}else{
			$goods['has_city']=0;
		}
		$goods['dispatchprice']=intval($goods['dispatchprice']);
		return $goods;
	}
	public function get_diyformfields($goodsid){
		$item=pdo_get('jy_weishop_goods',array('id'=>$goodsid,'uniacid'=>$_SESSION['uniacid']),array('diyfields','diyformid','diyformtype'));
		if($item['diyformtype']==1){
				return $item['diyfields']?json_decode($item['diyfields'],true):array();
		}elseif($item['diyformtype']==2){
				$diyfields=pdo_getcolumn('jy_weishop_diyform_temp',array('id'=>$item['diyformid'],'uniacid'=>$_SESSION['uniacid']),'diyformfields');
				return $diyfields?json_decode($diyfields,true):array();
		}else{
			$shopset=$this->plugin_setting('shopset');
			if($shopset['is_orderdiyform']==1 && $shopset['orderdiyform']){
				$diyfields=pdo_getcolumn('jy_weishop_diyform_temp',array('id'=>$shopset['orderdiyform'],'uniacid'=>$_SESSION['uniacid']),'diyformfields');
				return $diyfields?json_decode($diyfields,true):array();
			}else{
				return array();
			}
		}
		
	}
	public function is_onegoods($current_plugin='',$RQpluginname=''){
		$current_plugin=$current_plugin?:$_SESSION['current_plugin'];
		if(!$RQpluginname && $current_plugin && $current_plugin!='core' && $current_plugin!='jy_weishop'){//来自其他场景体
			$basic=plugin($current_plugin)->plugin_setting('basic');
			if($basic['is_onegoods']){//开启独立商品
				return $current_plugin;
			}
		}
		if($RQpluginname){
			return $RQpluginname;
		}
		return false;
	}
}