<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	购物卡
*/
class goodscard extends \plugin{
	public function getcard($id=null,$gettype=1,$senduid=0){
		if(!$id){
			exi('购物卡不存在，请重新选择购物卡','error');
		}
		$card = pdo_get('jy_weishop_goodscard',array('uniacid'=>$_SESSION['uniacid'],'id'=>$id));
		$getallnum = pdo_count('jy_weishop_goodscard_getlog',array('uniacid'=>$_SESSION['uniacid'],'cardid'=>$id));
		if($card['t'] <= $getallnum && $card['t']>0){
			exi('不能再领了，已经上限了!','error');
		}
		$getnum = pdo_count('jy_weishop_goodscard_getlog',array('uniacid'=>$_SESSION['uniacid'],'cardid'=>$id,'mid'=>$_SESSION['uid']));
		if($getnum && $card['getmax'] && $card['getmax'] <= $getnum){
			exi( '不能再领了，已经上限了!','error');
		}
		$data=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$_SESSION['uid'],
			'cardid'=>$id,
			'gettype'=>$gettype,
			'senduid'=>$senduid,
			'createtime'=>TIMESTAMP,
		);
		pdo_insert('jy_weishop_goodscard_getlog',$data);
		return true;
	}
	public function getorderfee($id=null,$price){
		$cardid=intval($id);
		$carditem=pdo_get('jy_weishop_goodscard_getlog',array('id'=>$cardid,'uniacid'=>$_SESSION['uniacid']));
		$card_detail=pdo_get('jy_weishop_goodscard',array('id'=>$carditem['cardid'],'uniacid'=>$_SESSION['uniacid']));
		$carditem=array_merge($card_detail,$carditem);
		if($carditem){
			//使用购物卡
			$new_order['cardid']=$cardid;
			if($carditem['backtype']==1){
				$new_order['card_discount']=$carditem['discount'];
				if($new_order['card_discount']<=10 && $new_order['card_discount']>=0.1){
					$new_order['price']=$price*$new_order['card_discount']/10;
				}
			}else{
				$new_order['card_de_price']=$carditem['deduct'];
				$new_order['price']=$price-$new_order['card_de_price'];
			}
		}
		return $new_order;
	}
	public function getmycard_ing($cardtype=1,$goodsprice,$level_de_price='',$orders=''){
		//整理购物卡数据，先获取用户所有待使用购物卡，再从中筛选出未过期的购物卡且本次下单可用的购物卡！
		$cards=$this->model('card')->getmycard();
		if($cards){
			$newcards=array();
			foreach($cards as $key=>&$card){
				$card_detail=pdo_get('jy_weishop_goodscard',array('id'=>$card['cardid'],'cardtype'=>$cardtype,'uniacid'=>$_SESSION['uniacid']));
				if($card_detail['backtype']==2){
					$card_detail['deduct']=0;
				}
				if(!$card_detail){
					unset($cards[$key]);
					continue;
				}
				if(!$card_detail['status']){
					//购物卡状态为不可用
					unset($cards[$key]);
					continue;
				}
				//判断使用限制
				if($card_detail['limitusetype']){
					switch($card_detail['limitusetype']){
						case 1://不可与促销优惠同时使用
							
						case 2://不可与会员折扣同时使用
							if($level_de_price){
								unset($cards[$key]);
								continue;
							}
						case 3://不可与促销、折扣同时使用
							if($level_de_price){
								unset($cards[$key]);
								continue;
							}
					}
				}
				//判断有效期
				if($card_detail['timelimittype']==1){
					//有效期类型为领取后若干天内使用
					$days=(TIMESTAMP-$card['createtime'])/86400;
					if($card_detail['timedays']<$days){
						//已过期
						unset($cards[$key]);
						continue;
					}
				}elseif($card_detail['timelimittype']==2){
					$card_detail['limittimes']=json_decode($card_detail['limittimes'],true);
					if(TIMESTAMP<$card_detail['limittimes']['start'] || TIMESTAMP>$card_detail['limittimes']['end']){
						//不在有效期内
						unset($cards[$key]);
						continue;
					}
				}
				//判断购物券是否当前可用
				if($orders){
					$check=false;
					foreach($orders as $g){
						$merchid=pdo_getcolumn('jy_weishop_goods',array('id'=>$g['goodsid']),'merchid');
						if($merchid && $merchid!=$card_detail['merchid']){
							
						}else{
							$check=true;
						}
					}
					if(!$check){
							//不可用
							unset($cards[$key]);
							continue;
					}
				}
				if($cardtype==1){
					if($card_detail['limitgoodtype'] && $card_detail['limitgoodids']){
						$card_detail['limitgoodids']=json_decode($card_detail['limitgoodids'],true);
						$check=false;
						if($orders){
							foreach($orders as $g){
								if(in_array($g['goodsid'],$card_detail['limitgoodids'])){
									if($g['price']*$g['total']>$card_detail['enough']){
										$check=true;
										switch($card_detail['backtype']){
											case 0://立减
												$card['de_price']=$card_detail['deduct'];
												$card['content']="满{$card_detail['enough']}减{$card_detail['deduct']}";
												break;
											case 1://折扣
												$card['de_price']=(1-$card_detail['discount']/10)*$g['price']*$g['total'];
												$card['content']="满{$card_detail['enough']}打{$card_detail['discount']}折";
												break;
											case 2://返利
												$card['de_price']=0;
												$card['content']="满{$card_detail['enough']}返{$card_detail['backmoney']}余额，{$card_detail['backcredit']}积分，{$card_detail['backredpack']}现金";
												break;
											default:
												$card['de_price']=0;
												$card['content']='';
										}
									}
								}
							}
						}
						if(!$check){
							//不可用
							unset($cards[$key]);
							continue;
						}
						
					}elseif($card_detail['limitgoodcatetype'] && $card_detail['limitgoodcateids']){
						$card_detail['limitgoodcateids']=json_decode($card_detail['limitgoodcateids'],true);
						$check=false;
						if($orders){
							foreach($orders as $g){
								if(in_array($g['cateid'],$card_detail['limitgoodcateids'])){
									if($g['price']*$g['total']>$card_detail['enough']){
										$check=true;
										switch($card_detail['backtype']){
											case 0://立减
												$card['de_price']=$card_detail['deduct'];
												$card['content']="满{$card_detail['enough']}减{$card_detail['deduct']}";
												break;
											case 1://折扣
												$card['de_price']=(1-$card_detail['discount']/10)*$g['price']*$g['total'];
												$card['content']="满{$card_detail['enough']}打{$card_detail['discount']}折";
												break;
											case 2://返利
												$card['de_price']=0;
												$card['content']="满{$card_detail['enough']}返{$card_detail['backmoney']}余额，{$card_detail['backcredit']}积分，{$card_detail['backredpack']}现金";
												break;
											default:
												$card['de_price']=0;
												$card['content']='';
										}
									}
								}
							}
						}
						if(!$check){
							//不可用
							unset($cards[$key]);
							continue;
						}
					}else{
							switch($card_detail['backtype']){
											case 0://立减
												$card['de_price']=$card_detail['deduct'];
												$card['content']="满{$card_detail['enough']}减{$card_detail['deduct']}";
												break;
											case 1://折扣
												$card['de_price']=(1-$card_detail['discount']/10)*$goodsprice;
												$card['content']="满{$card_detail['enough']}打{$card_detail['discount']}折";
												break;
											case 2://返利
												$card['de_price']=0;
												$card['content']="满{$card_detail['enough']}返{$card_detail['backmoney']}余额，{$card_detail['backcredit']}积分，{$card_detail['backredpack']}现金";
												break;
											default:
												$card['de_price']=0;
												$card['content']='';
							}
					}
					if($goodsprice && $card_detail['enough'] && $goodsprice<$card_detail['enough']){
						//不可用
						unset($cards[$key]);
						continue;
					}
				}
				$card=array_merge($card_detail,$card);
				if($cards[$key]){
					$newcards[]=$cards[$key];
				}
			}
		}
		if(!empty($newcards)){
			//存在可用购物卡，选择一个抵扣金额最大的作为默认选中的购物卡
			paixu($newcards,'de_price','desc');
		}
		return $newcards;
	}
	public function getmycard($isuse='',$type='',$past=''){
		$p=array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid']);
		if($isuse==1){
			$p=array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid'],'isuse'=>1);
		}else{
			$p=array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid'],'islock'=>0,'isuse'=>0);
		}
		$return['isuse'] = $isuse ? $isuse :0;
		$list=pdo_getall('jy_weishop_goodscard_getlog',$p);
		foreach($list as &$v){
			$v['card']=$this->intcard($v['cardid'],$v['createtime']);
		}
		return $list;
	}
	public function getdetail($id){
		$p=array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid'],'id'=>$id);
		$item=pdo_get('jy_weishop_goodscard_getlog',$p);
		$item['card']=$this->intcard($item['cardid']);
		return $item;
	}
	//整理一下券
	public function intcard($id,$createtime=0){
			$gettype=array('1'=>'充值兑换','2'=>'活动赠送','3'=>'朋友赠送');
			$card=pdo_get('jy_weishop_goodscard',array('uniacid'=>$_SESSION['uniacid'],'id'=>$id));
			if ($card['t'] >=1){
					$getallnum = pdo_count('jy_weishop_goodscard_getlog',array('uniacid'=>$_SESSION['uniacid'],'cardid'=>$id));
					if ($getallnum >= $card['t']){
						$card['last'] = 0;
						$card['isdisa'] = '1';
					}else{
						$totle = $card['t'];
						$card['lastratio'] = intval(($card['last'] / $totle) * 100);
					}
			}else{
					$card['last'] = 1;
					$card['lastratio'] = 100;
			}
			$card['gettypetitle']=$gettype[$card['gettype']];
			$card['rightdesc']='来自：'.$gettype[$card['gettype']];
			if($card['merchid']){
				$card['merchname']=pdo_getcolumn('jy_merch_user',array('id'=>$card['merchid']),'merchname');
			}
			$card['past']=0;
			if ($card['timelimittype'] == '0') {
				$card['color'] = 'blue';
				$card['time'] = '永久有效';
			}elseif($card['timelimittype']==1){
				$card['color'] = 'orange';
				$time=$createtime+$card['timedays']*24*3600;
				if(time()>$time){
					$card['past']=1;
				}else{
					$start=$createtime;
					$start=date('Y/m/d',$start);
					$time=date('Y/m/d',$time);
					$card['time']=$start.'至'.$time;
				}
			}elseif($card['timelimittype']==2){
				$card['color'] = 'red';
				$card['limittimes']=json_decode($card['limittimes'],true);
				if(time()>$card['limittimes']['tend']){
					$card['past']=1;
				}else{
					$card['limittimes']['tstart']=date('Y/m/d',$card['limittimes']['tstart']);
					$card['limittimes']['tend']=date('Y/m/d',$card['limittimes']['tend']);
					$card['time']=$card['limittimes']['tstart'].'至'.$card['limittimes']['tend'];
				}
			}
			$card['timetitle'] = $timetitle;
		return $card;
	}
	public function usecard($id){
		$cardid=intval($id);
		$card_detailid=pdo_getcolumn('jy_weishop_goodscard_getlog',array('id'=>$cardid,'uniacid'=>$_SESSION['uniacid']),'cardid');
		$card_detail=pdo_get('jy_weishop_goodscard',array('id'=>$card_detailid,'uniacid'=>$_SESSION['uniacid']));
		if($card_detailid && $card_detail['backtype']=='2'){
			//使用购物卡
			if($card_detail['backmoney']){
				model('core/member')->add_credit2($_SESSION['uid'],$card_detail['backmoney'],'返余额');
			}
			if($card_detail['backcredit']){
				model('core/member')->add_credit1($_SESSION['uid'],$card_detail['backcredit'],'返积分');
			}
			if($card_detail['backredpack']){
				$params=array(
					'mid'=>$_SESSION['uid'],
					'money'=>$card_detail['backredpack'],
					'remark'=>'返现金红包',
				);
				model('core/red_pack')->get_money($params);
			}
		}else{
			pdo_update('jy_weishop_goodscard_getlog',array('isuse'=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
		return true;
	}
}