<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	工具类
*/
class model extends \plugin{
	public function msgtpl_tags($area){
		$tags=array(
			array('title'=>'通用类','data'=>array(
				array('name'=>'商城名称'),
				array('name'=>'粉丝昵称'),
			)),
			array('title'=>'订单类','data'=>array(
				array('name'=>'订单号'),
				array('name'=>'订单金额'),
				array('name'=>'运费'),
				array('name'=>'商品详情'),
				array('name'=>'快递公司'),
				array('name'=>'快递单号'),
				array('name'=>'购买者姓名'),
				array('name'=>'购买者电话'),
				array('name'=>'收货地址'),
				array('name'=>'下单时间'),
				array('name'=>'支付时间'),
				array('name'=>'发货时间'),
				array('name'=>'收货时间'),
				array('name'=>'门店'),
				array('name'=>'门店地址'),
				array('name'=>'门店联系人'),
				array('name'=>'门店营业时间'),
				array('name'=>'虚拟物品自动发货内容'),
				array('name'=>'虚拟卡密自动发货内容'),
				array('name'=>'自提码'),
				array('name'=>'备注信息'),
				array('name'=>'商品数量'),
				array('name'=>'商品名称'),
			)),
			array('title'=>'排号类','data'=>array(
				array('name'=>'排队号'),
				array('name'=>'取号时间'),
				array('name'=>'等待人数'),
			)),
		);
		return $tags;
	}
	public function date($time){
		$res=array(
			'day'=>0,
			'hour'=>0,
			'minute'=>0,
			'second'=>0,
		);
		
		if($time<=0){
			return $res;
		}
		$res['day']=intval($time/86400);
		$time=$time-$res['day']*86400;
		$res['hour']=intval($time/3600);
		$time=$time-$res['hour']*3600;
		$res['minute']=intval($time/60);
		$res['second']=intval($time-$res['minute']*60);
		return $res;
	}
	public function getExpressList($express, $expresssn)
	{
		$express_set = $this->plugin_setting('express');
		$express_set['cache']=$express_set['cache']?:1;
		$express = ($express == 'jymwl' ? 'jiayunmeiwuliu' : $express);
		$express = ($express == 'TTKD' ? 'tiantian' : $express);
		$express = ($express == 'jjwl' ? 'jiajiwuliu' : $express);
		$express = ($express == 'zhongtiekuaiyun' ? 'ztky' : $express);
		if (!empty($express_set['isopen']) && !empty($express_set['apikey'])) {
			if (!empty($express_set['cache']) && (0 < $express_set['cache'])) {
				$cache_time = $express_set['cache'] * 60;
				$cache = $this->pdo_get('express_cache',array('express' => $express, 'expresssn' => $expresssn));
				if ((time() <= $cache['lasttime'] + $cache_time) && !empty($cache['datas'])) {
					return json_decode($cache['datas'],true);
				}
			}
			if ($express_set['isopen'] == 1) {
				$url = 'http://api.kuaidi100.com/api?id=' . $express_set['apikey'] . '&com=' . $express . '&nu=' . $expresssn;
				$params = array();
			}else {
				$url = 'http://poll.kuaidi100.com/poll/query.do';
				$params = array('customer' => $express_set['customer'], 'param' => ijson_encode(array('com' => $express, 'num' => $expresssn)));
				$params['sign'] = md5($params['param'] . $express_set['apikey'] . $params['customer']);
				$params['sign'] = strtoupper($params['sign']);
			}
			$response = cfc('http')->request($url, $params);
			$content = $response;
			$info = json_decode($content, true);
		}

		if (!isset($info) || empty($info['data']) || !is_array($info['data'])) {
			$url = 'https://www.kuaidi100.com/query?type=' . $express . '&postid=' . $expresssn . '&id=1&valicode=&temp=';
			$response = cfc('http')->request($url);
			$content = $response;
			$info = json_decode($content, true);
			$useapi = false;
		}else {
			$useapi = true;
		}
		$list = array();
		if (!empty($info['data']) && is_array($info['data'])) {
			foreach ($info['data'] as $index => $data) {
				$list[] = array('time' => trim($data['time']), 'step' => trim($data['context']));
			}
		}
		if ((0 < $express_set['cache']) && count($list)>1) {
			if (empty($cache)) {
				pdo_insert('jy_weishop_express_cache', array('expresssn' => $expresssn, 'express' => $express, 'lasttime' => time(), 'datas' => ijson_encode($list)));
			}else {
				pdo_update('jy_weishop_express_cache', array('lasttime' => time(), 'datas' => ijson_encode($list)), array('id' => $cache['id']));
			}
		}
		return $list;
	}
	public function set_tanmu($orderid='',$plugin_name=''){
		$params=array('uniacid'=>$_SESSION['uniacid'],'ispay'=>1);
		if($plugin_name){
			$params['plugin_name']=$plugin_name;
		}
		if($orderid){
			$params['id']=$orderid;
			$order=pdo_get('jy_weishop_order',$params,array('id','mid','paytime'));
			$msgdata['avatar']=pdo_getcolumn('core_members',array('id'=>$order['mid']),'avatar');
			$msgdata['nickname']=pdo_getcolumn('core_members',array('id'=>$order['mid']),'nickname');
			$msgdata['time']=time()-$order['paytime']+2;
			$goods=pdo_getall('jy_weishop_order_goods',$params=array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$orderid),array('id','goodsid'));
			foreach($goods as $g){
				cfc('jinyun_socket',$_SESSION['uniacid'])->send2room($msgdata,'goodsid'.$g['goodsid']);
			}
			cfc('jinyun_socket',$_SESSION['uniacid'])->send2room($msgdata,'index');
		}else{
			//看看60秒内是否有订单；
			$params['paytime >=']=time()-60;
			$order=pdo_get('jy_weishop_order',$params,array('id','mid','createtime'));
			if($order['id']){
				$msgdata['avatar']=pdo_getcolumn('core_members',array('id'=>$order['mid']),'avatar');
				$msgdata['nickname']=pdo_getcolumn('core_members',array('id'=>$order['mid']),'nickname');
				$msgdata['time']=time()-$order['paytime']+2;
				$goods=pdo_getall('jy_weishop_order_goods',$params=array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$orderid),array('id','goodsid'));
				foreach($goods as $g){
					cfc('jinyun_socket',$_SESSION['uniacid'])->send2room($msgdata,'goodsid'.$g['goodsid']);
				}
			}else{
				$xuniuser=pdo_count('core_members',array('uniacid'=>$_SESSION['uniacid'],'is_virtual'=>1),'id');
				$pindex = max(1, intval($post['page']));
				$psize = 1;
				$total='';
				$maxmember=pdo_getslice('core_members',array('uniacid'=>$_SESSION['uniacid'],'is_virtual'=>1),array($pindex,$psize),$total,array('id'),'','id desc');
				$minmember=pdo_getslice('core_members',array('uniacid'=>$_SESSION['uniacid'],'is_virtual'=>1),array($pindex,$psize),$total,array('id'),'','id asc');
				$id=rand($minmember[0]['id'],$maxmember[0]['id']);
				$msgdata['avatar']=pdo_getcolumn('core_members',array('id'=>$id),'avatar');
				$msgdata['nickname']=pdo_getcolumn('core_members',array('id'=>$id),'nickname');
				$msgdata['time']=rand(2,10);
				cfc('jinyun_socket',$_SESSION['uniacid'])->send2room($msgdata,'index');
			}
		}
		return true;
	}
	public function get_area_code($area){
		$address=$area['province'];
		if($area['city']){
			$address.=' '.$area['city'];
		}
		if($area['district']){
			$address.=' '.$area['district'];
		}
		if($area['street']){
			$address.=' '.$area['street'];
		}
		$area_code=pdo_getcolumn('core_area',array('address'=>$address),'code');
		return $area_code;
	}
	public function get_area_data($area){
		if($areaset['level']==1){
			$title=$pcd['province'];
			$levelpcd=array(
				'province'=>$pcd['province']
			);
		}elseif($areaset['level']==2){
			$title=$pcd['city'];
			$levelpcd=array(
				'province'=>$pcd['province'],
				'city'=>$pcd['city'],
			);
		}elseif($areaset['level']==4){
			$title=$pcd['district'];
			$levelpcd=array(
				'province'=>$pcd['province'],
				'city'=>$pcd['city'],
				'district'=>$pcd['district'],
				'street'=>$pcd['street'],
			);
		}else{
			$title=$pcd['street'];
			$levelpcd=array(
				'province'=>$pcd['province'],
				'city'=>$pcd['city'],
				'district'=>$pcd['district'],
				
			);
		}
		if(!$levelpcd){
			return false;
		}
		$address=$area['province'];
		if($area['city']){
			$address.=' '.$area['city'];
		}
		if($area['district']){
			$address.=' '.$area['district'];
		}
		if($area['street']){
			$address.=' '.$area['street'];
		}
		$area_code=pdo_getcolumn('core_area',array('address'=>$address),'code');
		if($_SESSION['uid']){
			$myarea_code=pdo_getcolumn('jy_weishop_member',array('mid'=>$_SESSION['uid']),'area_code');
			if(!$myarea_code !=$area_code){
				pdo_update('jy_weishop_member',array('area_code'=>$area_code),array('mid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid']));
			}
		}
		$data=array(
			'area_code'=>$area_code,
			'address'=>$address,
			'title'=>$title,
		);
		return $data;
	}
	public function get_wxappewm($url,$pid){//pid要有唯一性
		if(!$url || !$pid || !$_SESSION['wxapp_id']){
			return false;
		}
		$image=ROOT_AT.'images/jy_weishop/'.$_SESSION['uniacid'].'/'.$pid.'.jpg';
		if(!file_exists($image)){
			$wxapp=pdo_get('core_account_wxapp',array('id'=>$_SESSION['wxapp_id'],'uniacid'=>$_SESSION['uniacid']));
			$res=model('core/wxapp')->appcode($url,$wxapp['appid'],$wxapp['appsecret'],200);
			$path=ROOT_AT.'images/jy_weishop/'.$_SESSION['uniacid'];
			if(!file_exists($path)){
					mkdir($path,0700, true);
			}
			if($res){
				file_put_contents($path.'/'.$pid.'.jpg',$res);
			}
		}
		$ewm='images/jy_weishop/'.$_SESSION['uniacid'].'/'.$pid.'.jpg';
		return $ewm;
	}
	
}