<?php
namespace jy_weishop\order;
defined('BY_JYA') or exit('error');
/*
	找人代付
*/
class peerpay extends \plugin{
	/*
		检查代付订单
	*/
	public function get_peerpay($orderid,$money=null){
		if(!$orderid){
			exi('请先选择订单！','error');
		}
		$setting=$this->plugin_setting('peerpay');
		if(!$setting['open']){
			exi('系统暂不支持找人代付！','error');
		}
		$peerpay=$this->pdo_get('order_peerpay',array('orderid'=>$orderid));
		if(!$peerpay){
			exi('指定订单未设置代付或订单不存在！','error');
		}
		
		if($money!==null){
			if($peerpay['status']==1){
				exi('其他小伙伴已经代付完成！','error');
			}
			if(!$money){
				exi('请设置代付金额！','error');
			}
			if($peerpay['type']==1){
				if($money!=$peerpay['money']){
					exi('代付金额不合法！');
				}
			}else{
				//检查代付金额是否超出剩余需支付金额
				$pay_money=$this->pdo_getsum('order_peerpay_log',array('orderid'=>$orderid,'status'=>1),'money');
				if($pay_money==$peerpay['money']){
					exi('该订单已代付完成！','error');
				}
				if($money>$peerpay['money']-$pay_money){
					exi('代付金额超出订单剩余待支付金额！请调整！','error');
				}
				if($setting['pay_min'] && $money<$setting['pay_min'] && $money!=$peerpay['money']-$pay_money){
					exi('代付金额低于最低代付金额！请调整！','error');
				}
				if($setting['pay_max'] && $money>$setting['pay_max']){
					exi('代付金额超出单人最多代付金额！请调整！','error');
				}
			}
			
		}
		return $peerpay;
	}
	//执行代付成功动作
	public function ispay($orderid){
		$this->pdo_update('order_peerpay',array('status'=>1),array('orderid'=>$orderid));
		$params=array(
			'paytype'=>'peerpay',
			'transid'=>$this->pdo_getcolumn('order_peerpay',array('orderid'=>$orderid),'id'),
		);
		$this->model('order')->order_pay($orderid,$params);
		return true;
	}
}