<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 *员工管理
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'景点列表'),
	array('op'=>'edit','title'=>'添加景点'),	
);
if($_RQ['op']=='list'){
	$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	if(isset($_RQ['status'])){
		$params['status']=intval($_RQ['status']);
		$return['params']['status']=$_RQ['status'];
	}
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','uniacid','title','images','opentime','status','feature','ishot','destination_pcd','destination_address','createtime');
	$list=pdo_getslice('jy_tour_spot',$params,array($pindex,$psize),$total,$fields,'','id desc');
	if($list){
		foreach($list as &$item){
			$images=json_decode($item['images'],true);
			$item['thumb']=$images['0'];
			$opentime=json_decode($item['opentime'],true);
			$item['opentime']=$opentime['start'].'-'.$opentime['end'];
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'温馨提示：门票由多商户端后台添加！','data'=>'list','edit'=>true,'list'=>array(
			array('name'=>'title','title'=>'景点名称','type'=>'string'),
			array('name'=>'thumb','title'=>'景点封面','type'=>'image'),
			array('name'=>'opentime','title'=>'开始时间','type'=>'string'),
			array('name'=>'ishot','title'=>'是否热门','type'=>'switch','set'=>'set'),
			array('name'=>'status','title'=>'状态','type'=>'switch','set'=>'set'),
		)),
		'search'=>array(
			array('name'=>'title','width'=>15,'title'=>'景点名称','type'=>'string'),
			array('name'=>'status','width'=>15,'title'=>'状态','type'=>'select','options'=>'status_select'),
		)
	);
	$return['status_select']=array('0'=>array('id'=>'0','title'=>'下架'),'1'=>array('id'=>'1','title'=>'上架'));
	$return['htmls']=$htmls;
	exi($return);
}

if($_RQ['op']=='edit'){
	$return=array();
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_tour_spot',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['images']=json_decode($item['images'],true);
		$item['opentime']=json_decode($item['opentime'],true);
		$item['destination_pcd']=json_decode($item['destination_pcd'],true);
		
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回景点列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('name'=>'title','title'=>'景点名称','type'=>'string'),
					array('name'=>'images','title'=>'景点图片','type'=>'images'),
					array('name'=>'price','title'=>'基础价格','type'=>'string','help'=>'最终价格以门票的为准！'),
					array('name'=>'destination_pcd','title'=>'目的地','type'=>'pcd'),
					array('name'=>'destination_address','title'=>'详细地址','type'=>'string'),
					array('name'=>'opentime','title'=>'营业时间','type'=>'time_hour','help'=>''),
					array('name'=>'desc','title'=>'景点介绍','type'=>'richtext'),
					array('name'=>'ishot','title'=>'是否热门','type'=>'switch'),
					array('name'=>'status','title'=>'状态','type'=>'switch'),
			
				)
			),
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	if(empty($postdata['title'])){
		exi('请完善景点名称','error');
	}
	if(empty($postdata['images'])){
		exi('请完善景点图片','error');
	}
	if(empty($postdata['destination_pcd'])){
		exi('请完善景点目的地','error');
	}
	if(empty($postdata['destination_address'])){
		exi('请完善景点详细地址','error');
	}
	$data=array(
		'title'=>trim($postdata['title']),
		'images'=>ijson_encode($postdata['images']),
		'opentime'=>ijson_encode($postdata['opentime']),
		'price'=>intval($postdata['price']),
		'ishot'=>intval($postdata['ishot']),
		'desc'=>trim($postdata['desc']),
		'destination_address'=>trim($postdata['destination_address']),
		'province'=>trim($postdata['destination_pcd']['province']),
		'city'=>trim($postdata['destination_pcd']['city']),
		'district'=>trim($postdata['destination_pcd']['district']),
		'destination_pcd'=>ijson_encode($postdata['destination_pcd']),
		'status'=>intval($postdata['status']),
	);
	$id=intval($postdata['id']);
	if($id){
		pdo_update('jy_tour_spot',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('jy_tour_spot',$data);
	}
	exi('操作成功！','','list');
}
if($_RQ['op']=='del'){
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
	}else{
		$del=array();
	}
	if($_RQ['id']){
		$del[]=$_RQ['id'];
	}
	foreach($del as $id){
		$id=intval($id);
		if($id){
			pdo_delete('jy_tour_spot',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要编辑的景点！','error');
	}
	$post=get_postdata();
	if(isset($post['status'])){
		pdo_update('jy_tour_spot',array('status'=>intval($post['status'])),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	if(isset($post['ishot'])){
		pdo_update('jy_tour_spot',array('ishot'=>intval($post['ishot'])),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	exi('操作成功！');
}