<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 *门票管理
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'门票列表'),
	array('op'=>'edit','title'=>'添加门票'),	
);
if($_RQ['op']=='list'){
	$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	if(isset($_RQ['merchid'])){
		$params['merchid']=intval($_RQ['merchid']);
		$return['params']['merchid']=$_RQ['merchid'];
	}
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	if(isset($_RQ['status'])){
		$params['status']=intval($_RQ['status']);
		$return['params']['status']=$_RQ['status'];
	}
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','uniacid','merchid','spotid','title','is_type','types','status','createtime');
	$list=pdo_getslice('jy_tour_spot_ticket',$params,array($pindex,$psize),$total,$fields,'','id desc');
	if($list){
		foreach($list as &$item){
			$item['spot']=pdo_get('jy_tour_spot',array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['spotid']));
			$item['merchname']=pdo_getcolumn('jy_tour_merch',array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['merchid']),'merchname');
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('data'=>'list','edit'=>true,'list'=>array(
			array('name'=>'title','title'=>'门票名称','type'=>'string'),
			array('name'=>'merchname','title'=>'所属商户','type'=>'string'),
			array('name'=>'spot.title','title'=>'景点名称','type'=>'string'),
			array('name'=>'is_type','title'=>'票类型','type'=>'radio','options'=>'is_type'),
			array('name'=>'status','title'=>'状态','type'=>'switch','set'=>'set'),
		)),
		'search'=>array(
			array('name'=>'title','width'=>15,'title'=>'门票名称','type'=>'string'),
			array('name'=>'status','width'=>15,'title'=>'状态','type'=>'radio','options'=>'status'),
		)
	);
	$return['is_type']=array('关闭','开启');
	$return['htmls']=$htmls;
	exi($return);
}

if($_RQ['op']=='edit'){
	$return=array();
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_tour_spot_ticket',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['types']=json_decode($item['types'],true);
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回门票列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('name'=>'title','title'=>'门票名称','type'=>'string'),
					array('name'=>'spotid','title'=>'门票景点','type'=>'choose','action'=>'jy_tour/get_spot/','choose_title'=>'选择景点'),
					array('name'=>'is_type','title'=>'票类型','type'=>'radio','options'=>'is_type'),
					array(
							'type'=>'array',
							'name'=>'types',
							'add_tip'=>'添加一个票类型',
							'show'=>array('is_type'=>1),
								'list'=>array(
									array('type'=>'string','name'=>'title','title'=>'类型名称'),
									array('type'=>'string','name'=>'price1','title'=>'周一票价'),
									array('type'=>'string','name'=>'price2','title'=>'周二票价'),
									array('type'=>'string','name'=>'price3','title'=>'周三票价'),
									array('type'=>'string','name'=>'price4','title'=>'周四票价'),
									array('type'=>'string','name'=>'price5','title'=>'周五票价'),
									array('type'=>'string','name'=>'price6','title'=>'周六票价'),
									array('type'=>'string','name'=>'price','title'=>'周日票价'),
									array('type'=>'string','name'=>'num','title'=>'数量'),
									
								),
								'details'=>array(
									array('type'=>'string','name'=>'title','title'=>'类型名称','help'=>'例如:儿童票，成人票'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price1','title'=>'周一票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price2','title'=>'周二票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price3','title'=>'周三票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price4','title'=>'周四票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price5','title'=>'周五票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price6','title'=>'周六票价'),
									array('type'=>'unitstring','unit'=>'元','name'=>'price','title'=>'周日票价'),
									array('type'=>'string','name'=>'num','title'=>'数量'),
									
								)
						),
					array('name'=>'status','title'=>'状态','type'=>'radio','options'=>'status'),
				)
			),
		)
	);
	$return['is_type']=array('关闭','开启');
	$return['status']=array('待审核','运营中','审核不通过','暂停中');
	$return['htmls']=$htmls;
	//print_r($return['lev_name']);exit;
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	//exi($postdata['lev_name'],'error');exit;
	$data=array(
		'title'=>trim($postdata['title']),
		'types'=>ijson_encode($postdata['types']),
		'spotid'=>intval($postdata['spotid']),
		'is_type'=>intval($postdata['is_type']),
		'status'=>intval($postdata['status']),
		'merchid'=>intval($postdata['merchid']),
	);
	$id=intval($postdata['id']);
	if($id){
		pdo_update('jy_tour_spot_ticket',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('jy_tour_spot_ticket',$data);
	}
	exi('操作成功！','','list');
}
if($_RQ['op']=='del'){
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
	}else{
		$del=array();
	}
	if($_RQ['id']){
		$del[]=$_RQ['id'];
	}
	foreach($del as $id){
		$id=intval($id);
		if($id){
			pdo_delete('jy_tour_spot_ticket',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要编辑的门票！','error');
	}
	$post=get_postdata();
	if(isset($post['status'])){
		if($post['status']==1){
			pdo_update('jy_tour_spot_ticket',array('status'=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}else{
			pdo_update('jy_tour_spot_ticket',array('status'=>4),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('操作成功！');
}