<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 *路线管理
 $tabs=array(
	array('op'=>'wait','title'=>'待审核'),
	array('op'=>'success','title'=>'运营中'),	
	array('op'=>'fail','title'=>'审核不通过'),	
	array('op'=>'fail','title'=>'暂停中'),	
);
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'路线列表'),
	array('op'=>'edit','title'=>'添加线路'),
);
if($_RQ['op']=='list'){
	$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	$params['merchid']=$merchid;
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	if(isset($_RQ['status'])){
		$params['status']=intval($_RQ['status']);
		$return['params']['status']=$_RQ['status'];
	}
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','uniacid','merchid','ishot','title','images','feature','starttime','endtime','status','isshenhe','destination_pcd','destination_address','price','old_price','gotype_id','createtime');
	$list=pdo_getslice('jy_tour_way',$params,array($pindex,$psize),$total,$fields,'','id desc');
	if($list){
		foreach($list as &$item){
			$images=json_decode($item['images'],true);
			$item['thumb']=$images['0'];
			$destination_pcd=json_decode($item['destination_pcd'],true);
			$item['destination_pcd']=$destination_pcd['province'].$destination_pcd['city'].$destination_pcd['district'].$destination_pcd['street'];
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('data'=>'list','edit'=>true,'list'=>array(
			array('name'=>'title','title'=>'路线名称','type'=>'string'),
			array('name'=>'thumb','title'=>'路线封面','type'=>'image'),
			array('name'=>'starttime','title'=>'开始时间','type'=>'string'),
			array('name'=>'endtime','title'=>'结束时间','type'=>'string'),
			array('name'=>'old_price','title'=>'原价','type'=>'string'),
			array('name'=>'price','title'=>'价格','type'=>'string'),
			array('name'=>'destination_pcd','title'=>'目的地位置','type'=>'string'),
			array('name'=>'destination_address','title'=>'目的地具体地址','type'=>'string'),
			array('name'=>'gotype_id','title'=>'出行工具选择','type'=>'radio','options'=>'gotype_id'),
			//array('name'=>'isrecommend','title'=>'是否推荐','type'=>'switch','set'=>'set'),
			array('name'=>'status','title'=>'状态','type'=>'switch','set'=>'set'),
			array('name'=>'ishot','title'=>'热门','type'=>'switch','set'=>'set'),
		)),
		'search'=>array(
			array('name'=>'title','width'=>15,'title'=>'路线名称','type'=>'string'),
			array('name'=>'status','width'=>15,'title'=>'状态','type'=>'radio','options'=>'status'),
		)
	);
	$return['gotype_id']=array('0'=>'汽车','1'=>'大巴','2'=>'轮船','3'=>'飞机','4'=>'其他');
	$return['htmls']=$htmls;
	exi($return);
}

if($_RQ['op']=='edit'){
	$return=array();
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_tour_way',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['images']=json_decode($item['images'],true);
		$item['spotids']=json_decode($item['spotids'],true);
		$item['destination_pcd']=json_decode($item['destination_pcd'],true);
		$item['departure_pcd']=json_decode($item['departure_pcd'],true);
		//print_r($item['spotids']);exit;
		
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回路线列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('name'=>'title','title'=>'路线名称','type'=>'string'),
					array('name'=>'images','title'=>'路线图片','type'=>'images'),
					array('name'=>'spotids','title'=>'路线景点','type'=>'choose_many','action'=>'/get_spot/many/','choose_title'=>'选择景点'),
					array('name'=>'gotype_id','title'=>'出行工具','type'=>'select','help'=>'','options'=>'gotype_id'),
					array('name'=>'departure_pcd','title'=>'出发地','type'=>'pcd','help'=>''),
					array('name'=>'departure_address','title'=>'出发地具体地址','type'=>'string','help'=>''),
					array('name'=>'destination_pcd','title'=>'目的地','type'=>'pcd','help'=>''),
					array('name'=>'destination_address','title'=>'目的地具体地址','type'=>'string','help'=>''),
					array('name'=>'starttime','title'=>'出发时间','type'=>'time','help'=>''),
					array('name'=>'endtime','title'=>'返回时间','type'=>'time','help'=>''),
					array('name'=>'old_price','title'=>'原价','type'=>'string'),
					array('name'=>'price','title'=>'现价','type'=>'string'),
					array('name'=>'desc','title'=>'路线介绍','type'=>'text'),
					//array('name'=>'isrecommend','title'=>'是否推荐','type'=>'switch'),
					array('name'=>'status','title'=>'状态','type'=>'radio','options'=>'status'),
					array('name'=>'ishot','title'=>'状态','type'=>'switch'),
				)
			),
		)
	);
	$return['status']=array('待审核','运营中','审核不通过','暂停中');
	$return['gotype_id']=array(array('id'=>'0','title'=>'汽车'),array('id'=>'1','title'=>'大巴'),array('id'=>'2','title'=>'轮船'),array('id'=>'2','title'=>'轮船'),array('id'=>'3','title'=>'飞机'),array('id'=>'4','title'=>'其他'));
	$return['htmls']=$htmls;
	//print_r($return['lev_name']);exit;
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	if(empty($postdata['title'])){
		exi('请完善路线名称','error');
	}
	if(empty($postdata['images'])){
		exi('请完善路线图片','error');
	}
	if(empty($postdata['departure_pcd'])){
		exi('请完善出发地','error');
	}
	if(empty($postdata['departure_address'])){
		exi('请完善出发地详细地址','error');
	}
	if(empty($postdata['destination_pcd'])){
		exi('请完善目的地','error');
	}
	if(empty($postdata['destination_address'])){
		exi('请完善目的地详细地址','error');
	}
	if(empty($postdata['starttime'])){
		exi('请完善出发时间','error');
	}
	if(empty($postdata['endtime'])){
		exi('请完善返回时间','error');
	}
	$data=array(
		'title'=>trim($postdata['title']),
		'images'=>ijson_encode($postdata['images']),
		'starttime'=>trim($postdata['starttime']),
		'endtime'=>trim($postdata['endtime']),
		'spotids'=>ijson_encode($postdata['spotids']),
		'departure_pcd'=>ijson_encode($postdata['departure_pcd']),
		'departure_address'=>trim($postdata['departure_address']),
		'destination_pcd'=>ijson_encode($postdata['destination_pcd']),
		'destination_address'=>trim($postdata['destination_address']),
		'desc'=>trim($postdata['desc']),
		'status'=>intval($postdata['status']),
		'old_price'=>intval($postdata['old_price']),
		'price'=>intval($postdata['price']),
		'gotype_id'=>intval($postdata['gotype_id']),
		'ishot'=>intval($postdata['ishot']),
	);
	$id=intval($postdata['id']);
	if($id){
		pdo_update('jy_tour_way',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('jy_tour_way',$data);
	}
	exi('操作成功！','','list');
}
if($_RQ['op']=='del'){
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
	}else{
		$del=array();
	}
	if($_RQ['id']){
		$del[]=$_RQ['id'];
	}
	foreach($del as $id){
		$id=intval($id);
		if($id){
			pdo_delete('jy_tour_way',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要编辑的路线！','error');
	}
	$post=get_postdata();
	if(isset($post['status'])){
		if($post['status']==1){
			pdo_update('jy_tour_way',array('status'=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}else{
			pdo_update('jy_tour_way',array('status'=>4),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	if(isset($post['ishot'])){
		if($post['ishot']==1){
			pdo_update('jy_tour_way',array('ishot'=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}else{
			pdo_update('jy_tour_way',array('ishot'=>0),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('操作成功！');
}