<?php

namespace Addons\Draw\Controller;

use Think\ManageBaseController;

class GamesController extends ManageBaseController {
	function _initialize() {
		parent::_initialize ();
		$controller = strtolower ( CONTROLLER_NAME );
		$res ['title'] = '抽奖游戏';
		$res ['url'] = addons_url ( 'Draw://Games/lists',$this->get_param );
		$res ['class'] = $controller == 'games' ? 'current' : '';
		$nav [] = $res;

		$res ['title'] = '奖品库管理';
		$res ['url'] = addons_url ( 'Draw://Award/lists' ,$this->get_param);
		$res ['class'] = $controller == 'award' ? 'current' : '';
		$nav [] = $res;

		$res ['title'] = '中奖人列表';
		$res ['url'] = addons_url ( 'Draw://LuckyFollow/games_lucky_lists',$this->get_param );
		$res ['class'] = $controller == 'luckyfollow' ? 'current' : '';
		$nav [] = $res;

		$this->assign ( 'nav', $nav );
	}
	function lists() {
	    $isAjax = I ( 'isAjax' );
	    $isRadio = I ( 'isRadio' );
		$this->assign ( 'search_button', false );
		$this->assign ( 'del_button', false );
		$this->assign ( 'check_all', false );
		$model = $this->getModel ( 'lottery_games' );
		$list_data = $this->_get_model_list ( $model, 0, 'id desc', true );
// 		判断该活动是否已经设置投票调查
		$dao = D ( 'Addons://Draw/Games' );

		foreach ( $list_data ['list_data'] as &$vo ) {
		    if ($vo['status']=='开启'){
		        if (strtotime($vo ['start_time']) > NOW_TIME) {
		            $vo ['status'] = '未开始';
		        } elseif (strtotime($vo ['end_time']) < NOW_TIME) {
		            $vo ['status'] = '已结束';
		        } else {
		            $vo ['status'] = '进行中';
		        }
		    }
		    $vo['attend_num']=$dao->getAttendNum($vo['id']);
		    $winUrl=addons_url("Draw://LuckyFollow/games_lucky_lists",array('games_id'=>$vo['id']));
            $vo['winners_list']="<a href='".$winUrl."' >中奖人列表</a>"	   ;
		}
		if ($isAjax) {
		    $this->assign('isRadio',$isRadio);
		    $this->assign ( $list_data );
		    $this->display ( 'ajax_lists_data' );
		} else {
		    $this->assign ( $list_data );
		    $this->display ();
		}
	}
	function edit() {
		$model = $this->getModel ( 'lottery_games' );
		$id = I ( 'id' );

		// 获取数据
		$data = M ( get_table_name ( $model ['id'] ) )->find ( $id );
		$data || $this->error( '400206:数据不存在！' );
		if (IS_POST) {
			//$this->checkTime ( strtotime ( $_POST ['start_time'] ), strtotime ( $_POST ['end_time'] ), $id );
			$this->checkAward($_POST);
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
			$res = false;
			$Model->create () && $res=$Model->save ();
			if ($res !== false) {
			    $this->_add_award($id, $_POST);
			    $this->_saveKeyword ( $model, $id );
				// 清空缓存
				method_exists ( $Model, 'clear' ) && $Model->clear ( $id, 'edit' );
				D ( 'Games' )->getInfo ( $id, true );
				D('Addons://Draw/LotteryGamesAwardLink')->getGamesAwardlists($id,true);
				$this->success ( '保存' . $model ['title'] . '成功！', U ( 'lists?model=' . $model ['name'], $this->get_param ) );
		    }else {
				$this->error( '400207:'. $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			$awardList = D ( 'Addons://Draw/LotteryGamesAwardLink' )->getGamesAwardlists ( $id, true );
			// dump($awardList);exit;
			$this->assign ( 'award_list', $awardList );
			// var_dump($awardList);
			$this->assign ( 'fields', $fields );
			$this->assign ( 'data', $data );
			//var_dump($data);

			$this->display ();
		}
	}
	function add() {
		$where['token'] =get_token();
		$res =M('sport_award')->where($where)->select();
		$this->assign('award',$res);
		$model = $this->getModel ( 'lottery_games' );
		if (IS_POST) {
			//$this->checkTime ( strtotime ( $_POST ['start_time'] ), strtotime ( $_POST ['end_time'] ) );
			$this->checkAward($_POST);
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
// 			$this->_add_award($id, $_POST);
			if ($Model->create () && $id = $Model->add ()) {
			    $this->_add_award($id, $_POST);
				$this->_saveKeyword ( $model, $id );
				// 清空缓存
				method_exists ( $Model, 'clear' ) && $Model->clear ( $id, 'add' );
			    $this->success ( '添加' . $model ['title'] . '成功！', U ( 'lists?model=' . $model ['name'], $this->get_param ) );
			} else {
				$this->error( '400208:'. $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			$this->assign ( 'fields', $fields );

			$this->display ();
		}
	}
	function del(){
		$this->model =$this->getModel('lottery_games');
		parent::common_del($this->model);
	}
	// 判断时间是否重叠
	function checkTime($startTime, $endTime, $id = 0) {
// 	    dump($_POST);die;
		if ($endTime < $startTime) {
			$this->error( '400209:结束时间不能大于开始时间！' );
			exit ();
		}
// 		$timeData = M ( 'lottery_games' )->field ( 'id,start_time,end_time' )->select ();
// // 		dump($id);
// 		if (! empty ( $timeData )) {
// 			foreach ( $timeData as $t ) {
// 				if ($t ['id'] != $id) {
// // 					dump($startTime);
// // 					dump($t);
// 					if(!($endTime<$t['start_time']||$startTime>$t['end_time'])){
// 						$this->error( '400210:该时间段已设有其它活动！' );
// 						exit ();
// 					}
// 				}
// 			}
// 		}
	}
	function _add_award($gameId,$postData){
	    $awardIdArr=$postData['award_id'];

	    $gradeArr=$postData['grade'];
	    $numArr=$postData['num'];
	    $maxCountArr=$postData['max_count'];
	    $awardDao=D ( 'Addons://Draw/Award' );
	    $map['games_id']=$gameId;
	    $map['token']= get_token();

	    $lotteryData=M('lottery_games_award_link')->where($map)->getFields('award_id,id,grade,num,max_count');
	    foreach ($awardIdArr as $awardId){

	        if ($lotteryData[$awardId]){
	            //保存
	            $saveData['grade']=$gradeArr[$awardId];
	            $saveData['num']=$numArr[$awardId];
	            $saveData['max_count']=$maxCountArr[$awardId];
	            $map['award_id']=$awardId;
	            $res=M('lottery_games_award_link')->where($map)->save($saveData);
	        }else{
	            //添加
	            $addData['games_id']=$gameId;
	            $addData['award_id']=$awardId;
	            $addData['token']=$map['token'];
	            $addData['grade']=$gradeArr[$awardId];
	            $addData['num']=$numArr[$awardId];
	            $addData['max_count']=$maxCountArr[$awardId];
	            $addDatas[]=$addData;
	        }
	    }
	    if (!empty($addDatas)){
	        $res=M('lottery_games_award_link')->addAll($addDatas);
	    }

	    foreach ($lotteryData as $key=>$v){
	        if (!in_array($key, $awardIdArr)){
	            $ids[]=$v['id'];
	        }
	    }
	    if (!empty($ids)){
	        $map1['id']=array('in',$ids);
	        $res=M('lottery_games_award_link')->where($map1)->delete();
	    }
	    if ($res){
	        $awardList=D('Addons://Draw/LotteryGamesAwardLink')->getGamesAwardlists($gameId,true);
	    }
	    return $res;

	}
	/* 预览 */
	function preview(){
	    $id = I('games_id',0,intval);
	    $url = addons_url('Draw://Wap/index',array('games_id'=>$id));
	    $this->assign('url', $url);
	    $this->display( 'Home@Addons/preview' );
	}
	function checkAward($postData){
		if(!I('post.start_time')){
			$this->error( '400211:请选择开始时间');
				}
		if(!I('post.end_time')){
			$this->error( '400212:请选择结束时间');
		}
		if(I('post.start_time')>=I('post.end_time')){
			$this->error( '400213:开始时间不能大于或等于结束时间');
		}
		if(empty($postData['award_id'])){
			$this->error( '400214:请添加奖品');
		}
		if(I('post.day_attend_limit')>I('post.attend_limit') && I('post.attend_limit')!=='0'){
			$this->error( '400215:每人每天抽奖次数不能大于总共的抽奖次数');
		}
		$gradeArr=$postData['grade'];
		$numArr=$postData['num'];
		$maxCountArr=$postData['max_count'];
		$awardDao=D ( 'Addons://Draw/Award' );
		$awardIdArr=$postData['award_id'];
		foreach ($awardIdArr as $awardId){
			$award=$awardDao->getInfo($awardId);
			if (!$gradeArr[$awardId]){
				$this->error( '400216:'. $award['name'].' 的等级名称不能为空');
			}
			if (!$numArr[$awardId]){
				$this->error( '400217:'. $award['name'].' 的奖品数量不能为空');
			}
			if (!$maxCountArr[$awardId]){
				$this->error( '400218:'. $award['name'].' 的最多抽奖数必须大于1');
			}
			if ($numArr[$awardId]<0){
				$this->error( '400219:'. $award['name'].' 的奖品数量不能小于0');
			}
			if ($maxCountArr[$awardId]<$numArr[$awardId]){
				$this->error( '400220:'. $award['name'].' 的最多抽奖数不能小于奖品数量');
			}
	}
	}
}
