<?php

namespace Addons\Vote\Controller;

use Think\ManageBaseController;

class ShopVoteController extends ManageBaseController {
	protected $model;
	public function __construct() {
		parent::__construct ();
		
		$this->model = $this->getModel ( 'shop_vote' );
		$this->model || $this->error ( '400430:模型不存在！' );
	}
	/**
	 * 显示指定模型列表数据
	 */
	public function lists() {
		$isAjax = I ( 'isAjax' );
		$isRadio = I ( 'isRadio' );
		$param ['mdm'] = $_GET ['mdm'];
		$res ['title'] = '投票活动';
		$res ['url'] = addons_url ( 'Vote://ShopVote/lists', $param );
		$res ['class'] = CONTROLLER_NAME == 'ShopVote' ? 'current' : '';
		$nav [] = $res;
		
		$this->assign ( 'nav', $nav );
		$list_data = $this->_get_model_list ( $this->model );
		if ($isAjax) {
			$this->assign ( 'isRadio', $isRadio );
			$this->assign ( $list_data );
			$this->display ( 'ajax_lists_data' );
		} else {
			$this->assign ( $list_data );
			$this->display ();
		}
	}
	public function del() {
		parent::common_del ( $this->model );
	}
	public function edit() {
		// 获取模型信息
		$id = I ( 'id', 0, 'intval' );
		
		if (IS_POST) {
			$this->checkPostData ();
			$Model = D ( parse_name ( get_table_name ( $this->model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $this->model ['id'] );
			if ($Model->create () && $Model->save ()) {
				D ( 'Addons://Vote/ShopVote' )->getInfo ( $id, true );
				$this->success ( '保存' . $this->model ['title'] . '成功！', U ( 'lists?model=' . $this->model ['name'], $this->get_param ) );
			} else {
				$this->error ( '400431:' . $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $this->model ['id'] );
			// 获取数据
			$data = M ( get_table_name ( $this->model ['id'] ) )->find ( $id );
			$data || $this->error ( '400432:数据不存在！' );
			
			$token = get_token ();
			if (isset ( $data ['token'] ) && $token != $data ['token'] && defined ( 'ADDON_PUBLIC_PATH' )) {
				$this->error ( '400433:非法访问！' );
			}
			$this->assign ( 'fields', $fields );
			$this->assign ( 'data', $data );
			$this->display ();
		}
	}
	function checkPostData() {
		if (strtotime ( I ( 'post.start_time' ) ) >= strtotime ( I ( 'post.end_time' ) )) {
			$this->error ( '400434:开始时间不能大于或等于结束时间' );
		}
		if (I ( 'post.multi_num' ) < 0) {
			$this->error ( '400435:多选限制数不能小于0' );
		}
		if (I ( 'post.limit_num' ) < 0) {
			$this->error ( '400436:每人可投票次数不能小于0' );
		}
	}
	public function add() {
		if (IS_POST) {
			$this->checkPostData ();
			$Model = D ( parse_name ( get_table_name ( $this->model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $this->model ['id'] );
			if ($Model->create () && $vote_id = $Model->add ()) {
				$this->success ( '添加' . $this->model ['title'] . '成功！', U ( 'lists?model=' . $this->model ['name'], $this->get_param ) );
			} else {
				$this->error ( '400437:' . $Model->getError () );
			}
		} else {
			$vote_fields = get_model_attribute ( $this->model ['id'] );
			$this->assign ( 'fields', $vote_fields );
			$this->display ();
		}
	}
	
	/**
	 * 投票选项列表
	 */
	function option_lists() {
		$param1 ['mdm'] = $param ['mdm'] = $_GET ['mdm'];
		$map ['vote_id'] = $param ['vote_id'] = I ( 'vote_id' );
		if (empty ( $param ['vote_id'] )) {
			$this->error ( '400438:获取不到投票活动' );
		}
		$model = $this->getModel ( 'shop_vote_option' );
		$addUrl = addons_url ( 'Vote://ShopVote/option_add', $param );
		$this->assign ( 'add_url', $addUrl );
		$search_url = addons_url ( 'Vote://ShopVote/option_lists', $param );
		$this->assign ( 'search_url', $search_url );
		
		$res ['title'] = '投票活动';
		$res ['url'] = addons_url ( 'Vote://ShopVote/lists', $param1 );
		$res ['class'] = ACTION_NAME == 'lists' ? 'current' : '';
		$nav [] = $res;
		
		$res ['title'] = '投票选项';
		$res ['url'] = addons_url ( 'Vote://ShopVote/option_lists', $param );
		$res ['class'] = ACTION_NAME == 'option_lists' ? 'current' : '';
		$nav [] = $res;
		
		$this->assign ( 'nav', $nav );
		
		$map ['token'] = get_token ();
		session ( 'common_condition', $map );
		
		$list_data = $this->_get_model_list ( $model );
		$this->assign ( $list_data );
		$this->display ( 'lists' );
	}
	function option_add() {
		$param1 ['mdm'] = $param ['mdm'] = $_GET ['mdm'];
		$param ['vote_id'] = I ( 'vote_id' );
		$model = $this->getModel ( 'shop_vote_option' );
		$postUrl = addons_url ( 'Vote://ShopVote/option_add', $param );
		$this->assign ( 'post_url', $postUrl );
		
		$res ['title'] = '投票活动';
		$res ['url'] = addons_url ( 'Vote://ShopVote/lists', $param1 );
		$res ['class'] = ACTION_NAME == 'lists' ? 'current' : '';
		$nav [] = $res;
		
		$res ['title'] = '投票选项';
		$res ['url'] = addons_url ( 'Vote://ShopVote/option_lists', $param );
		$res ['class'] = ACTION_NAME == 'option_lists' ? 'current' : '';
		$nav [] = $res;
		
		$res ['title'] = '添加选项';
		// $res['url']=addons_url('Vote://ShopVote/option_lists',$param);
		$res ['class'] = ACTION_NAME == 'option_add' ? 'current' : '';
		$nav [] = $res;
		
		$this->assign ( 'nav', $nav );
		if (IS_POST) {
// 			$num = D ( 'Addons://Vote/ShopVoteOption' )->getNumber ( $_POST ['vote_id'] );
// 			$_POST ['number'] = $num;
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
			if ($Model->create () && $vote_id = $Model->add ()) {
				D ( 'Addons://Vote/ShopVoteOption' )->getOptions ( $_POST ['vote_id'], true );
				$this->success ( '添加' . $model ['title'] . '成功！', U ( 'option_lists?model=' . $model ['name'] . '&vote_id=' . $_POST ['vote_id'] . '&mdm=' . $_GET ['mdm'] ) );
			} else {
				$this->error ( '400439:' . $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			$this->assign ( 'fields', $fields );
			$this->display ( 'add' );
		}
	}
	function option_edit() {
		$model = $this->getModel ( 'shop_vote_option' );
		$param ['mdm'] = $_GET ['mdm'];
		
		$res ['title'] = '投票活动';
		$res ['url'] = addons_url ( 'Vote://ShopVote/lists', $param );
		$res ['class'] = ACTION_NAME == 'lists' ? 'current' : '';
		$nav [] = $res;
		
		$param ['vote_id'] = I ( 'vote_id' );
		$res ['title'] = '投票选项';
		$res ['url'] = addons_url ( 'Vote://ShopVote/option_lists', $param );
		$res ['class'] = ACTION_NAME == 'option_lists' ? 'current' : '';
		$nav [] = $res;
		
		$res ['title'] = '编辑选项';
		$res ['url'] = addons_url ( 'Vote://ShopVote/option_edit', $param );
		$res ['class'] = ACTION_NAME == 'option_edit' ? 'current' : '';
		$nav [] = $res;
		
		$this->assign ( 'nav', $nav );
		
		// 获取模型信息
		$id = I ( 'id', 0, 'intval' );
		$postUrl = addons_url ( 'Vote://ShopVote/option_edit', $param );
		$this->assign ( 'post_url', $postUrl );
		if (IS_POST) {
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
			if ($Model->create () && $Model->save ()) {
				D ( 'Addons://Vote/ShopVoteOption' )->getInfo ( $id, true );
				D ( 'Addons://Vote/ShopVoteOption' )->getOptions ( $_POST ['vote_id'], true );
				$this->success ( '保存' . $model ['title'] . '成功！', U ( 'option_lists?model=' . $model ['name'] . '&vote_id=' . $_POST ['vote_id'] . '&mdm=' . $_GET ['mdm'] ) );
			} else {
				$this->error ( '400440:' . $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			// 获取数据
			$data = M ( get_table_name ( $model ['id'] ) )->find ( $id );
			$data || $this->error ( '400441:数据不存在！' );
			
			$token = get_token ();
			if (isset ( $data ['token'] ) && $token != $data ['token'] && defined ( 'ADDON_PUBLIC_PATH' )) {
				$this->error ( '400442:非法访问！' );
			}
			$this->assign ( 'fields', $fields );
			$this->assign ( 'data', $data );
			$this->display ( 'edit' );
		}
	}
	public function option_del() {
		$model = $this->getModel ( 'shop_vote_option' );
		parent::common_del ( $model );
	}
	// 显示投票记录
	function show_log() {
		$model = $this->getModel ( 'shop_vote_log' );
		$param1 ['mdm'] = $param ['mdm'] = $_GET ['mdm'];
		$vote_id = I ( 'vote_id' );
		$vote_id && $param ['vote_id'] = $map ['vote_id'] = $vote_id;
		$opt_id = I ( 'option_id' );
		$opt_id && $param ['option_id'] = $map ['option_id'] = $opt_id;
		$map ['token'] = get_token ();
		
		$search_url = addons_url ( 'Vote://ShopVote/show_log', $param );
		$this->assign ( 'search_url', $search_url );
		
		$res ['title'] = '投票活动';
		$res ['url'] = addons_url ( 'Vote://ShopVote/lists', $param1 );
		$res ['class'] = ACTION_NAME == 'lists' ? 'current' : '';
		$nav [] = $res;
		
		$res ['title'] = '投票记录';
		$res ['url'] = addons_url ( 'Vote://ShopVote/show_log', $param );
		$res ['class'] = ACTION_NAME == 'show_log' ? 'current' : '';
		$nav [] = $res;
		
		$this->assign ( 'nav', $nav );
		$this->assign ( 'add_button', false );
		$this->assign ( 'del_button', false );
		$this->assign ( 'check_all', false );
		$btn ['url'] = U ( 'option_lists', $param );
		$btn ['title'] = '返回';
		$returnbtn [] = $btn;
		$this->assign ( 'top_more_button', $returnbtn );
		
		$nickname = I ( 'truename' );
		if ($nickname) {
			$uidstr = D ( 'Common/User' )->searchUser ( $nickname );
			if ($uidstr) {
				$map ['uid'] = array (
						'in',
						$uidstr 
				);
			} else {
				$map ['uid'] = 0;
			}
		}
		$searchTitle = I ( 'title' );
		if ($searchTitle) {
			$omap ['truename'] = array (
					'like',
					'%' . htmlspecialchars ( $searchTitle ) . '%' 
			);
			$omap ['vote_id'] = $vote_id;
			$omap ['token'] = get_token ();
			$opids = M ( 'shop_vote_option' )->where ( $omap )->getFields ( 'id' );
			if (! empty ( $opids )) {
				$map ['option_id'] = array (
						'in',
						$opids 
				);
			} else {
				$map ['option_id'] = 0;
			}
		}
		
		session ( 'common_condition', $map );
		// $shopVote=D('Addons://Vote/ShopVote')->getInfo($vote_id);
		
		$list_data = $this->_get_model_list ( $model );
		foreach ( $list_data ['list_data'] as &$vo ) {
			// $vo['vote_id']=$shopVote['title'];
			$user = get_userinfo ( $vo ['uid'] );
			$vo ['vote_id'] = url_img_html ( $user ['headimgurl'] );
			$vo ['uid'] = $user ['nickname'];
			$shopOption = D ( 'Addons://Vote/ShopVoteOption' )->getInfo ( $vo ['option_id'] );
			$vo ['option_id'] = $shopOption ['truename'];
		}
		$this->assign ( 'placeholder', '请输入投票选项' );
		$this->assign ( $list_data );
		$this->display ( 'lists' );
	}
	
	// 统计各选项的投票次数
	function showCount() {
		$vote_id = I ( 'id' );
		
		$nav [0] ['title'] = "投票列表";
		$nav [0] ['class'] = "";
		$nav [0] ['url'] = U ( "lists", $this->get_param );
		$nav [1] ['title'] = "投票记录";
		$nav [1] ['class'] = "";
		$nav [1] ['url'] = addons_url ( 'Vote://Vote/showLog?id=' . $vote_id, $this->get_param );
		$nav [2] ['title'] = "选项票数";
		$nav [2] ['class'] = "current";
		$this->assign ( 'nav', $nav );
		
		$this->assign ( 'add_button', false );
		$this->assign ( 'del_button', false );
		$this->assign ( 'check_all', false );
		$this->assign ( 'search_button', false );
		
		// 将缓存的数据，写入数据库
		D ( 'VoteOption' )->updateOptCount ( $vote_id, null );
		
		$page = I ( 'p', 1, 'intval' );
		$model = $this->option;
		
		$list_data = $this->_list_grid ( $model );
		$fields = $list_data ['fields'];
		$grids = $list_data ['list_grids'];
		// 查询条件
		$map ['vote_id'] = $vote_id;
		// $map['token']=get_token();
		session ( 'common_condition', $map );
		// $map = $this->_search_map ( $model, $fields );
		
		$row = empty ( $model ['list_row'] ) ? 20 : $model ['list_row'];
		empty ( $fields ) || in_array ( 'id', $fields ) || array_push ( $fields, 'id' );
		$name = parse_name ( get_table_name ( $model ['id'] ), true );
		$data = M ( $name )->field ( empty ( $fields ) ? true : $fields )->where ( $map )->order ( 'id DESC' )->page ( $page, $row )->select ();
		
		$dataTable = D ( 'Common/Model' )->getFileInfo ( $model );
		$data = $this->parseData ( $data, $dataTable->fields, $dataTable->list_grid, $dataTable->config );
		
		$count = M ( $name )->where ( $map )->count ();
		$list_data ['list_data'] = $data;
		// 分页
		if ($count > $row) {
			$page = new \Think\Page ( $count, $row );
			$page->setConfig ( 'theme', '%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%' );
			$list_data ['_page'] = $page->show ();
		}
		$this->assign ( $list_data );
		// dump($list_data);
		$this->display ( 'Home@Addons/lists' );
	}
	/* 预览 */
	function preview() {
		$id = I ( 'vote_id', 0, intval );
		$url = addons_url ( 'Vote://Wap/index', array (
				'vote_id' => $id 
		) );
		$this->assign ( 'url', $url );
		$this->display ( 'Home@Addons/preview' );
	}

/**
 * **************************微信上的操作功能************************************
 */
}
