<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 朱亚杰 <zhuyajie@topthink.net>
// +----------------------------------------------------------------------
namespace Home\Controller;

/**
 * 公众号管理控制器
 *
 * @author 凡星
 */
class AppsLinkController extends HomeController {
	var $table = 'apps_link';
	function __construct() {
		$this->need_appinfo = false;
		parent::__construct ();
	}
	function lists() {
		$nav [0] ['title'] = '返回';
		$nav [0] ['url'] = U ( 'Home/Apps/lists', array (
				'from' => 50 
		) );
		$nav [0] ['class'] = 'current';
		$this->assign ( 'nav', $nav );
		$addon_list = D ( 'Home/Addons' )->getWeixinList ( true );
		foreach ( $addon_list as $v ) {
			$all_ids [] = $v ['id'];
			$nameArr [$v ['id']] = $v ['title'];
		}
		
		$model = $this->getModel ( $this->table );
		
		$map ['mp_id'] = intval ( $_GET ['mp_id'] );
		if (! empty ( $_GET ['title'] )) {
			$title = I ( 'get.title' );
			$where = "nickname like '%$title%'";
			$uids = M ( 'user' )->where ( $where )->field ( 'uid' )->select ();
			$uids = getSubByKey ( $uids, 'uid' );
			$uids [] = 0;
			$map ['uid'] = array (
					'in',
					$uids 
			);
		}
		$map ['is_creator'] = 0;
		session ( 'common_condition', $map );
		
		$list_data = $this->_get_model_list ( $model );
		foreach ( $list_data ['list_data'] as &$vo ) {
			$vo ['addon_status'] = explode ( ',', $vo ['addon_status'] );
			$vo ['addon_status'] = array_diff ( ( array ) $all_ids, ( array ) $vo ['addon_status'] );
			$vo ['addon_status'] = $this->_idToName ( $vo ['addon_status'], $nameArr );
		}
		
		$this->assign ( $list_data );
		// dump($list_data);
		
		$this->assign ( 'add_url', U ( 'add?model=' . $model ['id'] . '&mp_id=' . $map ['mp_id'] ) );
		$this->assign ( 'search_url', U ( 'lists?model=' . $model ['id'] . '&mp_id=' . $map ['mp_id'] ) );
		// $this->assign ( 'search_button', false );
		
		$this->display ( 'Addons:lists' );
	}
	// 通过插件ID转换成名字
	function _idToName($ids, $list) {
		foreach ( $ids as $id ) {
			$res [] = $list [$id];
		}
		return implode ( '，  ', $res );
	}
	public function del($ids = null) {
		$model = $this->getModel ( $this->table );
		
		! empty ( $ids ) || $ids = I ( 'id' );
		! empty ( $ids ) || $ids = array_unique ( ( array ) I ( 'ids', 0 ) );
		! empty ( $ids ) || $this->error ( '110029:请选择要操作的数据!' );
		
		$Model = M ( get_table_name ( $model ['id'] ) );
		$map ['id'] = array (
				'in',
				$ids 
		);
		
		if ($Model->where ( $map )->delete ()) {
			$this->success ( '删除成功' );
		} else {
			$this->error ( '110030:删除失败！' );
		}
	}
	public function edit($id = 0) {
		$model = $this->getModel ( $this->table );
		$id || $id = I ( 'id' );
		
		if (IS_POST) {
			$addon_list = D ( 'Common/AddonStatus' )->getPublicAddons ( $_POST ['mp_id'] );
			foreach ( $addon_list as $v ) {
				$all_ids [] = $v ['id'];
			}
			$_POST ['addon_status'] = array_diff ( ( array ) $all_ids, ( array ) $_POST ['addon_status'] );
			
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
			if ($Model->create () && $Model->save ()) {
				$this->success ( '保存' . $model ['title'] . '成功！', U ( 'lists?model=' . $model ['name'] . '&mp_id=' . $_POST ['mp_id'] ) );
			} else {
				$this->error ( '110031:' . $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			$this->_deal_addon ( $fields ['addon_status'], $_POST ['mp_id'] );
			// 获取数据
			$data = M ( get_table_name ( $model ['id'] ) )->find ( $id );
			$data || $this->error ( '110032:数据不存在！' );
			// dump ( $data );
			// dump ( $fields ['addon_status'] );
			$data ['addon_status'] = explode ( ',', $data ['addon_status'] );
			$data ['addon_status'] = array_diff ( ( array ) $fields ['addon_status'] ['value'], ( array ) $data ['addon_status'] );
			// dump ( $data ['addon_status'] );
			$this->assign ( 'fields', $fields );
			$this->assign ( 'data', $data );
			
			$this->display ( 'Addons:edit' );
		}
	}
	public function add() {
		$model = $this->getModel ( $this->table );
		if (IS_POST) {
			$addon_list = D ( 'Common/AddonStatus' )->getPublicAddons ( $_POST ['mp_id'] );
			foreach ( $addon_list as $v ) {
				$all_ids [] = $v ['id'];
			}
			$_POST ['addon_status'] = array_diff ( ( array ) $all_ids, ( array ) $_POST ['addon_status'] );
			
			$Model = D ( parse_name ( get_table_name ( $model ['id'] ), 1 ) );
			// 获取模型的字段信息
			$Model = $this->checkAttr ( $Model, $model ['id'] );
			if ($Model->create () && $id = $Model->add ()) {
				$this->success ( '添加' . $model ['title'] . '成功！', U ( 'lists?model=' . $model ['name'] . '&mp_id=' . $_POST ['mp_id'] ) );
			} else {
				$this->error ( '110033:' . $Model->getError () );
			}
		} else {
			$fields = get_model_attribute ( $model ['id'] );
			$this->_deal_addon ( $fields ['addon_status'], $_POST ['mp_id'] );
			
			$this->assign ( 'fields', $fields );
			$this->meta_title = '新增' . $model ['title'];
			
			$this->display ( 'Addons:add' );
		}
	}
	function _deal_addon(&$info, $mp_id) {
		$addon_list = D ( 'Common/AddonStatus' )->getPublicAddons ( $mp_id );
		
		foreach ( $addon_list as $vo ) {
			$extra .= $vo ['id'] . ':' . $vo ['title'] . "\n";
			$value [] = $vo ['id'];
		}
		$info ['extra'] = $extra;
		$info ['value'] = $value;
	}
}