<?php
/**
 * 获取已上传的文件列表
 * User: widuu
 * Date: 5/4/2015
 * Time: 上午8:14
 */

include 'Qiniu_List.php';
/* 判断类型 */
switch ($_GET['action']) {
    /* 列出文件 */
    case 'listfile':
        $allowFiles = $CONFIG['fileManagerAllowFiles'];
        $listSize = $CONFIG['fileManagerListSize'];
        $path = $CONFIG['fileManagerListPath'];
        break;
    /* 列出图片 */
    case 'listimage':
    default:
        $allowFiles = $CONFIG['imageManagerAllowFiles'];
        $listSize = $CONFIG['imageManagerListSize'];
        $path = $CONFIG['imageManagerListPath'];
}
$allowFiles = substr(str_replace(".", "|", join("", $allowFiles)), 1);

//var_dump($allowFiles);
/* 获取参数 */

$size = isset($_GET['size']) ? htmlspecialchars($_GET['size']) : $listSize;
$start = isset($_GET['start']) ? htmlspecialchars($_GET['start']) : 0;
$end = $start + $size;

//演示方法
$Qiniu_List = Qiniu_List::getInstance();
$Qiniu_List -> getUrl('','',1000);

$files = $Qiniu_List -> listFiles();
$marker = $files['marker'];


if (!count($files['items'])) {
    return json_encode(array(
        "state" => "no match file",
        "list" => array(),
        "start" => $start,
        "total" => count($files)
    ));
}

/* 获取指定范围的列表 */
$len = count($files['items']);
for ($i = min($end, $len) - 1, $list = array(); $i < $len && $i >= 0 && $i >= $start; $i--){
    if ( preg_match( "/\.($allowFiles)$/i" , $files['items'][$i]['key'] ) ) {
             $list[] = array("url"=>$HOST."/".$files['items'][$i]['key']);
          }
    
}

/* 返回数据 */
$result = json_encode(array(
    "state" => "SUCCESS",
    "list" => $list,
    "start" => $start,
    "total" => count($files['items'])
));

return $result;

