<?php
// +----------------------------------------------------------------------
// | LTHINK [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2016 http://LTHINK.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 涛哥 <liangtao.gz@foxmail.com>
// +----------------------------------------------------------------------
// | WeixinSDK.php  By Taoge 2017/9/28 11:30
// +----------------------------------------------------------------------

// namespace thinksdk\ThinkSDK\sdk;

use thinksdk\ThinkOauth;

class BaiduSDK extends ThinkOauth
{

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://openapi.baidu.com/oauth/2.0/authorize';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://openapi.baidu.com/oauth/2.0/token';

    public function login()
    {
     setcookie('A_S', $this->timestamp, $this->timestamp + 600, '/');
        $params = [
            'client_id'     => $this->config['app_key'],// 应用的唯一标示，既注册应用时获得的API Key。
            'response_type' => $this->config['response_type'],
            'redirect_uri'  => $this->config['callback'],
            'state'         => $this->timestamp,
        ];
        return $this->GetRequestCodeURL . '?' . http_build_query($params);
    }

    public function getAccessToken()
    {
      
        $params = array(
            'client_id'    => $this->config['app_key'],// 应用的唯一标示，即注册应用时获得的API Key；
            'client_secret'=> $this->config['app_secret'], // 应用的私钥，即注册应用时获得的Secret Key；
            'grant_type'   => 'authorization_code',

            'code'         => $_GET['code'],

            'redirect_uri' => $this->config['callback'],
        );
   
        $result = $this->http($this->ApiBase,$params,'get');


        $data = json_decode($result, true);
        if ($data['access_token'] && $data['expires_in'] && $data['refresh_token'] && $data['session_secret']) {
            return $data;
        } else {
            throw new Exception("获取百度ACCESS_TOKEN出错：{$data['error']}");
        }
    }

    /**
     * 组装接口调用参数 并调用接口
     */
    public function call($api, $param = array(), $method = 'POST', $multi = false)
    {
        $param['client_id']    = $this->config['app_key'];
        $param['access_token'] = $this->token['access_token'];
        // $param['domain']       = $_SERVER['HTTP_HOST'];

        $data = $this->http('https://openapi.baidu.com/rest/2.0/'.$api, $param, $method);
        return json_decode($data, true);
    }

    /**
     * 获取当前授权应用的openid
     */
    public function openid()
    {
        $data = $this->token;
        if (!empty($data['uid']))
            return $data['uid'];
        else
            exit('没有获取到百度用户ID！');
    }

    /**
     * 解析access_token方法请求后的返回值
     */
    protected function parseToken($result)
    {


    }
    /**
     * 获取授权用户的用户信息
     */
    public function userinfo()
    {
        $rsp = $this->call('user/get_user_info');
        if (!$rsp || $rsp['ret'] != 0) {
            throw new Exception('接口访问失败！' . $rsp['msg']);
        } else {
            $userinfo = array(
                'openid'  => $this->openid(),
                'name'    => $rsp['nickname'],
                'head'    => $rsp['figureurl']
            );
            return $userinfo;
        }
    }
}



