<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体内容管理系统 免费版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | 官方论坛：http://bbs.qilecms.com
// +----------------------------------------------------------------------
// | Author:奇乐网络
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\admin\controller;
use think\Db;
class Ad extends AdPosition
{
	public function index(){
      $param = $this->request->param();
      $alias = 'a';        //需要别名时写别名，不需要的时候留空
      if($param['position_id']){
       $defaultWhere = $alias.'.position_id = '.$param['position_id']; //默认where
      }

    
      $defaultOrder = 'a.create_time desc';  //默认排序
    //接收搜索表单数据
      $SearchFormData = $this->getSearchFormData($defaultWhere,$defaultOrder);
      $where = $SearchFormData['where'];
      $order = $SearchFormData['order'];
      $pageNum = $SearchFormData['pageNum'];

//组建关键词数据
     $keywordsData  =[
                  [
                  'field'   =>'ad_id', //字段名
                  'name'    =>'广告ID', //文本显示名称
                  'alias'   => $alias,  //字段对应的别名
                  ],
                  [
                  'field'   =>'title',
                  'name'    =>'广告标题',
                  'alias'   => $alias,
                  ],
                  [
                  'field'   =>'username',
                  'name'    =>'用户名',
                  'alias'   => $alias,
                  ],
                  [
                  'field'   =>'editor',
                  'name'    =>'操作人',
                  'alias'   => $alias,
                  ],


                  
     ];
//组建日期筛选   
       $dateData = [
                  [
                  'title'        =>'开始时间',  //标签显示名称
                  'field'        =>'start_time', //筛选字段
                  'start_name'   =>'开始时间', //开始时间
                  'end_name'     =>'结束时间', //结束时间
                  'alias'        => $alias,  //字段别名
                  ],
                  [
                  'title'        =>'结束时间',  //标签显示名称
                  'field'        =>'end_time', //筛选字段
                  'start_name'   =>'开始时间', //开始时间
                  'end_name'     =>'结束时间', //结束时间
                  'alias'        => $alias,  //字段别名
                  ],


              ];
//单个字段筛选
    $customSingleField =[
                            [
                             'name'=>'状态',
                             'field' => 'status', 
                             'data'  => [0 =>'待审核',1=>'投放中',2=>'关闭'],
                             'alias'=>$alias,
                            ]
                       ]; 
// 组件字段组筛选
     $groupData   = [];
     $orderData   = [];  
     
 
     $this->assign('keywordsData',$keywordsData);
     $this->assign('customSingleField',$customSingleField);
     $this->assign('groupData',$groupData);
     $this->assign('dateData',$dateData);
     $this->assign('orderData',$orderData);


     $list = DB::name('ad')->alias('a')
     ->join('ad_position b','a.position_id = b.position_id ','LEFT')
     ->where($where)
     ->order($order)
     ->paginate($pageNum);
     $page = $list->render();
     $this->assign('page', $page);
     $this->assign('list', $list->toArray()['data']);
     return $this->fetch();
	}
// //增加
  public function add(){
    $param = $this->request->param(); 
    if($this->request->isAjax()){   
        //验证
        $rule =[
          'title'=>'require',
          'position_id'=>'require',
        ];
        $msg= [
         'title.require'  => '广告标题不能为空',
         'position_id.require'  => '广告位不能为空', 
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  
       if($error){
              return error_json($error);
         }
         //表单数据
          $data['title']       = $param['title'];

          $data['area_id']     = isset($param['area_id'])?$param['area_id']:0;
          $data['position_id'] = $param['position_id'];

          $data['start_time']  = strtotime($param['start_time']);
          $data['end_time']    = strtotime($param['end_time']);
          $data['create_time'] = time();

          $data['ad_type'] = $param['ad_type'];

            if($param['ad_type'] == 0 || $param['ad_type'] == 2){
//图片广告
          $data['ad_img'] = $param['ad_img'];  
          }elseif($param['ad_type'] == 1){
// 代码广告
           $data['code'] = $param['code'];
          }
            $data['url'] = $param['url']; 
            $data['status'] = !empty($param['status'])?1:0;
       
       if(model('ad')->addData($data)){
         return success_json('添加成功'); 
       }
   }else{
         // $position_id = $param['position_id'];
         // $adPosition = model('adPosition')->getAdPositionById($position_id);
         // echo model('adPosition')->getLastSql();
         // $adPosition = $adPosition->toArray();
         // $this->assign('time',time());
         // $this->assign('adPosition',$adPosition);
         


        return $this->fetch();
   }      
  }
  public function edit(){
    $param = $this->request->param();

    if($this->request->isPost()){

        //验证
        $rule =[
          'title'=>'require',
          'position_id'=>'require',
        ];
        $msg= [
         'title.require'  => '广告标题不能为空',
         'position_id.require'  => '广告位不能为空', 
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  
       if($error){
              return error_json($error);
         }
    
        //表单数据
          $data['title']       = $param['title'];
          $data['area_id']     = isset($param['area_id'])?$param['area_id']:0;
          $data['position_id'] = $param['position_id'];

          $data['start_time']  = strtotime($param['start_time']);
          $data['end_time']    = strtotime($param['end_time']);
          $data['create_time'] = time();
          
          $data['ad_type'] = $param['ad_type'];

          if($param['ad_type'] == 0 || $param['ad_type'] == 2){
//图片广告
          $data['ad_img'] = $param['ad_img'];  
          }elseif($param['ad_type'] == 1){
// 代码广告
           $data['code'] = $param['code'];
          }


          $data['url'] = $param['url']; 
          $data['status'] = !empty($param['status'])?1:0;
          $where['ad_id'] = $param['ad_id'];
          $res = model('ad')->editData($data,$where);
          return success_json('编辑成功'); 
    }else{

         $position_id = $param['position_id'];
         $adPosition = model('adPosition')->getAdPositionById($position_id);
         
        
         $this->assign('adPosition',$adPosition);

         
         $ad = model('ad')->getAdInfo($param['ad_id']);
         $this->assign('ad',$ad);
         
         $this->assign('time',time());

         return $this->fetch();


    }  
  }

  //批量删除或者单个删除
  public function del(){
      $param = $this->request->param();
     if(!$param['ad_id']){  return error_json('请求参数错误');    }
     $ad_id = $param['ad_id'];
     
     if(is_array($ad_id)){
       $ids = implode(',',$ad_id);
     }else{
       $ids = $ad_id;
     }  
     $where[]= ['ad_id','in',$ids];
     $res= model('ad')->delData($where);
       if($res){
         return success_json('删除成功');
       }else{
         return error_json('删除失败');
       }
    }
 
 public function getInfoByPositionCateId(){
 	  $param = $this->request->param();
 	 if(!$param['id']){  return error_json('请求参数错误');    }
 	  $where['position_cate_id'] = $param['id'];
    $result = model('adPosition')->getAdPosition($where); 
    return success_json('成功',$result); 
 }
    
 
}