<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体内容管理系统 免费版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | 官方论坛：http://bbs.qilecms.com
// +----------------------------------------------------------------------
// | Author:奇乐网络
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\admin\controller;
use think\controller;
use think\Db;
class AdminRole extends Base
{
  // 管理员角色表
	public function index(){
      $alias = '';        //需要别名时写别名，不需要的时候留空 
      $defaultWhere = '';  //默认where
      $defaultOrder = 'sort desc';  //默认排序
    //接收搜索表单数据
      $SearchFormData = $this->getSearchFormData($defaultWhere,$defaultOrder);
      $where = $SearchFormData['where'];
      $order = $SearchFormData['order'];
      $pageNum = $SearchFormData['pageNum'];

//组建关键词数据
     $keywordsData  =[
                  [
                  'field'   =>'role_id', //字段名
                  'name'    =>'角色ID', //文本显示名称
                  'alias'   => $alias,  //字段对应的别名
                  ],
                  [
                  'field'   =>'role_name',
                  'name'    =>'角色名称',
                  'alias'   => $alias,
                  ]
     ];
//组建日期筛选   
    $dateData = [];
//单个字段筛选
    $customSingleField =[
                            [
                             'name'=>'状态',
                             'field' =>'status', 
                             'data'  => [ 0 =>'禁用',1=>'启用'],
                             'alias'=>$alias,
                            ]
                       ]; 
// 组件字段组筛选
    $groupData   = [];
    $orderData   = [];  

     $this->assign('keywordsData',$keywordsData);
     $this->assign('customSingleField',$customSingleField);
     $this->assign('groupData',$groupData);
     $this->assign('dateData',$dateData);
     $this->assign('orderData',$orderData);


     $list = DB::name('admin_role')->where($where)->order($order)->paginate($pageNum);
     $page = $list->render();
     $this->assign('page', $page);
     $this->assign('list', $list->toArray()['data']);

     return $this->fetch();
	}
//增加
  public function add(){
    $param = $this->request->param(); 
  
    if($this->request->isPost()){   

        //验证
        $rule =[
          'role_name'=>'require|chsAlpha',

        ];
        $msg= [
         'role_name.require' =>'管理员角色名称不能为空',
         'role_name.chsAlpha' =>'管理员角色名称只能是汉字或字母',
  
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  
       if($error){
              return error_json($error);
         }
         //表单数据
         //添加角色数据
          $data['role_name'] = $param['role_name'];
               if(!empty($param['rulesid'])){
             $rules = rtrim($param['rulesid'],',');
          }else{
             $rules ='';
          }
           $data['remarks'] = $param['remarks']; //备注
          $data['rules'] = $rules;
          $data['sort']  = $param['sort'];
          $data['status'] = !empty($param['status'])?1:0;

       if(model('admin_role')->addData($data)){
         return success_json('添加成功'); 
       }
   }else{
         // // 显示权限列表
        $list = model('admin_nav')->getNavTree();
        $this->assign('list',$list);
        return $this->fetch();
   }      
  }
  public function edit(){
    $param = $this->request->param();
    if($this->request->isAjax()){

        //验证
        $rule =[
          'role_name'=>'require|chsAlpha',

        ];
        $msg= [
         'role_name.require' =>'管理员角色名称不能为空',
         'role_name.chsAlpha' =>'管理员角色名称只能是汉字或字母',
    
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  
       if($error){
              return error_json($error);
         }
    
        //表单数据   
      
      // 修改角色数据
          $data['role_name'] = $param['role_name'];
           if(!empty($param['rulesid'])){
             $rules = rtrim($param['rulesid'],',');
          }else{
             $rules ='';
          }
      
          $data['remarks'] = $param['remarks']; //备注
          $data['sort'] = $param['sort'];
          $data['rules'] = $rules;
          $data['status'] = !empty($param['status'])?1:0;
          $where['role_id'] = $param['id'];
          $res = model('admin_role')->editData($data,$where);
          return success_json('编辑成功'); 
    }else{
           // 显示权限列表
          $list = model('admin_nav')->getNavTree();
          $this->assign('list',$list);


         $adminRole = model('admin_role')->getAdminRoleInfoById($param['id']);
         $rules = explode(',',$adminRole['rules']);
        
         $this->assign('rules',$rules);
         $this->assign('adminRole',$adminRole);
         return $this->fetch();


    }  
  }
  public function del(){
      $param = $this->request->param();
     if(!$param['id']){  return error_json('请求参数错误');    }
     $id =  $param['id'];
         if(is_array($id)){
             $ids = implode(',',$id);
           }else{
             $ids = $id;
         }  
     $where[]= ['role_id','in',$ids];

     $res= model('admin_role')->delData($where);
     if(model('admin_role')->error){
       return error_json(model('admin_role')->error);
     }else{
        return success_json('删除成功');

     }
  }
      

}