<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体内容管理系统 免费版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | 官方论坛：http://bbs.qilecms.com
// +----------------------------------------------------------------------
// | Author:奇乐网络
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\admin\controller;
use think\controller;
use think\DB;
use think\facade\Request;
class User extends Base
{
	//用户信息列表
   public function index(){
     
      $alias = '';        //需要别名时写别名，不需要的时候留空 
      $defaultWhere = '';
      $defaultOrder = 'reg_time desc';
    //接收搜索表单数据
      $SearchFormData = $this->getSearchFormData($defaultWhere,$defaultOrder);
      $where = $SearchFormData['where'];
      $order = $SearchFormData['order'];
      $pageNum = $SearchFormData['pageNum'];

//组建关键词数据
     $keywordsData  =[
                  [
                  'field'   =>'uid', //字段名
                  'name'    =>'用户UID', //文本显示名称
                  'alias'   => $alias,  //字段对应的别名
                  ],
                  [
                  'field'   =>'username',
                  'name'    =>'用户名',
                  'alias'   => $alias,
                  ]
     ];
//组建日期筛选   
       $dateData = [
                  [
                  'title'        =>'登陆时间',  //标签显示名称
                  'field'        =>'login_time', //筛选字段
                  'start_name'   =>'开始时间', //开始时间
                  'end_name'     =>'结束时间', //结束时间
                  'alias'        => $alias,  //字段别名
                  ],
                  [
                  'title'        =>'注册时间',
                  'field'        =>'reg_time', 
                  'start_name'   =>'开始时间',
                  'end_name'     =>'结束时间',
                  'alias'        => $alias  //字段别名
                  ]
              ];
//单个字段筛选
    $customSingleField =[
                            [
                             'name'=>'审核状态',
                             'field' => 'status', 
                             'data'  => [ 0 =>'等待审核',1=>'正常',-1=>'禁止访问'],
                             'alias'=>$alias,
                            ]
                       ]; 
// 组件字段组筛选
    $groupData = [
     
        
              ];
     $orderData   = [
     
               ];  

     $this->assign('keywordsData',$keywordsData);
     $this->assign('customSingleField',$customSingleField);
     $this->assign('groupData',$groupData);
     $this->assign('dateData',$dateData);
     $this->assign('orderData',$orderData);


     $list = DB::name('user')->where($where)->order($order)->paginate($pageNum);
     $page = $list->render();
     $count = $list->total();
     $this->assign('count', $count);
     $this->assign('page', $page);
     $this->assign('list', $list->toArray()['data']);
	  return $this->fetch();
	} 

//增加
  public function add(){
    $param = $this->request->param(); 
    if($this->request->isAjax()){   
   
        //验证
        $rule =[
          'username'=>'require|alphaDash',
          'password'=>'require|min:6',
          'repassword'=>'require|min:6',
        ];
        $msg= [
         'username.require' =>'用户名不能为空',
         'username.alphaDash' =>'用户名只能是字母和数字，下划线_及破折号-',
         'password.require' =>'登陆密码不能为空', 
         'password.min' =>'登陆密码至少6位',   
         'repassword.require' =>'重复密码不能为空', 
         'repassword.min' =>'重复密码至少6位',        
        ];

         if($error = $this->checkSubmit($param,$rule,$msg)){

              return error_json($error);
         }
         //表单数据
          $data['username'] = $param['username'];
          $data['nickname'] = !empty($param['nickname'])?$param['nickname']:$param['username'];
        

          if($param['password'] != $param['repassword']){
             return error_json('重复登陆密码不一致');  
          }
          // 登陆加密码
          $passsalt = random_text(8);
          $data['password'] = password_key($data['username'],$param['password'],$passsalt);
          $data['passsalt']  = $passsalt; 
           
          if($param['payword'] != $param['repayword']){
             return error_json('重复支付密码不一致');  
          }

           $paysalt = random_text(8); //支付密钥
          if($param['payword']){
            //支付密码存在
            $data['payword']  = payword_key($data['username'],$param['payword'],$paysalt);
            $data['paysalt']  = $paysalt;  

          }else{
            // 支付密码不存在，初始化密码为登陆密码
            $data['payword']  = payword_key($data['username'],$param['password'],$passsalt);
            $data['paysalt']  = $passsalt;  
          }


          $data['gender'] = !empty($param['gender'])?1:0; //0 男  1女  2保密
          $data['avatar'] = $param['avatar'];
   
         //省份
          if($param['prov']){
              $data['provid'] = $param['prov'];     
          }
          //城市
          if($param['city']){
              $data['cityid'] = $param['city'];
          }
          // 地区
          if($param['dist']){
             $data['distid'] = $param['dist'];  
          }

           //是否实名认证
           if(!empty($param['is_realname'])){
                if($param['realname'] ==''){
                   return error_json('已实名认证，真实姓名必须存在');
                } 
           } 
           $data['is_realname'] = !empty($param['is_realname'])?$param['is_realname']:0;     
          //是否银行卡认证
           $data['is_bank']     = !empty($param['is_bank'])?$param['is_bank']:0; 
         //是否邮件认证
           $data['is_email']    = !empty($param['is_email'])?$param['is_email']:0; 
         //是否手机认证
           $data['is_mobile']   = !empty($param['is_mobile'])?$param['is_mobile']:0; 

          
          
          
          $data['realname'] = $param['realname'];
          $data['mobile'] = $param['mobile'];
          $data['qq']     = $param['qq'];
          $data['email']  = $param['email'];
          $data['login_count'] = 0;
          $data['reg_time']    = time();
          $data['reg_ip'] = get_client_ip();
          $data['status'] = $param['status'];
        //如果用户不存在则添加
        $where['username'] = $data['username'];
        $user = model('user')->infoData($where);
        if(!empty($user)){
         return error_json('该用户名已经存在，请勿重复添加');
        }

       if(model('user')->addData($data)){
         return success_json('添加成功'); 
       }
   }else{

        return $this->fetch();
   }      
  }
  public function edit(){
    $param = $this->request->param();
    if($this->request->isAjax()){

           //验证
        $rule =[
           'id'=>'require',
          'username'=>'require|alphaDash',
        ];
        $msg= [
         'id.require' =>'请求参数错误',
         'username.require' =>'用户名不能为空',
         'username.alphaDash' =>'用户名只能是只能是字母和数字，下划线_及破折号-',
       
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  
         if($error){
              return error_json($error);
         }
         //表单数据
     
          $data['nickname'] = !empty($param['nickname'])?$param['nickname']:$param['username'];
        
         
          if(!empty($param['password'])){
            if($param['password'] != $param['repassword']){
               return error_json('重复登陆密码不一致');  
            }
            $where['uid'] = $param['id'];
            $user = model('user')->infoData($where);
            //$passsalt = random_text(8); //登陆加密码
            $data['password'] = password_key($user['username'],$param['password'],$user['passsalt']);
            
          }
          
          if(!empty($param['payword'])){
                if($param['payword'] != $param['repayword']){
                  return success_json('重复支付密码不一致');  
                }
                
           $data['payword'] = payword_key($user['username'],$param['payword'],$user['paysalt']);
               
          }

        

          $data['gender']   = !empty($param['gender'])?1:0; //0 男  1女  2保密
          $data['avatar']   = $param['avatar'];
      
         //省份
          if($param['prov']){
              $data['provid'] = $param['prov'];     
          }
          //城市
          if($param['city']){
              $data['cityid'] = $param['city'];
          }
          // 地区
          if($param['dist']){
             $data['distid'] = $param['dist'];  
          }


           //是否实名认证
           if(!empty($param['is_realname'])){
                if($param['realname'] ==''){
                   return error_json('已实名认证，真实姓名必须存在');
                } 
           } 
           $data['is_realname'] = !empty($param['is_realname'])?$param['is_realname']:0;     
          //是否银行卡认证
           $data['is_bank']     = !empty($param['is_bank'])?$param['is_bank']:0; 
         //是否邮件认证
           $data['is_email']    = !empty($param['is_email'])?$param['is_email']:0; 
         //是否手机认证
           $data['is_mobile']   = !empty($param['is_mobile'])?$param['is_mobile']:0; 

          
          $data['realname'] = $param['realname']; //实名
          $data['mobile'] = $param['mobile'];
          $data['qq']     = $param['qq'];
          $data['email']  = $param['email'];
          $data['status'] = $param['status'];         
          $where['uid']   = $param['id'];
          $res = model('user')->editData($data,$where);
        
          return success_json('编辑成功'); 
    }else{
         $user = model('user')->getUserByUid($param['id']);
         $this->assign('user',$user);

          
         return $this->fetch();


    }  
  }
  public function del(){
      $param = input();
     if(!$param['uid']){  return error_json('请求参数错误');    }
       $res= $this->delData('user','uid');
       if($res){
        //删除关注  
          $this->delData('follow','follow_who','uid');  //批量删除关注信息
          $this->delData('follow','who_follow','uid');  //批量删除关注信息
        //删除收藏
          $this->delData('collect','uid');  //批量删除关注信息
        //删除文章
        
          $this->delData('article','uid');  //批量删除关注信息
        //删除文章评论
          $this->delData('article_comment','uid');  //批量删除关注信息
        //删除点赞
         $this->delData('zan','uid');  //批量删除关注信息
    
        return success_json('删除成功');
       }else{
        return error_json($res);
       }
  }


   public function show(){
      $username = input("get.username");
      $user =  model('user')->getUserByUsername($username);
      $this->assign('user', $user);
      return $this->fetch();
   }

//禁止访问
	public function ban(){
     $param = $this->request->param(); 
     if($this->request->isAjax()){
       if($param['type'] != -1){  return error_json('参数错误');}
          $uid = $param['id'];
          $userinfo = model('user')->getUserByUid($param['type']);
          $data['status'] = -1;
           if(is_array($uid)){
             $idData = implode(',',$uid);
          }else{
             $idData = $uid;
          }
          
          $where ="uid IN ($idData)";
          model('user')->editData($data,$where);
          return success_json('已设置禁止访问！');


     }

  }
  //用户列表
  public function userSelect()
   {
        $alias = '';        //需要别名时写别名，不需要的时候留空 
        $defaultWhere = '';
        $defaultOrder = 'reg_time desc';
      //接收搜索表单数据
        $SearchFormData = $this->getSearchFormData($defaultWhere,$defaultOrder);
        $where = $SearchFormData['where'];
        $order = $SearchFormData['order'];
        $pageNum = $SearchFormData['pageNum'];

  //组建关键词数据
       $keywordsData  =[
                    [
                    'field'   =>'uid', //字段名
                    'name'    =>'用户UID', //文本显示名称
                    'alias'   => $alias,  //字段对应的别名
                    ],
                    [
                    'field'   =>'username',
                    'name'    =>'用户名',
                    'alias'   => $alias,
                    ]
       ];
  //组建日期筛选   
         $dateData = [

                ];
  //单个字段筛选
      $customSingleField =[
                         ]; 
  // 组件字段组筛选
      $groupData = [];
       $orderData   = [
            
                 ];  

       $this->assign('keywordsData',$keywordsData);
       $this->assign('customSingleField',$customSingleField);
       $this->assign('groupData',$groupData);
       $this->assign('dateData',$dateData);
       $this->assign('orderData',$orderData);


       $list = DB::name('user')->where($where)->order($order)->paginate($pageNum);
       $page = $list->render();
       $count = $list->total();
       $this->assign('count', $count);
       $this->assign('page', $page);
       $this->assign('list', $list->toArray()['data']);
      return $this->fetch();
   }
}