<?php
namespace app\common\controller;
use think\Controller;
use think\facade\Cache;
use think\Validate;
use think\facade\Request;
use think\Db;
use think\Url;
use think\helper\Time;
class Common extends Controller{
 protected $yser;
 protected $settings; //全局配置
 protected function initialize(){
         parent::initialize();
         $this->initConfig();  //初始化全局配置
         $this->initTheme();   //初始化模板主题
         $this->initUser();    //初始化会员信息
   } 
//初始化全局配置文件
  protected function initConfig()
  {
       if($this->request->module() == 'admin'){
        //后台模块
          $this->settings = get_settings();
       }else{
        // 前台所有模块
          $this->settings = get_settings(true);
       }

      $this->settings['site']['sitename'];
      $this->assign('settings',$this->settings); 
      
  }
/**
* [initTheme 初始化模板主题]
* 
*/
    protected function initTheme()
    {
           if($this->request->module() == 'mobile'){
            // 移动端
                  //不做处理使用默认模块配置下配置信息
               $path = config('template.view_path').'mobile'.'/'.config('template.default_theme').'/'; 
                // 默认模板模块路径
                 \think\facade\View::config('view_path',$path); //thinkphp5.1.14 新增,之前版本动态配置view_path 无效

                 $this->theme_path =  config('template.view_path').'pc/'.config('template.default_theme').'/';
           }elseif($this->request->module() == 'admin'){
              //不做处理使用默认模块配置下配置信息


           }else{
            //PC端
                if(!cache('template')){
                     $DefaultTheme = model('template')->getDefaultTheme();
                     cache('template',$DefaultTheme);
                 }else{
                     $DefaultTheme =  cache('template');
                 } //获得默认模板         
                 // 默认主题路径
                 config('template.default_theme',$DefaultTheme['dirname']);   //动态设置主题

                 // 动态修改模板路径
                 $path = config('template.view_path').'pc/'.config('template.default_theme').'/'.$this->request->module().'/'; 
                 // 默认模板模块路径
                 \think\facade\View::config('view_path',$path);
                 $this->theme_path =  config('template.view_path').'pc/'.config('template.default_theme').'/';
                
                //前台跳转自动手机端
                 
                     // 默认跳转页面对应的模板文件
                // 'dispatch_success_tmpl'  => Env::get('think_path') . 'tpl/dispatch_jump.tpl',
                // // 'dispatch_error_tmpl'    => Env::get('think_path') . 'tpl/dispatch_jump.tpl',
                // 'dispatch_error_tmpl'    => 'public/error',

                
                  //移动端判断
              if($this->request->isMobile() && $this->settings['mobile']['auto_jump'] == 1){

                          header('location:mobile');

               }
           

           }

    }
/**
 * [initUser 初始化User用户信息]
 * @return [type] [description]
 */
   protected function initUser()
   {
          if(session('?uid')){
              $map['uid']    = session('uid');
              $map['status'] = 1; //正常用户
              $user = model('user')->infoData($map); 
              $this->user = $user;
              $this->assign('user',$user);
          }

   }

   protected function checkSubmit($data=[],$rule=[],$msg=[]){
            // $rule = [
            //     'name'  => 'require|max:25',
            //     'age'   => 'number|between:1,120',
            //     'email' => 'email',
            // ];

            // $msg = [
            //     'name.require' => '名称必须',
            //     'name.max'     => '名称最多不能超过25个字符',
            //     'age.number'   => '年龄必须是数字',
            //     'age.between'  => '年龄只能在1-120之间',
            //     'email'        => '邮箱格式错误',
            // ];

            // $data = [
            //     'name'  => 'thinkphp',
            //     'age'   => 10,
            //     'email' => 'thinkphp@qq.com',
            // ];

            $validate   = Validate::make($rule,$msg);
            $result = $validate->check($data);
            if(!$result) {
              return $validate->getError();
            }
    }

//验证token  
    protected function token(){
       // if($this->request->isAjax()){
       //    $param = $this->request->param();

       // }

    }



     /**
     * 数据库字段 网页字段转换
     * #Date:
     * @param $array 转化数组
     * @return 返回数据数组
     */
    protected function buildParam($array=[])
    {
       
        $data=[];
        if (is_array($array) && !empty($array)){         
            foreach( $array as $item => $value){        
                $data[$item] = $this->request->param($value);
            }
        }
        return $data;
    }  

/**
 * [setCache description]
 * @param [type] $model [数据表对应的模型]
 * @param [type] $field   [字段值]
 */
    public function setCache($model,$field)
    {
        $data = Db::name($model)->select();
     
        $list = [];
        foreach($data as $k=>$v){
          $list[$v[$field]] = $v;
        } 
        Cache::set($model,$list);

    }
/**
 * [getCache description]
 * @param [type] $model [数据表对应的模型]
 * @param [type] $field   [字段值]
 */
    public function getCache($model,$field)
    {
     
        $cache = Cache::get($model);
        if(empty($cache)){
           $this->setCache($model,$field);
            $cache = Cache::get($model);
        }
        return $cache;
    }


}