<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体管理系统 商业版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilewl.com   
// +----------------------------------------------------------------------
// | 产品网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | Author:合肥奇乐网络科技有限公司 
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\portal\controller;
use \think\Db;
use \think\Tree;
class Article  extends Base
{

    public function list() {
       if($this->request->isAjax()){
                 $param = $this->request->param();
                 $cate = $this->getCache('articleCategory','cid');
 
             $cid =  isset($param['cid'])?$param['cid']:'all'; //当前分类id
             $pid =  isset($param['pid'])?intval($param['pid']):''; //
             if(empty($pid)){
                    return json(['code'=>0,'msg'=>'success','pages'=>0,'data'=>'']);
             }
                 if($cid > 0){
                   $where[]= ['cid','=',$cid];
                 }else{
                  //有子类
                  include EXTEND_PATH.'Tree.php';

                  $config['id'] ='cid';
                  $tree = new \think\Tree($config);
                  $treeinfo = $tree->getChildsId($cate,$pid);
                    if($treeinfo){
                      $where[] = ['cid','IN',$treeinfo];         
                     }else{
                        $where[]= ['cid','=',$pid];
                     }
                    
                 }
        
             $page   = !empty($param['page'])?intval($param['page']):1; //开始页面
             $limit  = !empty($param['limit'])?intval($param['limit']):10; //分页数量

       
             $where[] = ['status','=',1]; //审核通过
             $total  = Db::name('article')->where($where)->count();
             $list   = Db::name('article')->where($where)->order($order)->paginate($limit);
                 

                 $data = [];
             foreach($list as $k=>$v){
                $data[$k]['id']     = $v['aid'];
                $data[$k]['thumb']  = $v['thumb'];
                $data[$k]['thumb1'] = $v['thumb1'];
                $data[$k]['thumb2'] = $v['thumb2'];
                $data[$k]['url']    = $v['url'];
                $data[$k]['title']  = $v['title'];
               
                    $data[$k]['username']  = get_nickname($v['uid']);
                    $data[$k]['create_time'] = format_time('Y-m-d',$v['create_time']);
                    $data[$k]['hits']    = $v['hits'];
                    $data[$k]['content'] = get_filter_str($v['content'],110);
                    $data[$k]['comment'] = $v['comment'];
                    
                    $data[$k]['cname']   = $cate[$v['cid']]['cname'];
                    $data[$k]['url']     = url('@portal/article/detail',['aid'=>$v['aid']]);
               
             }
           
            return json(['code'=>0,'msg'=>'success','pages'=>ceil($total/$limit),'data'=>$data]);
         


       }else{
                       $param =$this->request->param();
              if($param['alias']){
                $where['alias'] = $param['alias']; //别名
                // 一级分类
                  $oneCategory= model('articleCategory')->infoData($where);

                   $this->assign('oneCategory',$oneCategory);
                         //获得二级分类
                  $where2['pid'] = $oneCategory['cid'];
                  $childrenCate = model('article_category')->listData($where2);
                  $cate = $this->getCache('articleCategory','cid');
                  foreach($childrenCate as $k=>$v){

                      $map2['cid']   =$v['cid'];
                      $map2['status'] =1;
                      $childrenCate[$k]['article_list'] = model('article')->listData($map2,'','',10);
                      foreach($childrenCate[$k]['article_list'] as $k2=>$v2){
                                  $childrenCate[$k]['article_list'][$k2]['cname'] = $cate[$v2['cid']]['cname'];
                      }
                  }
                  $this->assign('childrenCate',$childrenCate);
             
              }
              //24小时热文章
              $map3[] =['status','=',1];
              $map3[] =['thumb','<>',''];
              $hour =time()-86400;
              $map3[] =['create_time','>',$hour];
              $hour_article_list = model('article')->listData($map3,'','hits desc',10);
              foreach($hour_article_list as $k=>$v){
                $hour_article_list[$k]['cname']   = $cate[$v['cid']]['cname'];
              }
              $this->assign('hour_article_list',$hour_article_list);
              
                if(empty($oneCategory['list_template'])){
                         $this->error('模板不存在');
                }
                return $this->fetch($this->theme_path.$oneCategory['list_template']);
       }

    }

     public function detail() 
    {


        $param = $this->request->param();
      $aid = $param['aid'];

      if($aid < 0){
        $this->redirect('文章正在审核或者已被删除');
      }

      $where['aid'] = $aid;
      $article = model('article')->infoData($where);
      $cate = $this->getCache('articleCategory','cid');
      $article['cname'] = $cate[$article['cid']]['cname'];
      if(empty($article)){
        $this->error('文章正在审核或者已被删除');
      }
    
    //审核或者拒绝状态下预览  
      if($article['status'] !=1){
        if($this->user->uid != $article['uid']){
           $this->error('文章正在审核或者已被删除'); 
        }
      }

     
 
//更新文章信息
      $where['aid'] =$aid;
      model('article')->where($where)->setInc('hits',1);

  

      //获得文章数量统计
      $map['uid'] = $article['uid'];
      $article_count = Db::name('article')->cache('article_count',60)->where($map)->count('aid'); //统计文章数量
      $article['article_count'] = $article_count;
      $this->assign('article',$article);
 //获得收藏数量统计    
        $collect_map['article_id'] = $article['aid'];
        $collect_map['uid'] = $this->user->uid;
        $collect = model('collect')->infoData($collect_map);
        if(!empty($collect)){
            $article['is_collect'] = 1;
        }else{
            $article['is_collect'] = 0;
        }
        $collect_map2['article_id'] = $article['aid'];
        $collect = model('collect')->where($collect_map2)->count();
        $article['collect'] = !empty($collect)?$collect:0;


//获得关注状态
       
       $res = model('follow')->infoData(['who_follow'=>$this->user->uid,'follow_who'=>$article['uid']]);
        if(!empty($res)){
          $article['is_follow'] =  1;  //当前登陆用户是否关注
        }
//获得树状评论
        $map2['article_id'] = $article['aid'];
        $map2['status'] = 1;
        $order['create_time'] = 'desc';
        $comment = model('articleComment')->listPageData($map2,'',$order,10);

        $this->assign('comment',$comment);

        include EXTEND_PATH.'Tree.php';;
        $tree = new Tree(['id'=>'comment_id']);
        $comment =  $tree->listToTree($comment->toArray()['data']);
   
        $article['comment_list'] = $comment;   
//文章标签
        $tag = explode(',',$article['tag']);
        $article['tag'] = $tag;
        $this->assign('article',$article);



//热门文章推荐
        $order['hits'] = 'desc';
        $map3[] = ['thumb','<>',''];
        $hot_article = model('article')->listData($map3,'',$order,100);
       
        $this->assign('hot_article',$hot_article);

         if(empty($cate[$article['cid']]['detail_template'])){
                         $this->error('模板不存在');
         }
        return $this->fetch($this->theme_path.$cate[$article['cid']]['detail_template']);
    }

}
