<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体内容管理系统 免费版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | 官方论坛：http://bbs.qilecms.com
// +----------------------------------------------------------------------
// | Author:奇乐网络
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\user\controller;
use \think\Db;
class Index  extends Base
{
   public function initialize()
    {
       parent::initialize();
       $this->isLogin();
    }
    public function index()
    {
    

             $param = $this->request->param();
		         $title =  isset($param['title'])?$param['title']:''; //请求状态

		         $limit  = !empty($param['limit'])?intval($param['limit']):10;; //分页数量

		        
		         if(!empty($title)){
                  $where[] = ['title','like',"%$title%"];
		         }
             $where[] = ['uid','=',session('uid')];
		          $order['create_time'] = 'desc';
		         
                 $lists  = Db::name('article')->where($where)->order($order)->paginate($limit);
                 $count   =$lists->total();
                 $cate = $this->getCache('articleCategory','cid');
                 $data = [];
                 $list = $lists->toArray()['data'];
		         foreach($list as $k=>$v){
    		            $data[$k]['id']     = $v['aid'];
    		            $data[$k]['thumb']  = $v['thumb'];
    		  
    		            $data[$k]['title']  = $v['title'];
	
                    $data[$k]['username'] = $v['username'];
                    $data[$k]['create_time'] = date('Y-m-d',$v['create_time']);
                    $data[$k]['hits'] = $v['hits'];
                    $data[$k]['comment'] = $v['comment'];

                    $data[$k]['url']     = url('@portal/article/detail',['aid'=>$v['aid']]);
                    $data[$k]['status']   = $v['status'];
		           
		           }
		      
        
         $this->assign('list',$lists);
      return $this->fetch();
    }
//发布文章
   public function publish(){
      if($this->request->isAjax()){
          
          $param = $this->request->param();

	   //验证
	        $rule =[ 
	          'cid'=>'require',  
	          'title'=>'require',
	          'content'=>'require',
	          
	        ];
	        $msg= [
	         'cid.require' =>'请选择文章分类', 
	         'title.require' =>'请输入文章标题',
	         'content.require' =>'请输入文章内容',   
	        ];
	         $error = $this->checkSubmit($param,$rule,$msg);  //调用common 公共控制器中的 checkSubmit 方法
	       if($error){
	              return error_json($error);
	         } 

          $data['cid']     = intval($param['cid']);
          $data['title']   = $param['title'];
          $data['content'] = $param['content'];
          $data['tag']     =  get_keywords($data['title'],$data['content'],3); //获得标签
      
          $thumbArr        =  get_images_url(htmlspecialchars_decode($data['content'])); //自动提取图片
          if(empty($thumbArr)){
             return error_json('正文中至少插入一张图片');
          }
            if(is_array($thumbArr)){
              $data['thumb']  = !empty($thumbArr[0])?$thumbArr[0]:''; //缩略图1
              $data['thumb1'] = !empty($thumbArr[1])?$thumbArr[1]:''; //缩略图2
              $data['thumb2'] = !empty($thumbArr[2])?$thumbArr[2]:''; //缩略图3
            }

          if($param['__token__'] != session('__token__')){
            return error_json('请勿重复提交');
        }  

          session('__token__',null);  //清空session token
          $data['uid']     = $this->user->uid;
          $data['username']  = $this->user->username;
          $data['create_time'] = time();
         
         //检查文章审核状态
         if($this->settings['article']['audit_status'] ==0){
         
          $data['status']     = 1;
          $msg = '发表成功！';

         }else{
           // 需要审核
          $data['status']     = 0;
          $msg = '新闻发布申请已提交，等待审核中！';
         }
          model('article')->addData($data);

          return success_json($msg);
      }else{
      	  return $this->fetch(); 
      }
     
   }

   public function edit(){
      $param = $this->request->param();
   if($this->request->isAjax()){
     //验证
          $rule =[
            'aid' =>'require',
            'cid'=>'require',  
            'title'=>'require',
            'content'=>'require',
            
          ];
          $msg= [
           'aid.require' =>'请求参数错误',
           'cid.require' =>'请选择文章分类', 
           'title.require' =>'请输入文章标题',
           'content.require' =>'请输入文章内容',   
          ];
           $error = $this->checkSubmit($param,$rule,$msg);  //调用common 公共控制器中的 checkSubmit 方法
         if($error){
                return error_json($error);
           } 

          $data['cid']     = intval($param['cid']);
          $data['title']   = $param['title'];
          $data['content'] = $param['content'];
          $data['tag']     =  get_keywords($data['title'],$data['content'],3);
      
          $thumbArr        =  get_images_url(htmlspecialchars_decode($data['content']));
         
          if(is_array($thumbArr)){
              $data['thumb']  = !empty($thumbArr[0])?$thumbArr[0]:''; //缩略图1
              $data['thumb1'] = !empty($thumbArr[1])?$thumbArr[1]:''; //缩略图2
              $data['thumb2'] = !empty($thumbArr[2])?$thumbArr[2]:''; //缩略图3
          }
          $data['uid']     = $this->user->uid;
          $data['author']  = $this->user->username;
          $data['update_time'] = time();
  
      //检查文章审核状态
         if($this->settings['article']['audit_status'] ==0){
         
          $data['status']     = 1;
          $msg = '修改成功，已发表！';

         }else{
           // 需要审核
          $data['status']     = 0;
          $msg = '修改成功，等待审核中！';
         }
          $where['aid'] = intval($param['aid']);
          model('article')->editData($data,$where);

          return success_json($msg);
      }else{
          $where['aid'] = $param['aid'];
          $article =model('article')->infoData($where);
          $this->assign('article',$article);
          return $this->fetch(); 
      }
   }


//删除
   public function del()
   {
     $param = $this->request->param();
   
     if(!$param['aid']){  return error_json('请求参数错误');    }

     $res= $this->delData('article',"aid");
     if($res){
       //删除评论
        model('article_comment')->delData(['article_id'=>$param['aid']]);
       
       //删除收藏
       model('collect')->delData(['article_id'=>$param['aid']]);


      return success_json('删除成功');
     }else{
      return error_json($res);
     }

   }
}
