<?php
// +----------------------------------------------------------------------
// | 奇乐自媒体内容管理系统 免费版 2019
// +----------------------------------------------------------------------
// | 官方网址：http://www.qilecms.com
// +----------------------------------------------------------------------
// | 官方论坛：http://bbs.qilecms.com
// +----------------------------------------------------------------------
// | Author:奇乐网络
// +----------------------------------------------------------------------
// | 版权说明：本产品为免费版，使用请保留底部版权
// +----------------------------------------------------------------------
namespace app\user\controller;
class Set  extends Base
{
   public function initialize()
    {
       parent::initialize();
       $this->isLogin();
    }
    public function index()
    {


      return $this->fetch();
    }

    public function info()
    {

      $param = $this->request->param();
      
       // 验证
        $rule =[    
        'nickname'=>'require',
        'email' =>'require|email',
        ];
        $msg= [
         'nickname.require' =>'昵称不能为空',   
         'email.require' =>'请输入邮箱',
         'email.email' =>'请输入正确的邮箱',

        ];
         $error = $this->checkSubmit($param,$rule,$msg);  //调用common 公共控制器中的 checkSubmit 方法
       if($error){
              return error_json($error);
         }


       
        if($param['mobile'] != $this->user->mobile){
          if(!empty($param['mobile'])){
             $data['mobile']       = $param['mobile'];
             $data['is_mobile']       = 0;
          }
        }

    		$data['nickname'] = addslashes($param['nickname']);
    	
        if($this->user['email'] != $param['email']){
          $data['is_email']  = 0;
          $data['email']  = $param['email'];
        }

    		$data['gender'] = intval($param['gender']);


        $where['uid']   = session('uid');

        if($param['__token__'] != session('__token__')){
            return error_json('请勿重复提交');
       }  

	      model('user')->editData($data,$where);

          session('__token__',null);  //清空session token
	      return success_json('修改成功');

    }

   //修改登陆密码
   public function editPass()
   {
     if($this->request->isAjax()){
         $param = $this->request->param();    

        $rule =[    
          'nowpass'=>'require',
          'pass'=>'require|min:6|max:16',
          'repass'=>'require',
        ];
        $msg= [
         'nowpass.require' =>'请输入当前密码',
         'pass.require' =>'请输入新密码',
         'pass.min' =>'请输入正确的新密码',
         'pass.max' =>'请输入正确的新密码',
         'repass.require' =>'请输入确认密码',   
        ];
         $error = $this->checkSubmit($param,$rule,$msg);  //调用common 公共控制器中的 checkSubmit 方法
       if($error){
              return error_json($error);
         }
       
         if($this->user['password'] != password_key(session('username'),$param['nowpass'],$this->user['passsalt']))
         {
             return error_json('当前密码错误');
         }
         if($param['pass'] !=  $param['repass']){
             return error_json('确认密码错误');
         }
  
         $data['password']    = password_key(session('username'),$param['pass'],$this->user['passsalt']); 
         $where['uid']   = session('uid');
         model('user')->editData($data,$where);

  
         return success_json('密码修改成功');
     }

   }

   //上传头像
   public function avatar()
   {
     if($this->request->isAjax()){
         $param = $this->request->param();    
         $data['avatar'] = $param['avatar'];
         $where['uid']   = session('uid');
         model('user')->editData($data,$where);
         return success_json('头像更新成功');
     }

   }

  public function unbind()
  {
    if($this->request->isAjax()){
     $param =  $this->request->param();
     $id = $param['id'];
     if(empty($param['id']) ){
       return error_json('请求参数不存在');
     }
     if(!is_numeric($param['id'])){
      return error_json('请求参数错误');  
     }
     $where['id'] = $id;
     model('userOauth')->delData($where);
     return success_json('解绑成功');
    }

  }

}
