<?php

use Ebcms\App;

set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    throw new ErrorException($errstr, $errno, 1, $errfile, $errline);
});

set_exception_handler(function (Throwable $e) {
    // 记录错误
    $err = date(DATE_ISO8601) . ' Exception: ' . $e->getMessage() . ' in ' . $e->getFile() . ':' . $e->getLine();
    $log_file = App::getInstance()->getAppPath() . '/runtime/error.' . date('Y-m-d') . '.txt';
    file_put_contents($log_file, $err . PHP_EOL . $e->getTraceAsString() . PHP_EOL . PHP_EOL, FILE_APPEND);

    // 输出提示
    ob_clean();
    header("Content-type: text/html; charset=utf-8");
    die('页面出现错误，已记录！');
});
