<?php

use Ebcms\App;
use Ebcms\RequestHandler;
use Ebcms\StreamFactory;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class Page404 implements MiddlewareInterface
{

    public function process(
        ServerRequestInterface $request,
        RequestHandlerInterface $handler
    ): ResponseInterface {
        $response = $handler->handle($request);
        if ($response->getStatusCode() == 404) {
            $home_url = (function (): string {
                if (
                    (!empty($_SERVER['REQUEST_SCHEME']) && $_SERVER['REQUEST_SCHEME'] == 'https')
                    || (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
                    || (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443')
                ) {
                    $schema = 'https';
                } else {
                    $schema = 'http';
                }

                $script_name = '/' . implode('/', array_filter(explode('/', $_SERVER['SCRIPT_NAME'])));
                $request_uri = parse_url('/' . implode('/', array_filter(explode('/', $_SERVER['REQUEST_URI']))), PHP_URL_PATH);
                if (strpos($request_uri, $script_name) === 0) {
                    return $schema . '://' . $_SERVER['HTTP_HOST'] . $script_name;
                } else {
                    return $schema . '://' . $_SERVER['HTTP_HOST'] . (strlen(dirname($script_name)) > 1 ? dirname($script_name) : '');
                }
            })();
            $html = '
<h1>404</h1>
<p>页面不存在~</p>
<a href="' . $home_url . '">返回首页</a>
';
            return $response->withBody((new StreamFactory())->createStream($html));
        }
        return $response;
    }
}

App::getInstance()->execute(function (
    RequestHandler $requestHandler
) {
    $requestHandler->lazyMiddleware(Page404::class);
});
