{include /common/header}
{if $category['types']}
{php}
$types = explode(' ', $category['types']);
{/php}
<nav class="nav bg-light">
    <a class="nav-link text-muted" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id']])}">全部</a>
    {foreach $types as $t}
    <a class="nav-link text-muted" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id'], 'type'=>$t])}">{$t}</a>
    {/foreach}
</nav>
{/if}
<nav aria-label="breadcrumb" class="mt-3">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{:$router->buildUrl('/xielei/article-web/home/index')}">主页</a></li>
        <li class="breadcrumb-item"><a href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id']])}">{$category.title}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$article['alias']?:$article['id']])}">{$article.title}</a></li>
    </ol>
</nav>
<h1 class="h1 py-2">{$article.title}</h1>
<hr>
<div class="mb-3 text-muted text-monospace"><span class="mr-2">更新时间：{:date('Y-m-d H:i', $article['update_time'])}</span><span>点击：{$article.click}</span></div>
<div class="my-3">{$article['body']}</div>
{if $relations}
<div class="bg-light p-3">
    <div class="h4">相关文章</div>
    <hr>
    <ol class="list-unstyled" style="margin-bottom: 0;">
        {foreach $relations as $vo}
        <li><a href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$vo['alias']?:$vo['id']])}">{$vo.title}</a></li>
        {/foreach}
    </ol>
</div>
{/if}

{include /common/footer}
