{include /common/header}
{if $category['types']}
<?php
$types = explode(' ', $category['types']);
?>
<nav class="nav bg-light">
    <a class="nav-link text-muted" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id']])}">全部</a>
    {foreach $types as $t}
    <a class="nav-link text-muted" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id'], 'type'=>$t])}">{$t}</a>
    {/foreach}
</nav>
{/if}
<nav aria-label="breadcrumb" class="mt-3">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{:$router->buildUrl('/xielei/article-web/home/index')}">主页</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$category['alias']?:$category['id']])}">{$category.title}</a></li>
    </ol>
</nav>
    {if !isset($_GET['page']) || $_GET['page']<=1}
<?php
$stickys = \Ebcms\App::getInstance()->execute(function (\App\Xielei\Article\Model\Article $articleModel) use ($category) {
    return $articleModel->select('*', [
        'sticky' => 1,
        'category_id' => $category['id'],
        'state' => 1,
        'ORDER' => [
            'id' => 'DESC',
        ],
    ]);
});
?>
    {foreach $stickys as $vo} <div class="card my-2 bg-light">
    <div class="card-body">
        <h5 class="card-title"><span class="text-danger font-weight-bold mr-1">✦</span><a class="text-decoration-none stretched-link" href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$vo['alias']?:$vo['id']])}">{$vo.title}</a></h5>
        <p class="card-text">{:mb_substr(strip_tags($vo['body']), 0, 120)}</p>
        <div class="text-muted text-monospace"><span class="mr-2">更新时间：{:date('Y-m-d H:i', $vo['update_time'])}</span><span>点击量：{$vo.click}</span></div>
    </div>
    </div>
    {/foreach}
    {/if}
    {foreach $articles as $vo}
    <div class="card my-2">
        <div class="card-body">
            <h5 class="card-title"><a class="text-decoration-none stretched-link" href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$vo['alias']?:$vo['id']])}">{$vo.title}</a></h5>
            <p class="card-text">{:mb_substr(strip_tags($vo['body']), 0, 120)}</p>
            <div class="text-muted text-monospace"><span class="mr-2">更新时间：{:date('Y-m-d H:i', $vo['update_time'])}</span><span>点击量：{$vo.click}</span></div>
        </div>
    </div>
    {/foreach}
    <nav class="my-3">
        <ul class="pagination">
            {foreach $pagination as $v}
            {if $v=='...'}
            <li class="page-item disabled"><a class="page-link" href="javascript:void(0);">{$v}</a></li>
            {elseif isset($v['current'])}
            <li class="page-item active"><a class="page-link" href="javascript:void(0);">{$v.page}</a></li>
            {else}
            <li class="page-item"><a class="page-link" href="{:$router->buildUrl('/xielei/article-web/home/category', array_merge($input->get(), ['page'=>$v['page']]))}">{$v.page}</a></li>
            {/if}
            {/foreach}
        </ul>
    </nav>
    {include /common/footer}