{include /common/header}
<?php
$article = \Ebcms\App::getInstance()->execute(function (\App\Xielei\Article\Model\Article $articleModel) {
    return $articleModel->get('*', [
        'ORDER' => [
            'id' => 'DESC',
        ],
        'state' => 1,
        'sticky' => 1,
    ]);
});
?>
{if $article}
<div class="jumbotron mt-3">
    <div class="display-4 text-truncate"><a href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$article['alias']?:$article['id']])}">{$article.title}</a></div>
    <hr>
    <p class="lead text-break">{:mb_substr(strip_tags($article['body']), 0, 250)}</p>
</div>
{/if}
<div class="row mt-3">
    <?php
    $categorys = \Ebcms\App::getInstance()->execute(function (\App\Xielei\Article\Model\Category $category) {
        return $category->select('*', [
            'state' => 1,
            'ORDER' => [
                'rank' => 'DESC',
                'id' => 'ASC'
            ],
        ]);
    });
    ?>
    {foreach $categorys as $cate}
    {if !$cate['redirect_uri']}
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-body bg-light border-bottom">
                <div class="h4"><a href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$cate['alias']?:$cate['id']])}">{$cate.title}</a></div>
                {if $cate['types']}
                <?php $types = explode(' ', $cate['types']); ?>
                <div>
                    {foreach $types as $t}
                    <a class="badge badge-pill badge-light" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$cate['alias']?:$cate['id'], 'type'=>$t])}">{$t}</a>
                    {/foreach}
                </div>
                {/if}
            </div>
            <ul class="list-group list-group-flush">
                <?php
                $articles = \Ebcms\App::getInstance()->execute(function (\App\Xielei\Article\Model\Article $articleModel) use ($cate) {
                    return $articleModel->select('*', [
                        'ORDER' => [
                            'id' => 'DESC'
                        ],
                        'LIMIT' => 5,
                        'state' => 1,
                        'category_id' => $cate['id'],
                    ]);
                });
                ?>
                {foreach $articles as $vo}
                <li class="list-group-item"><a href="{:$router->buildUrl('/xielei/article-web/home/article', ['id'=>$vo['alias']?:$vo['id']])}">{$vo.title}</a></li>
                {/foreach}
            </ul>
        </div>
    </div>
    {/if}
    {/foreach}
</div>
{include /common/footer}