{include /common/header}
<?php
$env_err = false;
?>
<?php
// 检查安装环境
function check_env(&$env_err)
{
    $items = array(
        'os' => array('操作系统', '不限制', '类Unix', PHP_OS, true),
        'php' => array('PHP版本', '7.1', '7.1+', PHP_VERSION, true),
        'upload' => array('附件上传', '不限制', '2M+', '未知', true),
        'gd' => array('GD库', '2.0', '2.0+', '未知', true),
        'disk' => array('磁盘空间', '100M', '不限制', '未知', true),
    );

    //PHP环境检测
    if ($items['php'][3] < $items['php'][1]) {
        $items['php'][4] = false;
        $env_err = true;
    }

    //附件上传检测
    if (@ini_get('file_uploads'))
        $items['upload'][3] = ini_get('upload_max_filesize');

    //GD库检测
    $tmp = function_exists('gd_info') ? gd_info() : array();
    if (empty($tmp['GD Version'])) {
        $items['gd'][3] = '未安装';
        $items['gd'][4] = false;
        $env_err = true;
    } else {
        $items['gd'][3] = $tmp['GD Version'];
    }
    unset($tmp);

    //磁盘空间检测
    if (function_exists('disk_free_space')) {
        $items['disk'][3] = floor(disk_free_space(realpath('./') . DIRECTORY_SEPARATOR) / (1024 * 1024)) . 'M';
    }
    return $items;
}
$env = check_env($env_err);
?>
<table class="table">
    <thead>
        <tr>
            <th>检测项</th>
            <th>最低要求</th>
            <th>推荐配置</th>
            <th>当前配置</th>
            <th style="width:120px;">检测结果</th>
        </tr>
    </thead>
    <tbody>
        {foreach $env as $v}
        <tr>
            <td>{$v[0]}</td>
            <td>{$v[1]}</td>
            <td>{$v[2]}</td>
            <td>{$v[3]}</td>
            <td>{$v[4]?'<span class="text-primary">通过</span>':'<span class="text-danger">不通过</span>'}</td>
        </tr>
        {/foreach}
    </tbody>
</table>
<?php
/**
 * 目录，文件读写检测
 * @return array 检测数据
 */
function check_dirfile(&$env_err)
{
    $app_path = \Ebcms\App::getInstance()->getAppPath();

    $items = array(
        array('dir', '可写', true, './uploads'),
        array('dir', '可写', true, $app_path . '/runtime'),
        array('file', '可写', true, $app_path . '/config/xielei/database/database.php'),
        array('file', '可写', true, $app_path . '/config/xielei/admin/managers.php'),
        array('file', '可写', true, $app_path . '/install.sql'),
    );

    foreach ($items as &$val) {
        $item = $val[3];
        if ('dir' == $val[0]) {
            if (!is_writable($item)) {
                if (is_dir($item)) {
                    $val[1] = '可读';
                    $val[2] = false;
                    $env_err = true;
                } else {
                    $val[1] = '不存在';
                    $val[2] = false;
                    $env_err = true;
                }
            }
        } else {
            if (file_exists($item)) {
                if (!is_writable($item)) {
                    $val[1] = '不可写';
                    $val[2] = false;
                    $env_err = true;
                }
            } else {
                if (!is_writable(dirname($item))) {
                    $val[1] = '不存在';
                    $val[2] = false;
                    $env_err = true;
                }
            }
        }
    }

    return $items;
}
$dirfile = check_dirfile($env_err);
?>
<table class="table">
    <thead>
        <tr>
            <th>检测项</th>
            <th>要求</th>
            <th>当前配置</th>
            <th style="width:120px;">检测结果</th>
        </tr>
    </thead>
    <tbody>
        {foreach $dirfile as $v}
        <tr>
            <td>{$v[3]}</td>
            <td>可读可写</td>
            <td>{$v[1]}</td>
            <td>{$v[2]?'<span class="text-primary">通过</span>':'<span class="text-danger">不通过</span>'}</td>
        </tr>
        {/foreach}
    </tbody>
</table>
<?php
/**
 * 函数检测
 * @return array 检测数据
 */
function check_func(&$env_err)
{
    $items = array(
        array('pdo', '支持', true, '类'),
        array('pdo_mysql', '支持', true, '模块'),
        array('file_get_contents', '支持', true, '函数'),
        array('mb_strlen', '支持', true, '函数'),
        array('curl_init', '支持', true, '函数'),
    );

    foreach ($items as &$val) {
        if (('类' == $val[3] && !class_exists($val[0])) || ('模块' == $val[3] && !extension_loaded($val[0])) || ('函数' == $val[3] && !function_exists($val[0]))) {
            $val[1] = '不支持';
            $val[2] = 'error';
            $env_err = true;
        }
    }

    return $items;
}
$func = check_func($env_err);
?>
<table class="table">
    <thead>
        <tr>
            <th>检测项</th>
            <th>要求</th>
            <th>当前配置</th>
            <th style="width:120px;">检测结果</th>
        </tr>
    </thead>
    <tbody>
        {foreach $func as $v}
        <tr>
            <td>{$v[0]}</td>
            <td>支持</td>
            <td>{$v[1]}</td>
            <td>{$v[2]?'<span class="text-primary">通过</span>':'<span class="text-danger">不通过</span>'}</td>
        </tr>
        {/foreach}
    </tbody>
</table>
<hr>
{if !$env_err}
<div class="alert alert-primary" role="alert">
    <h4 class="alert-heading">检测通过</h4>
    <div>好极了，此软件可以安装到您的设备上！</div>
</div>
<a class="btn btn-light" href="{:$router->buildUrl('/xielei/installer/index', ['step'=>1])}" role="button">上一步</a>
<a class="btn btn-primary" href="{:$router->buildUrl('/xielei/installer/index', ['step'=>3])}" role="button">下一步</a>
{else}
<div class="alert alert-warning" role="alert">
    <h4 class="alert-heading">未通过检测</h4>
    <div>很抱歉，部分项目未达到此产品的最低安装需求，请处理后重新检测！</div>
</div>
<a class="btn btn-light" href="{:$router->buildUrl('/xielei/installer/index', ['step'=>1])}" role="button">上一步</a>
<a class="btn btn-warning" href="{:$router->buildUrl('/xielei/installer/index', ['step'=>2])}" role="button">重新检测</a>
{/if}
{include /common/footer}